/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.AbstractCreateSearchGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MetaSearchFacade;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.MapSearchEvent;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.PNode;
import java.awt.Component;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.MissingResourceException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class MetaSearchCreateSearchGeometryListener
extends AbstractCreateSearchGeometryListener
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(MetaSearchCreateSearchGeometryListener.class);
    private MetaSearchFacade metaSearch;

    public MetaSearchCreateSearchGeometryListener(MappingComponent mc) {
        super(mc, "SEARCH_POLYGON");
    }

    public MetaSearchCreateSearchGeometryListener(MappingComponent mc, MetaSearchFacade metaSearch) {
        this(mc);
        this.setMetaSearch(metaSearch);
    }

    public final void setMetaSearch(MetaSearchFacade metaSearch) {
        this.metaSearch = metaSearch;
    }

    private boolean isSearchTopicsSelected() {
        boolean result = false;
        if (this.metaSearch != null) {
            result = this.metaSearch.hasSelectedSearchTopics();
        }
        return result;
    }

    private void notifyUserAboutMissingSearchTopics() throws HeadlessException, MissingResourceException {
        if (!this.isSearchTopicsSelected()) {
            if (this.metaSearch != null && this.metaSearch.hasSearchTopics()) {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)CismapBroker.getInstance().getMappingComponent())), NbBundle.getMessage(MetaSearchCreateSearchGeometryListener.class, (String)"CreateSearchGeometryListener.mousePressed(PInputEvent).JOptionPane().noSearchTopicsChosen"), NbBundle.getMessage(MetaSearchCreateSearchGeometryListener.class, (String)"CreateSearchGeometryListener.mousePressed(PInputEvent).JOptionPane().noSearchTopicsChosen.title"), 0);
            } else {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)CismapBroker.getInstance().getMappingComponent())), NbBundle.getMessage(MetaSearchCreateSearchGeometryListener.class, (String)"CreateSearchGeometryListener.mousePressed(PInputEvent).JOptionPane().notInitialized"), NbBundle.getMessage(MetaSearchCreateSearchGeometryListener.class, (String)"CreateSearchGeometryListener.mousePressed(PInputEvent).JOptionPane().notInitialized.title"), 0);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.metaSearch != null && this.metaSearch.isSearchTopicSelectedEvent(evt.getPropertyName())) {
            this.generateAndShowPointerAnnotation();
        }
    }

    @Override
    protected boolean performSearch(SearchFeature searchFeature) {
        if (!this.isSearchTopicsSelected()) {
            this.notifyUserAboutMissingSearchTopics();
            return false;
        }
        MapSearchEvent mse = new MapSearchEvent();
        mse.setGeometry(searchFeature.getGeometry());
        CismapBroker.getInstance().fireMapSearchInited(mse);
        return true;
    }

    @Override
    protected PNode getPointerAnnotation() {
        if (this.metaSearch == null) {
            return null;
        }
        return this.metaSearch.generatePointerAnnotationForSelectedSearchTopics();
    }
}

