/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.Highlightable;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.RequestForNonreflectingFeature;
import de.cismet.cismap.commons.features.RequestForUnaddableHandles;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.AddHandleDialog;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PHandle;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PFeatureTools;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class SimpleMoveListener
extends PBasicInputEventHandler {
    public static final String COORDINATES_CHANGED = "COORDINATES_CHANGED";
    private static final Logger LOG = Logger.getLogger(SimpleMoveListener.class);
    private static Color COLOR_ADD_HANDLE = new Color(255, 0, 0, 150);
    private static Color COLOR_REFLECT_HANDLE = new Color(205, 133, 0, 150);
    Highlightable highlighted = null;
    Object handleHighlightingStuff = new Object();
    private final MappingComponent mappingComponent;
    private PFeature underlyingObject = null;
    private int entityPosition;
    private int ringPosition;
    private int coordPosition = 0;
    private double xCoord = -1.0;
    private double yCoord = -1.0;
    private float handleX = Float.MIN_VALUE;
    private float handleY = Float.MIN_VALUE;
    private PHandle newPointHandle = null;
    private PFeature pFeature = null;
    private PLocator locator = null;
    private PNode pointerAnnotation = new PNode();
    private PPath snapRect = PPath.createRectangle((float)0.0f, (float)0.0f, (float)20.0f, (float)20.0f);
    private boolean annotationNodeVisible = false;
    private double underlyingObjectHalo = 0.0;
    private boolean deepSeekEnabled = false;

    public SimpleMoveListener(MappingComponent mc) {
        this.mappingComponent = mc;
        mc.getCamera().addChild(this.pointerAnnotation);
        mc.getCamera().addChild((PNode)this.snapRect);
        this.snapRect.setStroke(null);
        this.snapRect.setTransparency(0.2f);
        this.snapRect.setVisible(false);
    }

    public void mouseMoved(final PInputEvent event) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    block26: {
                        WorldToScreenTransform wtst;
                        SimpleMoveListener.this.underlyingObject = null;
                        PNode o = SimpleMoveListener.this.underlyingObjectHalo > 0.0 ? PFeatureTools.getFirstValidObjectUnderPointer2(event, new Class[]{PFeature.class}, SimpleMoveListener.this.underlyingObjectHalo) : PFeatureTools.getFirstValidObjectUnderPointer(event, new Class[]{PFeature.class}, SimpleMoveListener.this.deepSeekEnabled);
                        if (o instanceof PFeature) {
                            SimpleMoveListener.this.underlyingObject = (PFeature)o;
                        }
                        if (SimpleMoveListener.this.underlyingObject != null && SimpleMoveListener.this.mappingComponent.getInteractionMode().equals("SELECT") && (!(SimpleMoveListener.this.underlyingObject.getFeature() instanceof RequestForUnaddableHandles) && SimpleMoveListener.this.mappingComponent.getHandleInteractionMode().equals("ADD_HANDLE") || !(SimpleMoveListener.this.underlyingObject.getFeature() instanceof RequestForNonreflectingFeature) && SimpleMoveListener.this.mappingComponent.getHandleInteractionMode().equals("REFLECT_POLYGON")) && SimpleMoveListener.this.mappingComponent.getFeatureCollection() instanceof DefaultFeatureCollection) {
                            if (!SimpleMoveListener.this.newPointHandleExists()) {
                                SimpleMoveListener.this.createNewPointHandle();
                            }
                            if (!(SimpleMoveListener.this.underlyingObject.getFeature() instanceof RequestForUnaddableHandles) && SimpleMoveListener.this.mappingComponent.getHandleInteractionMode().equals("ADD_HANDLE")) {
                                SimpleMoveListener.this.newPointHandle.setPaint(COLOR_ADD_HANDLE);
                            } else if (!(SimpleMoveListener.this.underlyingObject.getFeature() instanceof RequestForNonreflectingFeature) && SimpleMoveListener.this.mappingComponent.getHandleInteractionMode().equals("REFLECT_POLYGON")) {
                                SimpleMoveListener.this.newPointHandle.setPaint(COLOR_REFLECT_HANDLE);
                            }
                            if (event.isAltDown()) {
                                SimpleMoveListener.this.handleX = (float)event.getPosition().getX();
                                SimpleMoveListener.this.handleY = (float)event.getPosition().getY();
                            } else {
                                Collection sel = ((DefaultFeatureCollection)SimpleMoveListener.this.mappingComponent.getFeatureCollection()).getSelectedFeatures();
                                Point2D trigger = event.getPosition();
                                Point2D[] neighbours = SimpleMoveListener.this.getNearestNeighbours(trigger, sel);
                                Point2D p0 = neighbours[0];
                                Point2D p1 = neighbours[1];
                                if (p0 != null && p1 != null) {
                                    if (event.isShiftDown()) {
                                        Point2D.Double p0i1 = new Point2D.Double(p0.getX(), p1.getY());
                                        Point2D.Double p1i0 = new Point2D.Double(p1.getX(), p0.getY());
                                        Line2D.Double lOrig = new Line2D.Double(p0, p1);
                                        Line2D.Double lInversed = new Line2D.Double(p0i1, p1i0);
                                        Point2D.Double erg = StaticGeometryFunctions.createIntersectionPoint((Line2D)lOrig, (Line2D)lInversed);
                                        SimpleMoveListener.this.handleX = (float)((Point2D)erg).getX();
                                        SimpleMoveListener.this.handleY = (float)((Point2D)erg).getY();
                                    } else {
                                        Point2D erg = StaticGeometryFunctions.createPointOnLine((Point2D)p0, (Point2D)p1, (Point2D)trigger);
                                        SimpleMoveListener.this.handleX = (float)erg.getX();
                                        SimpleMoveListener.this.handleY = (float)erg.getY();
                                    }
                                }
                                boolean found = false;
                                for (Object po : SimpleMoveListener.this.mappingComponent.getHandleLayer().getChildrenReference()) {
                                    if (!(po instanceof PHandle) || (PHandle)((Object)po) != SimpleMoveListener.this.newPointHandle) continue;
                                    found = true;
                                }
                                if (!found) {
                                    SimpleMoveListener.this.mappingComponent.getHandleLayer().addChild((PNode)SimpleMoveListener.this.newPointHandle);
                                    LOG.info((Object)"tempor\u00e4res Handle eingef\u00fcgt");
                                }
                                SimpleMoveListener.this.newPointHandle.relocateHandle();
                            }
                        }
                        if ((wtst = SimpleMoveListener.this.mappingComponent.getWtst()) == null) {
                            return;
                        }
                        SimpleMoveListener.this.xCoord = wtst.getSourceX(event.getPosition().getX() - SimpleMoveListener.this.mappingComponent.getClip_offset_x());
                        SimpleMoveListener.this.yCoord = wtst.getSourceY(event.getPosition().getY() - SimpleMoveListener.this.mappingComponent.getClip_offset_y());
                        SimpleMoveListener.this.refreshPointerAnnotation(event);
                        SimpleMoveListener.this.postCoordinateChanged();
                        try {
                            SimpleMoveListener.this.mappingComponent.getSnapHandleLayer().removeAllChildren();
                        }
                        catch (Exception e) {
                            if (!LOG.isDebugEnabled()) break block26;
                            LOG.debug((Object)"Fehler beim entfernen der SnappingVisualisierung", (Throwable)e);
                        }
                    }
                    if (SimpleMoveListener.this.mappingComponent.isVisualizeSnappingEnabled()) {
                        PFeatureTools.SnappedPoint snappedPoint = PFeatureTools.getNearestPointInArea(SimpleMoveListener.this.mappingComponent, event.getCanvasPosition(), true, null);
                        if (!PFeatureTools.SnappedPoint.SnappedOn.NOTHING.equals((Object)snappedPoint.getSnappedOn())) {
                            Point2D nearestPoint = snappedPoint.getPoint();
                            SimpleMoveListener.this.mappingComponent.getCamera().viewToLocal(nearestPoint);
                            PPath show = PPath.createEllipse((float)((float)(nearestPoint.getX() - 3.0)), (float)((float)(nearestPoint.getY() - 3.0)), (float)6.0f, (float)6.0f);
                            switch (snappedPoint.getSnappedOn()) {
                                case POINT: {
                                    show.setPaint((Paint)Color.BLACK);
                                    break;
                                }
                                case LINE: {
                                    show.setPaint((Paint)Color.GRAY);
                                }
                            }
                            SimpleMoveListener.this.mappingComponent.getSnapHandleLayer().addChild((PNode)show);
                        }
                        if (SimpleMoveListener.this.mappingComponent.isVisualizeSnappingRectEnabled()) {
                            SimpleMoveListener.this.snapRect.setVisible(true);
                            SimpleMoveListener.this.snapRect.setPathToRectangle((float)((int)event.getCanvasPosition().getX() - SimpleMoveListener.this.mappingComponent.getSnappingRectSize() / 2), (float)((int)event.getCanvasPosition().getY() - SimpleMoveListener.this.mappingComponent.getSnappingRectSize() / 2), (float)SimpleMoveListener.this.mappingComponent.getSnappingRectSize(), (float)SimpleMoveListener.this.mappingComponent.getSnappingRectSize());
                        } else {
                            SimpleMoveListener.this.snapRect.setVisible(false);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)"Fehler beim Moven \u00fcber die Karte ", (Throwable)e);
                }
                SimpleMoveListener.this.handleHighlightingStuff(event);
            }
        };
        EventQueue.invokeLater(t);
    }

    public void setDeepSeekEnabled(boolean deepSeekEnabled) {
        this.deepSeekEnabled = deepSeekEnabled;
    }

    private boolean newPointHandleExists() {
        return this.locator != null && this.newPointHandle != null;
    }

    private void createNewPointHandle() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"create newPointHandle and Locator");
        }
        this.locator = new PLocator(){

            public double locateX() {
                return SimpleMoveListener.this.handleX;
            }

            public double locateY() {
                return SimpleMoveListener.this.handleY;
            }
        };
        this.newPointHandle = new PHandle(this.locator, this.mappingComponent){

            @Override
            public void handleClicked(PInputEvent e) {
                SimpleMoveListener.this.mouseClicked(e);
            }
        };
    }

    private Point2D[] getNearestNeighbours(Point2D trigger, Collection sel) {
        Point2D.Double start = null;
        Point2D.Double end = null;
        double dist = Double.POSITIVE_INFINITY;
        for (Object o : sel) {
            Geometry geometry;
            if (!(o instanceof Feature)) continue;
            Feature feature = (Feature)o;
            PFeature pfeature = this.mappingComponent.getPFeatureHM().get(feature);
            if (pfeature == null || !((geometry = pfeature.getFeature().getGeometry()) instanceof Polygon) && !(geometry instanceof LineString) && !(geometry instanceof MultiPolygon)) continue;
            for (int entityIndex = 0; entityIndex < pfeature.getNumOfEntities(); ++entityIndex) {
                for (int ringIndex = 0; ringIndex < pfeature.getNumOfRings(entityIndex); ++ringIndex) {
                    float[] xp = pfeature.getXp(entityIndex, ringIndex);
                    float[] yp = pfeature.getYp(entityIndex, ringIndex);
                    for (int i = 0; i < xp.length - 1; ++i) {
                        Point2D.Double tmpStart = new Point2D.Double(xp[i], yp[i]);
                        Point2D.Double tmpEnd = new Point2D.Double(xp[i + 1], yp[i + 1]);
                        double tmpDist = StaticGeometryFunctions.distanceToLine((Point2D)tmpStart, (Point2D)tmpEnd, (Point2D)trigger);
                        if (!(tmpDist < dist)) continue;
                        dist = tmpDist;
                        start = tmpStart;
                        end = tmpEnd;
                        this.pFeature = pfeature;
                        this.entityPosition = entityIndex;
                        this.ringPosition = ringIndex;
                        this.coordPosition = i + 1;
                    }
                }
            }
        }
        Point2D[] erg = new Point2D[]{start, end};
        return erg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHighlightingStuff(PInputEvent event) {
        Object object = this.handleHighlightingStuff;
        synchronized (object) {
            PNode o = PFeatureTools.getFirstValidObjectUnderPointer(event, new Class[]{PFeature.class, PHandle.class}, this.deepSeekEnabled);
            try {
                PNode n = o;
                this.setMouseCursorAccordingToMode(n);
                if (CismapBroker.getInstance().isHighlightFeatureOnMouseOver()) {
                    if (n instanceof Highlightable) {
                        if (this.highlighted != null) {
                            this.highlighted.setHighlighting(false);
                        }
                        ((Highlightable)n).setHighlighting(true);
                        this.highlighted = (Highlightable)n;
                    } else if (this.highlighted != null) {
                        this.highlighted.setHighlighting(false);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Fehler beim Highlighten", (Throwable)e);
            }
        }
    }

    private void postCoordinateChanged() {
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(COORDINATES_CHANGED, (Object)this);
    }

    private void setMouseCursorAccordingToMode(PNode n) {
        Cursor c = null;
        c = n instanceof PHandle ? this.mappingComponent.getCursor(this.mappingComponent.getHandleInteractionMode()) : this.mappingComponent.getCursor(this.mappingComponent.getInteractionMode());
        if (c != null && this.mappingComponent.getCursor() != c) {
            this.mappingComponent.setCursor(c);
        }
    }

    public void mouseClicked(PInputEvent event) {
        try {
            if (event.getClickCount() == 2 && this.mappingComponent.getInteractionMode().equals("SELECT") && this.pFeature != null && this.pFeature.isSelected()) {
                Collection sel = ((DefaultFeatureCollection)this.mappingComponent.getFeatureCollection()).getSelectedFeatures();
                if (!(this.pFeature.getFeature() instanceof RequestForUnaddableHandles) && this.mappingComponent.getHandleInteractionMode().equals("ADD_HANDLE")) {
                    Point2D.Float newPoint = new Point2D.Float(this.handleX, this.handleY);
                    Point2D[] neighbours = this.getNearestNeighbours(newPoint, sel);
                    Point2D p0 = neighbours[0];
                    Point2D p1 = neighbours[1];
                    if (p0 != null && p1 != null && event.isControlDown()) {
                        Point2D rightNeighbour;
                        Point2D leftNeighbour;
                        if (p0.getX() < p1.getX()) {
                            leftNeighbour = p0;
                            rightNeighbour = p1;
                        } else if (p1.getX() < p0.getX()) {
                            leftNeighbour = p1;
                            rightNeighbour = p0;
                        } else if (p0.getY() <= p1.getY()) {
                            leftNeighbour = p0;
                            rightNeighbour = p1;
                        } else {
                            leftNeighbour = p1;
                            rightNeighbour = p0;
                        }
                        Double distanceLeft = leftNeighbour.distance(newPoint);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("distanceLeft: " + distanceLeft));
                        }
                        Double distanceTotal = leftNeighbour.distance(rightNeighbour);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("distanceTotal: " + distanceTotal));
                        }
                        AddHandleDialog dialog = AddHandleDialog.getInstance();
                        dialog.setDistanceTotal(distanceTotal);
                        dialog.setDistanceToLeft(distanceLeft);
                        StaticSwingTools.showDialog((JDialog)dialog);
                        if (dialog.getReturnStatus() == 0) {
                            distanceLeft = dialog.getDistanceToLeft() < dialog.getDistanceToRight() ? Double.valueOf(dialog.getDistanceToLeft()) : Double.valueOf(distanceTotal - dialog.getDistanceToRight());
                            Double d = distanceLeft = distanceLeft > distanceTotal ? distanceTotal : distanceLeft;
                            if (distanceTotal != 0.0) {
                                this.handleX = (float)(leftNeighbour.getX() + (rightNeighbour.getX() - leftNeighbour.getX()) * (distanceLeft / distanceTotal));
                                this.handleY = (float)(leftNeighbour.getY() + (rightNeighbour.getY() - leftNeighbour.getY()) * (distanceLeft / distanceTotal));
                            } else {
                                this.handleX = (float)leftNeighbour.getX();
                                this.handleY = (float)leftNeighbour.getY();
                            }
                        } else {
                            super.mouseClicked(event);
                            return;
                        }
                    }
                    this.pFeature.insertCoordinate(this.entityPosition, this.ringPosition, this.coordPosition, this.handleX, this.handleY);
                } else if (!(this.pFeature.getFeature() instanceof RequestForNonreflectingFeature) && this.mappingComponent.getHandleInteractionMode().equals("REFLECT_POLYGON")) {
                    this.reflectFeature(this.pFeature, this.entityPosition, this.ringPosition, this.coordPosition - 1, this.coordPosition);
                }
                this.mappingComponent.getMemRedo().clear();
                this.resetAfterClick();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Anlegen von neuer Koordinate und Handle", (Throwable)ex);
        }
        super.mouseClicked(event);
    }

    private void reflectFeature(PFeature pf, int entityPosition, int ringPosition, int leftCoordPosition, int rightCoordPosition) {
        AbstractNewFeature.geomTypes geomType;
        Geometry origGeom = pf.getFeature().getGeometry();
        Coordinate[] coordArr = pf.getCoordArr(entityPosition, ringPosition);
        Geometry reflectGeom = AffineTransformation.reflectionInstance((double)coordArr[leftCoordPosition].x, (double)coordArr[leftCoordPosition].y, (double)coordArr[rightCoordPosition].x, (double)coordArr[rightCoordPosition].y).transform(origGeom);
        PureNewFeature reflectFeature = new PureNewFeature(reflectGeom);
        if (pf.getFeature() instanceof PureNewFeature) {
            PureNewFeature origPureNewFeature = (PureNewFeature)pf.getFeature();
            geomType = origPureNewFeature.getGeometryType();
        } else {
            geomType = reflectGeom instanceof MultiPolygon ? AbstractNewFeature.geomTypes.MULTIPOLYGON : (reflectGeom instanceof Polygon ? AbstractNewFeature.geomTypes.POLYGON : (reflectGeom instanceof LineString ? AbstractNewFeature.geomTypes.LINESTRING : (reflectGeom instanceof Point ? AbstractNewFeature.geomTypes.POINT : AbstractNewFeature.geomTypes.UNKNOWN)));
        }
        reflectFeature.setGeometryType(geomType);
        reflectFeature.setEditable(true);
        this.mappingComponent.getFeatureCollection().addFeature(reflectFeature);
        this.mappingComponent.getFeatureCollection().holdFeature(reflectFeature);
    }

    private void resetAfterClick() {
        this.newPointHandle = null;
        this.handleX = Float.MIN_VALUE;
        this.handleY = Float.MIN_VALUE;
        this.coordPosition = 0;
        this.pFeature = null;
    }

    public void mouseDragged(PInputEvent event) {
        super.mouseDragged(event);
        this.refreshPointerAnnotation(event);
    }

    public void mouseEntered(PInputEvent event) {
        super.mouseEntered(event);
        if (this.pointerAnnotation != null) {
            this.refreshPointerAnnotation(event);
            this.pointerAnnotation.setVisible(this.annotationNodeVisible);
        }
    }

    public void mouseExited(PInputEvent event) {
        super.mouseExited(event);
        if (this.pointerAnnotation != null) {
            this.pointerAnnotation.setVisible(false);
        }
    }

    private void refreshPointerAnnotation(PInputEvent event) {
        if (this.pointerAnnotation != null) {
            this.pointerAnnotation.setOffset(event.getCanvasPosition().getX() + 20.0, event.getCanvasPosition().getY() + 20.0);
        }
    }

    public double getXCoord() {
        return this.xCoord;
    }

    public double getYCoord() {
        return this.yCoord;
    }

    public double getCurrentOGCScale() {
        return this.mappingComponent.getCurrentOGCScale();
    }

    public PFeature getUnderlyingPFeature() {
        return this.underlyingObject;
    }

    public boolean isAnnotationNodeVisible() {
        return this.annotationNodeVisible;
    }

    public void setAnnotationNodeVisible(boolean annotationNodeVisible) {
        this.annotationNodeVisible = annotationNodeVisible;
        if (this.pointerAnnotation != null) {
            block4: {
                try {
                    this.mappingComponent.getCamera().removeChild(this.pointerAnnotation);
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)"no child to remove", (Throwable)ex);
                }
            }
            if (annotationNodeVisible) {
                this.mappingComponent.getCamera().addChild(this.pointerAnnotation);
                this.pointerAnnotation.setVisible(true);
            }
        }
    }

    public PNode getPointerAnnotation() {
        return this.pointerAnnotation;
    }

    public void setPointerAnnotation(PNode pointerAnnotation) {
        this.setAnnotationNodeVisible(false);
        this.pointerAnnotation = pointerAnnotation;
    }

    public void setUnderlyingObjectHalo(double underlyingObjectHalo) {
        this.underlyingObjectHalo = underlyingObjectHalo;
    }

    public double getUnderlyingObjectHalo() {
        return this.underlyingObjectHalo;
    }
}

