/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SimpleSingleSelectionListener
extends PBasicInputEventHandler {
    public static final String SELECTION_CHANGED_NOTIFICATION = "SELECTION_CHANGED_NOTIFICATION";
    PFeature sel = null;
    MappingComponent mc = null;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private int clickCount = 0;

    public void mouseClicked(PInputEvent pInputEvent) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mouseClicked():" + pInputEvent.getPickedNode()));
        }
        PNode o = PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, new Class[]{PFeature.class}, true);
        this.clickCount = pInputEvent.getClickCount();
        if (pInputEvent.getComponent() instanceof MappingComponent) {
            this.mc = (MappingComponent)pInputEvent.getComponent();
        }
        if (pInputEvent.getButton() == 3) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"right mouseclick");
            }
            if (o instanceof PFeature && ((PFeature)o).getFeature() instanceof XStyledFeature) {
                XStyledFeature xf = (XStyledFeature)((PFeature)o).getFeature();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"valid object under pointer");
                }
                JPopupMenu popup = new JPopupMenu(NbBundle.getMessage(SimpleSingleSelectionListener.class, (String)"SimpleSingleSelectionListener.popup.text"));
                JMenuItem m = new JMenuItem(NbBundle.getMessage(SimpleSingleSelectionListener.class, (String)"SimpleSingleSelectionListener.m.text"));
                m.setIcon(xf.getIconImage());
                popup.add(m);
                popup.show((Component)((Object)this.mc), (int)pInputEvent.getCanvasPosition().getX(), (int)pInputEvent.getCanvasPosition().getY());
            }
        } else if (o instanceof PFeature) {
            super.mouseClicked(pInputEvent);
            this.sel = (PFeature)o;
            this.postSelectionChanged();
        }
    }

    private void postSelectionChanged() {
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(SELECTION_CHANGED_NOTIFICATION, (Object)this);
        if (this.mc != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"unselectAll in postSelectionChanged()");
            }
            this.mc.getFeatureCollection().select(this.sel.getFeature());
        }
    }

    public PFeature getSelectedPFeature() {
        return this.sel;
    }

    public int getClickCount() {
        return this.clickCount;
    }
}

