/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener.actions;

import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import edu.umd.cs.piccolo.util.PDimension;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class FeatureMoveAction
implements CustomAction {
    private final Logger log = Logger.getLogger(this.getClass());
    private MappingComponent mc;
    private List<PFeature> features;
    private PDimension dim;

    public FeatureMoveAction(MappingComponent mc, List<PFeature> features, PDimension dim, boolean dimensionInPixel) {
        this.mc = mc;
        this.features = features;
        this.dim = dimensionInPixel ? this.createDimension(dim, false) : dim;
    }

    @Override
    public void doAction() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("X=" + this.dim.getWidth()));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Y=" + this.dim.getHeight()));
        }
        for (PFeature o : this.features) {
            if (!o.getFeature().isEditable() || !o.getFeature().canBeSelected()) continue;
            PFeature f = o;
            f = this.mc.getPFeatureHM().get(f.getFeature());
            if (f == null) continue;
            f.moveFeature(this.createDimension(this.dim, true));
            if (!(this.mc.getFeatureCollection() instanceof DefaultFeatureCollection)) continue;
            Vector<Feature> v = new Vector<Feature>();
            v.add(f.getFeature());
            ((DefaultFeatureCollection)this.mc.getFeatureCollection()).fireFeaturesChanged(v);
        }
    }

    @Override
    public String info() {
        return NbBundle.getMessage(FeatureMoveAction.class, (String)"FeatureMoveAction.info().return", (Object[])new Object[]{this.dim.getWidth(), this.dim.getHeight()});
    }

    @Override
    public CustomAction getInverse() {
        PDimension inverseDim = new PDimension(this.dim.getWidth() * -1.0, this.dim.getHeight() * -1.0);
        return new FeatureMoveAction(this.mc, this.features, inverseDim, false);
    }

    private PDimension createDimension(PDimension dim, boolean toPixel) {
        double scale = this.mc.getCamera().getViewScale();
        PDimension newDim = toPixel ? new PDimension(dim.getWidth() * scale, dim.getHeight() * scale) : new PDimension(dim.getWidth() / scale, dim.getHeight() / scale);
        return newDim;
    }

    @Override
    public boolean featureConcerned(Feature feature) {
        for (PFeature f : this.features) {
            if (!f.getFeature().equals(feature)) continue;
            return true;
        }
        return false;
    }
}

