/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener.actions;

import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureAddEntityAction;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureCreateAction;
import org.openide.util.NbBundle;

public class FeatureRemoveEntityAction
implements CustomAction {
    private Feature f;
    private MappingComponent mc;
    private Polygon entity;

    public FeatureRemoveEntityAction(MappingComponent mc, Feature f, Polygon entity) {
        this.entity = entity;
        this.mc = mc;
        this.f = f;
    }

    @Override
    public void doAction() {
        PFeature pf = this.mc.getPFeatureHM().get(this.f);
        if (pf != null) {
            int entryPosition = pf.getEntityPositionUnderPoint(this.entity.getExteriorRing().getStartPoint());
            pf.removeEntity(entryPosition);
        }
    }

    @Override
    public String info() {
        return NbBundle.getMessage(FeatureCreateAction.class, (String)"FeatureRemoveEntityAction.info().return");
    }

    @Override
    public CustomAction getInverse() {
        return new FeatureAddEntityAction(this.mc, this.f, this.entity);
    }

    @Override
    public boolean featureConcerned(Feature feature) {
        return this.f != null && this.f.equals(feature);
    }
}

