/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener.actions;

import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Vector;
import org.openide.util.NbBundle;

public class FeatureRotateAction
implements CustomAction {
    private MappingComponent mc;
    private double rot;
    private Point2D pivot;
    private Collection<Feature> arr;

    public FeatureRotateAction(MappingComponent mc, Collection<Feature> arr, Point2D pivot, double rot) {
        this.mc = mc;
        this.arr = arr;
        this.pivot = pivot;
        this.rot = rot;
    }

    @Override
    public void doAction() {
        Vector<Feature> v = new Vector<Feature>();
        for (Feature o : this.arr) {
            PFeature pf = this.mc.getPFeatureHM().get(o);
            v.add(pf.getFeature());
            pf.rotateAllPoints(this.rot, this.pivot);
            pf.syncGeometry();
        }
        ((DefaultFeatureCollection)this.mc.getFeatureCollection()).fireFeaturesChanged(v);
        this.mc.showHandles(false);
    }

    @Override
    public String info() {
        StringBuffer sb = new StringBuffer();
        for (Feature o : this.arr) {
            sb.append(o.hashCode() + ", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return NbBundle.getMessage(FeatureRotateAction.class, (String)"FeatureRotateAction.info().return", (Object[])new Object[]{sb.toString(), Math.toDegrees(this.rot)});
    }

    @Override
    public FeatureRotateAction getInverse() {
        return new FeatureRotateAction(this.mc, this.arr, this.pivot, this.rot * -1.0);
    }

    @Override
    public boolean featureConcerned(Feature feature) {
        for (Feature o : this.arr) {
            if (!o.equals(feature)) continue;
            return true;
        }
        return false;
    }
}

