/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener.actions;

import Sirius.util.collections.MultiMap;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import org.openide.util.NbBundle;

public class HandleMoveAction
implements CustomAction {
    private MultiMap gluedCoordinates = null;
    private PFeature pf;
    private final int entityPosition;
    private final int ringPosition;
    private final int coordPosition;
    private float startX;
    private float startY;
    private float endX;
    private float endY;
    private boolean isGluedAction;

    public HandleMoveAction(int entityPosition, int ringPosition, int coordPosition, PFeature pf, float startX, float startY, float endX, float endY, boolean isGlued) {
        this.entityPosition = entityPosition;
        this.ringPosition = ringPosition;
        this.coordPosition = coordPosition;
        this.pf = pf;
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
        this.isGluedAction = isGlued;
    }

    @Override
    public void doAction() {
        if (this.isGluedAction) {
            this.gluedCoordinates = this.pf.checkforGlueCoords(this.entityPosition, this.ringPosition, this.coordPosition);
        }
        this.pf.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, this.coordPosition, this.startX, this.startY);
        if (this.gluedCoordinates != null) {
            Set pFeatureSet = this.gluedCoordinates.keySet();
            for (PFeature gluePFeature : pFeatureSet) {
                Collection coordinates;
                if (!gluePFeature.getFeature().isEditable() || (coordinates = (Collection)this.gluedCoordinates.get((Object)gluePFeature)) == null) continue;
                for (Object o : coordinates) {
                    int oIndex = (Integer)o;
                    gluePFeature.moveCoordinateToNewPiccoloPosition(this.entityPosition, this.ringPosition, oIndex, this.startX, this.startY, false);
                }
                gluePFeature.updatePath();
            }
        }
        if (this.pf.isSelected()) {
            PLayer handleLayer = this.pf.getViewer().getHandleLayer();
            handleLayer.removeAllChildren();
            this.pf.addHandles((PNode)handleLayer);
        }
        this.pf.syncGeometry();
        Vector<Feature> v = new Vector<Feature>();
        v.add(this.pf.getFeature());
        ((DefaultFeatureCollection)this.pf.getViewer().getFeatureCollection()).fireFeaturesChanged(v);
    }

    @Override
    public String info() {
        return NbBundle.getMessage(HandleMoveAction.class, (String)"HandleMoveAction.info().return", (Object[])new Object[]{new Float(this.startX).intValue(), new Float(this.startY).intValue()});
    }

    @Override
    public CustomAction getInverse() {
        return new HandleMoveAction(this.entityPosition, this.ringPosition, this.coordPosition, this.pf, this.endX, this.endY, this.startX, this.startY, this.isGluedAction);
    }

    @Override
    public boolean featureConcerned(Feature feature) {
        return this.pf != null && this.pf.getFeature().equals(feature);
    }
}

