/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.printing;

import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.File;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class BackgroundTaskDownload
extends AbstractCancellableDownload {
    private DownloadTask downloadTask;
    private SwingWorker<Void, Void> worker;

    public BackgroundTaskDownload(DownloadTask downloadTask, String title, String directory, String filename, String extension) {
        this.title = title;
        this.directory = directory;
        this.downloadTask = downloadTask;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, extension);
    }

    public void run() {
        this.worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                BackgroundTaskDownload.this.downloadTask.download(BackgroundTaskDownload.this.fileToSaveTo);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException ex) {
                    BackgroundTaskDownload.this.error(ex);
                }
                catch (Exception ex) {
                    BackgroundTaskDownload.this.error(ex);
                }
                if (BackgroundTaskDownload.this.status == Download.State.RUNNING) {
                    BackgroundTaskDownload.this.status = Download.State.COMPLETED;
                    BackgroundTaskDownload.this.stateChanged();
                }
            }
        };
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        this.worker.execute();
    }

    public static interface DownloadTask {
        public void download(File var1) throws Exception;
    }
}

