/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.printing;

import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;

public class JasperReportDownload
extends AbstractCancellableDownload {
    private JasperPrint print;
    private String reportResourceName;
    private Map parameters;
    private JasperReportParametersGenerator parametersGenerator;
    private JRDataSource dataSource;
    private JasperReportDataSourceGenerator dataSourceGenerator;
    private JasperReport reportResource;

    public JasperReportDownload(String reportResourceName, JasperReportDataSourceGenerator dataSourceGenerator, String directory, String title, String filename) {
        this(reportResourceName, dataSourceGenerator, directory, title, filename, ".pdf");
    }

    public JasperReportDownload(String reportResourceName, JasperReportDataSourceGenerator dataSourceGenerator, String directory, String title, String filename, String extension) {
        this.reportResourceName = reportResourceName;
        this.parameters = new HashMap();
        this.dataSourceGenerator = dataSourceGenerator;
        this.directory = directory;
        this.title = title;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, extension);
    }

    public JasperReportDownload(String reportResourceName, Map parameters, JasperReportDataSourceGenerator dataSourceGenerator, String directory, String title, String filename) {
        this.reportResourceName = reportResourceName;
        this.parameters = parameters;
        this.dataSourceGenerator = dataSourceGenerator;
        this.directory = directory;
        this.title = title;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, ".pdf");
    }

    public JasperReportDownload(String reportResourceName, JasperReportParametersGenerator parametersGenerator, JasperReportDataSourceGenerator dataSourceGenerator, String directory, String title, String filename) {
        this.reportResourceName = reportResourceName;
        this.parametersGenerator = parametersGenerator;
        this.dataSourceGenerator = dataSourceGenerator;
        this.directory = directory;
        this.title = title;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, ".pdf");
    }

    public JasperReportDownload(JasperReport reportResource, JasperReportParametersGenerator parametersGenerator, JasperReportDataSourceGenerator dataSourceGenerator, String directory, String title, String filename) {
        this.reportResource = reportResource;
        this.parametersGenerator = parametersGenerator;
        this.dataSourceGenerator = dataSourceGenerator;
        this.directory = directory;
        this.title = title;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, ".pdf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block24: {
            if (this.status != Download.State.WAITING) {
                return;
            }
            this.status = Download.State.RUNNING;
            this.stateChanged();
            try {
                if (this.dataSource == null) {
                    this.dataSource = this.dataSourceGenerator.generateDataSource();
                }
                if (this.parameters == null) {
                    this.parameters = this.parametersGenerator.generateParamters();
                }
            }
            catch (Exception ex) {
                this.error(ex);
            }
            finally {
                this.dataSourceGenerator = null;
                this.parametersGenerator = null;
            }
            try {
                JasperReport jasperReport = this.reportResource;
                if (jasperReport == null) {
                    jasperReport = (JasperReport)JRLoader.loadObject((InputStream)JasperReportDownload.class.getResourceAsStream(this.reportResourceName));
                }
                this.print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)this.parameters, (JRDataSource)this.dataSource);
            }
            catch (JRException ex) {
                this.error((Exception)((Object)ex));
            }
            finally {
                this.parameters = null;
                this.dataSource = null;
                this.reportResource = null;
                this.reportResourceName = null;
            }
            if (this.print != null) {
                try {
                    if (!Thread.interrupted()) {
                        this.exportReportFile(this.print, this.fileToSaveTo);
                        break block24;
                    }
                    log.info((Object)"Download was interuppted");
                    this.deleteFile();
                    return;
                }
                catch (JRException ex) {
                    this.error((Exception)((Object)ex));
                }
                finally {
                    this.print = null;
                }
            }
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    protected void exportReportFile(JasperPrint print, File fileToSaveTo) throws JRException {
        JasperExportManager.exportReportToPdfFile((JasperPrint)print, (String)fileToSaveTo.getPath());
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }

    public static interface JasperReportDataSourceGenerator {
        public JRDataSource generateDataSource();
    }

    public static interface JasperReportParametersGenerator {
        public Map generateParamters();
    }
}

