/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.printing;

import com.github.slugify.Slugify;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.PrintTemplateFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.PrintingTemplatePreviewListener;
import de.cismet.cismap.commons.gui.printing.AbstractPrintingInscriber;
import de.cismet.cismap.commons.gui.printing.Action;
import de.cismet.cismap.commons.gui.printing.FileNameChangedEvent;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriberListener;
import de.cismet.cismap.commons.gui.printing.JasperDownload;
import de.cismet.cismap.commons.gui.printing.PDFCreatingWaitDialog;
import de.cismet.cismap.commons.gui.printing.RotatedPrintingUtils;
import de.cismet.cismap.commons.gui.printing.Scale;
import de.cismet.cismap.commons.gui.printing.Template;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import de.cismet.tools.gui.imagetooltip.ImageToolTip;
import edu.umd.cs.piccolo.event.PInputEventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JRViewer;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class PrintingWidget
extends JDialog
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(PrintingWidget.class);
    private static final boolean DEBUG = false;
    public static final String BB_MIN_X = "minX";
    public static final String BB_MIN_Y = "minY";
    public static final String BB_MAX_X = "maxX";
    public static final String BB_MAX_Y = "maxY";
    PDFCreatingWaitDialog pdfWait;
    private MappingComponent mappingComponent = null;
    private AbstractPrintingInscriber inscriber = null;
    private ImageIcon errorImage = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/error.png"));
    private BufferedImage northArrowImage = null;
    private final Style styleTip;
    private final Style styleSuccess;
    private final Style styleInfo;
    private final Style styleExpert;
    private final Style styleWarn;
    private final Style styleError;
    private final Style styleErrorReason;
    private EnumMap<HeadlessMapProvider.NotificationLevel, Style> styles = new EnumMap(HeadlessMapProvider.NotificationLevel.class);
    private Future<Image> futureMapImage;
    private boolean stopSync = false;
    private JButton cmdBack;
    private JButton cmdCancel;
    private JButton cmdOk;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JLabel lbl1;
    private JLabel lbl2;
    private JLabel lblEnding;
    private JLabel lblFilename;
    private JPanel panDesc;
    private JPanel panFilename;
    private JPanel panInscribe;
    private JPanel panLoadAndInscribe;
    private JPanel panProgress;
    private JProgressBar prbLoading;
    private JScrollPane scpLoadingStatus;
    private JTextPane txpLoadingStatus;
    private JTextField txt1;
    private JTextField txt2;
    private JTextField txtFilename;

    public PrintingWidget(boolean modal, final MappingComponent mappingComponent) {
        super(StaticSwingTools.getParentFrame((Component)((Object)mappingComponent)), modal);
        Thread t = new Thread("PrintingWidget PDFCreatingWaitDialog()"){

            @Override
            public void run() {
                PrintingWidget.this.pdfWait = new PDFCreatingWaitDialog(StaticSwingTools.getParentFrame((Component)((Object)mappingComponent)), true);
            }
        };
        try {
            this.northArrowImage = ImageIO.read(this.getClass().getResourceAsStream("/northarrow.png"));
        }
        catch (Exception e) {
            LOG.warn((Object)"Problems duroing the loading of the northarrow", (Throwable)e);
        }
        CismetThreadPool.execute((Runnable)t);
        this.mappingComponent = mappingComponent;
        this.initComponents();
        this.panDesc.setBackground(new Color(216, 228, 248));
        this.getRootPane().setDefaultButton(this.cmdOk);
        StaticSwingTools.doClickButtonOnKeyStroke((JButton)this.cmdOk, (KeyStroke)KeyStroke.getKeyStroke(10, 0), (JRootPane)this.getRootPane());
        StaticSwingTools.doClickButtonOnKeyStroke((JButton)this.cmdCancel, (KeyStroke)KeyStroke.getKeyStroke(27, 0), (JRootPane)this.getRootPane());
        this.txpLoadingStatus.setBackground(this.getBackground());
        this.prbLoading.setForeground(this.panDesc.getBackground());
        this.styleTip = this.txpLoadingStatus.addStyle(HeadlessMapProvider.NotificationLevel.TIP.name(), null);
        StyleConstants.setForeground(this.styleTip, Color.blue);
        StyleConstants.setFontSize(this.styleTip, 10);
        this.styles.put(HeadlessMapProvider.NotificationLevel.TIP, this.styleTip);
        this.styleSuccess = this.txpLoadingStatus.addStyle(HeadlessMapProvider.NotificationLevel.SUCCESS.name(), null);
        StyleConstants.setForeground(this.styleSuccess, Color.green.darker());
        StyleConstants.setFontSize(this.styleSuccess, 10);
        this.styles.put(HeadlessMapProvider.NotificationLevel.SUCCESS, this.styleSuccess);
        this.styleInfo = this.txpLoadingStatus.addStyle(HeadlessMapProvider.NotificationLevel.INFO.name(), null);
        StyleConstants.setForeground(this.styleInfo, Color.DARK_GRAY);
        StyleConstants.setFontSize(this.styleInfo, 10);
        this.styles.put(HeadlessMapProvider.NotificationLevel.INFO, this.styleInfo);
        this.styleExpert = this.txpLoadingStatus.addStyle(HeadlessMapProvider.NotificationLevel.EXPERT.name(), null);
        StyleConstants.setForeground(this.styleExpert, Color.gray);
        StyleConstants.setFontSize(this.styleExpert, 10);
        this.styles.put(HeadlessMapProvider.NotificationLevel.EXPERT, this.styleExpert);
        this.styleWarn = this.txpLoadingStatus.addStyle(HeadlessMapProvider.NotificationLevel.WARN.name(), null);
        StyleConstants.setForeground(this.styleWarn, Color.orange.darker());
        StyleConstants.setFontSize(this.styleWarn, 10);
        this.styles.put(HeadlessMapProvider.NotificationLevel.WARN, this.styleWarn);
        this.styleError = this.txpLoadingStatus.addStyle(HeadlessMapProvider.NotificationLevel.ERROR.name(), null);
        StyleConstants.setForeground(this.styleError, Color.red);
        StyleConstants.setFontSize(this.styleError, 10);
        StyleConstants.setBold(this.styleError, true);
        this.styles.put(HeadlessMapProvider.NotificationLevel.ERROR, this.styleError);
        this.styleErrorReason = this.txpLoadingStatus.addStyle(HeadlessMapProvider.NotificationLevel.ERROR_REASON.name(), null);
        StyleConstants.setForeground(this.styleErrorReason, Color.red);
        StyleConstants.setFontSize(this.styleErrorReason, 10);
        this.styles.put(HeadlessMapProvider.NotificationLevel.ERROR_REASON, this.styleErrorReason);
        StaticSwingTools.setNiftyScrollBars((JScrollPane)this.scpLoadingStatus);
    }

    public PrintingWidget cloneWithNewParent(boolean modal, MappingComponent mappingComponent) {
        PrintingWidget newWidget = new PrintingWidget(modal, mappingComponent);
        return newWidget;
    }

    private void initComponents() {
        this.lbl1 = new JLabel();
        this.txt1 = new JTextField();
        this.lbl2 = new JLabel();
        this.txt2 = new JTextField();
        this.jCheckBox1 = new JCheckBox();
        this.panDesc = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.cmdOk = new JButton();
        this.cmdCancel = new JButton();
        this.panLoadAndInscribe = new JPanel();
        this.jLabel6 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.panInscribe = new JPanel();
        this.panFilename = new JPanel();
        this.lblFilename = new JLabel();
        this.txtFilename = new JTextField();
        this.lblEnding = new JLabel();
        this.panProgress = new JPanel();
        this.scpLoadingStatus = new JScrollPane();
        this.txpLoadingStatus = new JTextPane();
        this.prbLoading = new JProgressBar();
        this.cmdBack = new JButton();
        this.lbl1.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.lbl1.text"));
        this.txt1.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.txt1.text"));
        this.lbl2.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.lbl2.text"));
        this.txt2.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.txt2.text"));
        this.jCheckBox1.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.jCheckBox1.text"));
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.title"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                PrintingWidget.this.formComponentShown(evt);
            }
        });
        this.panDesc.setBackground(SystemColor.inactiveCaptionText);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.jLabel2.text"));
        this.jLabel3.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.jLabel3.text"));
        this.jLabel4.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.jLabel4.text"));
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/frameprint.png")));
        GroupLayout panDescLayout = new GroupLayout((Container)this.panDesc);
        this.panDesc.setLayout((LayoutManager)panDescLayout);
        panDescLayout.setHorizontalGroup((GroupLayout.Group)panDescLayout.createParallelGroup(1).add((Component)this.jSeparator3, -1, 286, Short.MAX_VALUE).add((GroupLayout.Group)panDescLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panDescLayout.createParallelGroup(1).add((GroupLayout.Group)panDescLayout.createSequentialGroup().add((GroupLayout.Group)panDescLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel4)).add(83, 83, 83)).add((GroupLayout.Group)panDescLayout.createSequentialGroup().add((GroupLayout.Group)panDescLayout.createParallelGroup(1).add(2, (GroupLayout.Group)panDescLayout.createSequentialGroup().add(0, 138, Short.MAX_VALUE).add((Component)this.jLabel5)).add((Component)this.jSeparator2, -1, 266, Short.MAX_VALUE)).addContainerGap()))));
        panDescLayout.setVerticalGroup((GroupLayout.Group)panDescLayout.createParallelGroup(1).add((GroupLayout.Group)panDescLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jSeparator2, -2, 2, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jSeparator3, -2, -1, -2)));
        this.cmdOk.setMnemonic('O');
        this.cmdOk.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.cmdOk.text"));
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintingWidget.this.cmdOkActionPerformed(evt);
            }
        });
        this.cmdCancel.setMnemonic('A');
        this.cmdCancel.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.cmdCancel.text"));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintingWidget.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.jLabel6.text"));
        this.panInscribe.setLayout(new BorderLayout());
        this.panFilename.setLayout(new GridBagLayout());
        this.lblFilename.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.lblFilename.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 10, 3, 5);
        this.panFilename.add((Component)this.lblFilename, gridBagConstraints);
        this.txtFilename.setBackground(new Color(230, 230, 230));
        this.txtFilename.setHorizontalAlignment(4);
        this.txtFilename.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.txtFilename.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panFilename.add((Component)this.txtFilename, gridBagConstraints);
        this.lblEnding.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.lblEnding.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.panFilename.add((Component)this.lblEnding, gridBagConstraints);
        this.txpLoadingStatus.setEditable(false);
        this.txpLoadingStatus.setBackground(SystemColor.control);
        this.scpLoadingStatus.setViewportView(this.txpLoadingStatus);
        this.prbLoading.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.prbLoading.setBorderPainted(false);
        GroupLayout panProgressLayout = new GroupLayout((Container)this.panProgress);
        this.panProgress.setLayout((LayoutManager)panProgressLayout);
        panProgressLayout.setHorizontalGroup((GroupLayout.Group)panProgressLayout.createParallelGroup(1).add((Component)this.prbLoading, -1, 439, Short.MAX_VALUE).add((Component)this.scpLoadingStatus, -1, 439, Short.MAX_VALUE));
        panProgressLayout.setVerticalGroup((GroupLayout.Group)panProgressLayout.createParallelGroup(1).add(2, (GroupLayout.Group)panProgressLayout.createSequentialGroup().add((Component)this.scpLoadingStatus, -1, 101, Short.MAX_VALUE).add(4, 4, 4).add((Component)this.prbLoading, -2, 9, -2)));
        GroupLayout panLoadAndInscribeLayout = new GroupLayout((Container)this.panLoadAndInscribe);
        this.panLoadAndInscribe.setLayout((LayoutManager)panLoadAndInscribeLayout);
        panLoadAndInscribeLayout.setHorizontalGroup((GroupLayout.Group)panLoadAndInscribeLayout.createParallelGroup(1).add((Component)this.jSeparator4, -1, 459, Short.MAX_VALUE).add((GroupLayout.Group)panLoadAndInscribeLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panLoadAndInscribeLayout.createParallelGroup(1).add((GroupLayout.Group)panLoadAndInscribeLayout.createSequentialGroup().add((Component)this.jLabel6).add(148, 148, 148)).add((Component)this.jSeparator1, -1, 449, Short.MAX_VALUE).add(2, (GroupLayout.Group)panLoadAndInscribeLayout.createSequentialGroup().add((GroupLayout.Group)panLoadAndInscribeLayout.createParallelGroup(2).add(1, (Component)this.panFilename, -1, -1, Short.MAX_VALUE).add(1, (Component)this.panProgress, -1, -1, Short.MAX_VALUE).add(1, (Component)this.panInscribe, -1, 439, Short.MAX_VALUE)).addContainerGap()))));
        panLoadAndInscribeLayout.setVerticalGroup((GroupLayout.Group)panLoadAndInscribeLayout.createParallelGroup(1).add((GroupLayout.Group)panLoadAndInscribeLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.panInscribe, -1, 139, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.panFilename, -2, 26, -2).addPreferredGap(0).add((Component)this.panProgress, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator4, -2, -1, -2)));
        this.cmdBack.setText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.cmdBack.text"));
        this.cmdBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintingWidget.this.cmdBackActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.panDesc, -2, -1, -2).addPreferredGap(0).add((Component)this.panLoadAndInscribe, -1, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cmdCancel, -2, 125, -2).addPreferredGap(0).add((Component)this.cmdBack, -2, 125, -2).addPreferredGap(0).add((Component)this.cmdOk, -2, 126, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.panLoadAndInscribe, -1, -1, Short.MAX_VALUE).add((Component)this.panDesc, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cmdOk).add((Component)this.cmdCancel).add((Component)this.cmdBack)).addContainerGap()));
        this.pack();
    }

    private void cmdBackActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void startLoading() {
        this.txpLoadingStatus.setText("");
        try {
            Class<?> c = Class.forName(this.mappingComponent.getPrintingSettingsDialog().getSelectedTemplate().getClassName());
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            this.inscriber = (AbstractPrintingInscriber)constructor.newInstance(new Object[0]);
            if (this.inscriber instanceof FilenamePrintingInscriber) {
                final Slugify slg = new Slugify().withLowerCase(false);
                String currentFilename = ((FilenamePrintingInscriber)((Object)this.inscriber)).getFileName();
                this.txtFilename.setText(slg.slugify(currentFilename));
                this.txtFilename.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        PrintingWidget.this.stopSync = true;
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }
                });
                ((FilenamePrintingInscriber)((Object)this.inscriber)).addFilenameChangeListener(new FilenamePrintingInscriberListener(){

                    @Override
                    public void fileNameChanged(FileNameChangedEvent e) {
                        if (!PrintingWidget.this.stopSync) {
                            PrintingWidget.this.txtFilename.setText(slg.slugify(e.getNewFileName()));
                        }
                    }
                });
            } else {
                this.panFilename.setVisible(false);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading the print template", (Throwable)e);
        }
        this.panInscribe.removeAll();
        this.panInscribe.add((Component)this.inscriber, "Center");
        if (this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class).size() > 1) {
            this.panInscribe.add((Component)this.jCheckBox1, "South");
        }
        this.cmdOk.setEnabled(false);
        PInputEventListener printing = this.mappingComponent.getInputListener("PRINTING_AREA_SELECTION");
        if (printing instanceof PrintingTemplatePreviewListener) {
            for (PrintTemplateFeature ptf : this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class)) {
                XBoundingBox xbb;
                this.addMessageToProgressPane(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.startLoading().msg", (Object[])new Object[]{ptf.getResolution()}), HeadlessMapProvider.NotificationLevel.EXPERT);
                HeadlessMapProvider headlessMapProvider = HeadlessMapProvider.createHeadlessMapProviderAndAddLayers(this.mappingComponent);
                headlessMapProvider.setRequestingObject(ptf);
                headlessMapProvider.addPropertyChangeListener(this);
                if (ptf.getRotationAngle() == 0.0) {
                    xbb = new XBoundingBox(ptf.getGeometry());
                    headlessMapProvider.setBoundingBox(xbb);
                    ptf.setFutureMapImage(headlessMapProvider.getImage(72, ptf.getResolution().getResolution(), ptf.getTemplate().getMapWidth(), ptf.getTemplate().getMapHeight()));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("BoundingBox (auf " + ptf.getTemplate().getMapWidth() + "," + ptf.getTemplate().getMapHeight() + "):" + xbb));
                    continue;
                }
                xbb = new XBoundingBox(ptf.getGeometry().getEnvelope());
                headlessMapProvider.setBoundingBox(xbb);
                Dimension newDimension = RotatedPrintingUtils.calculateNewImageDimensionToFitRotatedBoundingBox(ptf.getTemplate().getMapWidth(), ptf.getTemplate().getMapHeight(), ptf.getRotationAngle());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Extended BoundingBox (auf " + newDimension + "):" + xbb));
                }
                ptf.setFutureMapImage(headlessMapProvider.getImage(72, ptf.getResolution().getResolution(), newDimension.getWidth(), newDimension.getHeight()));
            }
        }
        this.prbLoading.setIndeterminate(true);
        super.pack();
    }

    private void formComponentShown(ComponentEvent evt) {
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        ArrayList<Feature> ptfs = new ArrayList<Feature>(this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class));
        this.mappingComponent.getFeatureCollection().removeFeatures(ptfs);
        CismapBroker.getInstance().setCheckForOverlappingGeometriesAfterFeatureRotation(this.mappingComponent.getPrintingSettingsDialog().getOldOverlappingCheckEnabled());
        this.dispose();
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        Thread t = new Thread("PrintingWidget actionPerformed"){

            @Override
            public void run() {
                block25: {
                    Action a = PrintingWidget.this.mappingComponent.getPrintingSettingsDialog().getSelectedAction();
                    if (a.getId().equalsIgnoreCase("PDF")) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StaticSwingTools.showDialog((JDialog)PrintingWidget.this.pdfWait);
                            }
                        });
                    }
                    PrintingTemplatePreviewListener printingListener = (PrintingTemplatePreviewListener)PrintingWidget.this.mappingComponent.getInputListener("PRINTING_AREA_SELECTION");
                    ArrayList<JasperPrint> prints = new ArrayList<JasperPrint>(PrintingWidget.this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class).size());
                    for (PrintTemplateFeature ptf : PrintingWidget.this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class)) {
                        Template t = ptf.getTemplate();
                        Scale s = ptf.getScale();
                        try {
                            HashMap<String, Object> param = new HashMap<String, Object>();
                            Image i = ptf.getFutureMapImage().get();
                            if (ptf.getRotationAngle() == 0.0) {
                                param.put(t.getMapPlaceholder(), i);
                                System.out.println("Imagedimension (raw - not rotated):" + ptf.getFutureMapImage().get().getWidth(null) + "," + ptf.getFutureMapImage().get().getHeight(null));
                            } else {
                                param.put(ptf.getTemplate().getNorthArrowPlaceholder(), RotatedPrintingUtils.rotate(PrintingWidget.this.northArrowImage, -1.0 * ptf.getRotationAngle()));
                                BufferedImage correctedImage = RotatedPrintingUtils.rotateAndCrop(i, ptf.getRotationAngle(), ptf.getTemplate().getMapWidth(), ptf.getTemplate().getMapHeight(), 72, ptf.getResolution().getResolution());
                                param.put(t.getMapPlaceholder(), correctedImage);
                                System.out.println("Imagedimension (raw):" + ptf.getFutureMapImage().get().getWidth(null) + "," + ptf.getFutureMapImage().get().getHeight(null));
                                System.out.println("Imagedimension (corrected):" + correctedImage.getWidth() + "," + correctedImage.getHeight());
                            }
                            param.put(t.getScaleDemoninatorPlaceholder(), String.valueOf(ptf.getRealScaleDenominator()));
                            HashMap<String, String> vals = PrintingWidget.this.inscriber.getValues();
                            for (String key : vals.keySet()) {
                                vals.put(key, vals.get(key).replaceAll("##N##", String.valueOf(ptf.getNumber())));
                                vals.put(key, vals.get(key).replaceAll("##G##", String.valueOf(PrintingWidget.this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class).size())));
                            }
                            param.putAll(vals);
                            if (ptf.getRotationAngle() == 0.0) {
                                XBoundingBox bbox = new XBoundingBox(ptf.getGeometry());
                                param.put(PrintingWidget.BB_MIN_X, bbox.getX1());
                                param.put(PrintingWidget.BB_MIN_Y, bbox.getY1());
                                param.put(PrintingWidget.BB_MAX_X, bbox.getX2());
                                param.put(PrintingWidget.BB_MAX_Y, bbox.getY2());
                            }
                            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)this.getClass().getResourceAsStream(t.getFile()));
                            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, param);
                            prints.add(jasperPrint);
                        }
                        catch (Throwable tt) {
                            LOG.error((Object)"Error during Jaspern", tt);
                            ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.cmdOKActionPerformed(ActionEvent).ErrorInfo.title"), NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.cmdOKActionPerformed(ActionEvent).ErrorInfo.message"), null, null, tt, Level.ALL, null);
                            JXErrorPane.showDialog((Component)((Object)PrintingWidget.this.mappingComponent), (ErrorInfo)ei);
                            if (!PrintingWidget.this.pdfWait.isVisible()) continue;
                            PrintingWidget.this.pdfWait.dispose();
                        }
                    }
                    try {
                        if (a.getId().equalsIgnoreCase("PRINTPREVIEW") && prints.size() == 1) {
                            JasperPrint jasperPrint = (JasperPrint)prints.get(0);
                            JRViewer aViewer = new JRViewer(jasperPrint);
                            JFrame aFrame = new JFrame(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.cmdOKActionPerformed(ActionEvent).aFrame.title"));
                            aFrame.getContentPane().add((Component)aViewer);
                            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                            aFrame.setSize(screenSize.width / 2, screenSize.height / 2);
                            Insets insets = aFrame.getInsets();
                            aFrame.setSize(aFrame.getWidth() + insets.left + insets.right, aFrame.getHeight() + insets.top + insets.bottom + 20);
                            aFrame.setLocationRelativeTo(PrintingWidget.this);
                            aFrame.setVisible(true);
                        } else if (a.getId().equalsIgnoreCase("PDF") || a.getId().equalsIgnoreCase("PRINTPREVIEW") && prints.size() > 1) {
                            if (PrintingWidget.this.mappingComponent.getPrintingSettingsDialog().isChooseFileName()) {
                                File file = StaticSwingTools.chooseFile((String)DownloadManager.instance().getDestinationDirectory().getAbsolutePath(), (boolean)true, (String[])new String[]{"pdf"}, (String)"PDF", (Component)((Object)PrintingWidget.this.mappingComponent));
                                if (file != null) {
                                    ArrayList downloads;
                                    int index;
                                    if (file.exists()) {
                                        file.delete();
                                    }
                                    JasperDownload jd = new JasperDownload(prints, file.getParent(), "Cismap-Druck", file.getName().substring(0, file.getName().indexOf(".")));
                                    jd.setFileToSaveTo(file);
                                    if (DownloadManager.instance().getDownloads().contains((Object)jd) && (index = (downloads = new ArrayList(DownloadManager.instance().getDownloads())).indexOf((Object)jd)) != -1) {
                                        Download d = (Download)downloads.get(index);
                                        DownloadManager.instance().removeDownload(d);
                                    }
                                    DownloadManager.instance().add((Download)jd);
                                }
                            } else if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)((Object)PrintingWidget.this.mappingComponent))) {
                                JasperDownload download;
                                String jobname = DownloadManagerDialog.getInstance().getJobName();
                                if (PrintingWidget.this.jCheckBox1.isSelected()) {
                                    ArrayList<JasperDownload> singleDownloads = new ArrayList<JasperDownload>();
                                    for (int i = 0; i < prints.size(); ++i) {
                                        singleDownloads.add(new JasperDownload(prints.get(i), jobname, "Cismap-Druck", (!PrintingWidget.this.txtFilename.getText().equals("") ? PrintingWidget.this.txtFilename.getText() + "_" : "cismap_") + (i + 1)));
                                    }
                                    download = new MultipleDownload(singleDownloads, "Cismap-Druck");
                                } else {
                                    download = new JasperDownload(prints, jobname, "Cismap-Druck", !PrintingWidget.this.txtFilename.getText().equals("") ? PrintingWidget.this.txtFilename.getText() : "cismap");
                                }
                                DownloadManager.instance().add((Download)download);
                            }
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (PrintingWidget.this.pdfWait.isVisible()) {
                                        PrintingWidget.this.pdfWait.dispose();
                                    }
                                }
                            });
                        } else if (a.getId().equalsIgnoreCase("PRINT")) {
                            for (JasperPrint jasperPrint : prints) {
                                JasperPrintManager.printReport((JasperPrint)jasperPrint, (boolean)true);
                            }
                        }
                    }
                    catch (Throwable tt) {
                        LOG.error((Object)"Error during Jaspern", tt);
                        ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.cmdOKActionPerformed(ActionEvent).ErrorInfo.title"), NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.cmdOKActionPerformed(ActionEvent).ErrorInfo.message"), null, null, tt, Level.ALL, null);
                        JXErrorPane.showDialog((Component)((Object)PrintingWidget.this.mappingComponent), (ErrorInfo)ei);
                        if (!PrintingWidget.this.pdfWait.isVisible()) break block25;
                        PrintingWidget.this.pdfWait.dispose();
                    }
                }
                ArrayList<Feature> ptfs = new ArrayList<Feature>(PrintingWidget.this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class));
                PrintingWidget.this.mappingComponent.getFeatureCollection().removeFeatures(ptfs);
                CismapBroker.getInstance().setCheckForOverlappingGeometriesAfterFeatureRotation(PrintingWidget.this.mappingComponent.getPrintingSettingsDialog().getOldOverlappingCheckEnabled());
            }
        };
        CismetThreadPool.execute((Runnable)t);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void activateButton() {
        this.prbLoading.setIndeterminate(false);
        this.prbLoading.setValue(100);
        this.cmdOk.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIconToProgressPane(final ImageIcon icon, final Image tooltipImage) {
        final JLabel label = new JLabel(){

            @Override
            public JToolTip createToolTip() {
                if (tooltipImage != null) {
                    return new ImageToolTip(tooltipImage);
                }
                return super.createToolTip();
            }
        };
        PrintingWidget printingWidget = this;
        synchronized (printingWidget) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StyledDocument doc = (StyledDocument)PrintingWidget.this.txpLoadingStatus.getDocument();
                    Style style = doc.addStyle("Icon", null);
                    label.setIcon(icon);
                    label.setText(" ");
                    label.setAlignmentY(0.8f);
                    label.setToolTipText(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.addIconToProgressPane(ImageIcon,Image).label.setToolTipText"));
                    StyleConstants.setComponent(style, label);
                    try {
                        doc.insertString(doc.getLength(), "ico", style);
                    }
                    catch (BadLocationException ble) {
                        LOG.error((Object)"Error in addIconToProgressPane", (Throwable)ble);
                    }
                }
            });
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof HeadlessMapProvider) {
            HeadlessMapProvider source = (HeadlessMapProvider)evt.getSource();
            if (evt.getNewValue() instanceof HeadlessMapProvider.NotificationMessage) {
                RetrievalEvent e;
                HeadlessMapProvider.NotificationMessage message = (HeadlessMapProvider.NotificationMessage)evt.getNewValue();
                this.addMessageToProgressPane(message.getMsg(), message.getLevel());
                if (!message.getLevel().equals((Object)HeadlessMapProvider.NotificationLevel.UNLOCKED) && message.getLevel().equals((Object)HeadlessMapProvider.NotificationLevel.ERROR_REASON) && evt.getOldValue() instanceof RetrievalEvent && (e = (RetrievalEvent)evt.getOldValue()).getRetrievedObject() instanceof Image) {
                    Image i = Static2DTools.removeUnusedBorder((Image)((Image)e.getRetrievedObject()), (int)5, (double)0.7);
                    this.addIconToProgressPane(this.errorImage, i);
                    this.addMessageToProgressPane(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalComplete(RetrievalEvent).msg2", (Object[])new Object[]{e.getRetrievalService()}), HeadlessMapProvider.NotificationLevel.ERROR_REASON);
                }
                Collection<PrintTemplateFeature> prints = this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class);
                boolean allPrintsReady = true;
                for (PrintTemplateFeature ptf : prints) {
                    if (ptf.getFutureMapImage() != null && (ptf.getFutureMapImage().isDone() || ptf.getFutureMapImage().isCancelled())) continue;
                    allPrintsReady = false;
                    break;
                }
                if (allPrintsReady) {
                    this.activateButton();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageToProgressPane(final String msg, final HeadlessMapProvider.NotificationLevel reason) {
        PrintingWidget printingWidget = this;
        synchronized (printingWidget) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        PrintingWidget.this.txpLoadingStatus.getStyledDocument().insertString(PrintingWidget.this.txpLoadingStatus.getStyledDocument().getLength(), msg + "\n", (AttributeSet)PrintingWidget.this.styles.get((Object)reason));
                    }
                    catch (BadLocationException ble) {
                        LOG.error((Object)"error during Insert", (Throwable)ble);
                    }
                }
            });
        }
    }
}

