/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.printing;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class RotatedPrintingUtils {
    public static BufferedImage rotateAndCrop(Image biggerImage, double angle, double width, double height, int baseDpi, int targetDpi) {
        int imageWidth = (int)(width / (double)baseDpi * (double)targetDpi);
        int imageHeight = (int)(height / (double)baseDpi * (double)targetDpi);
        BufferedImage bufferedBiggerImage = RotatedPrintingUtils.toBufferedImage(biggerImage);
        BufferedImage off_Image = new BufferedImage(imageWidth, imageHeight, 2);
        double rotationRequired = Math.toRadians(angle);
        AffineTransform at = new AffineTransform();
        at.translate(imageWidth / 2, imageHeight / 2);
        at.rotate(-rotationRequired);
        at.translate(-bufferedBiggerImage.getWidth() / 2, -bufferedBiggerImage.getHeight() / 2);
        AffineTransformOp op = new AffineTransformOp(at, 2);
        Graphics2D g2d = (Graphics2D)off_Image.getGraphics();
        g2d.drawImage((Image)op.filter(bufferedBiggerImage, null), 0, 0, null);
        return off_Image;
    }

    public static BufferedImage rotate(BufferedImage i, double angleInDeegrees) {
        BufferedImage off_Image = new BufferedImage(i.getWidth(), i.getHeight(), 2);
        double rotationRequired = Math.toRadians(angleInDeegrees);
        AffineTransform at = new AffineTransform();
        at.translate(i.getWidth() / 2, i.getHeight() / 2);
        at.rotate(rotationRequired);
        at.translate(-i.getWidth() / 2, -i.getHeight() / 2);
        AffineTransformOp op = new AffineTransformOp(at, 2);
        Graphics2D g2d = (Graphics2D)off_Image.getGraphics();
        g2d.drawImage((Image)op.filter(i, null), 0, 0, null);
        return off_Image;
    }

    public static Dimension calculateNewImageDimensionToFitRotatedBoundingBox(double width, double height, double angle) {
        Dimension ret = new Dimension();
        double a = angle;
        if (a < 0.0) {
            a = 180.0 + a;
        }
        if (a > 90.0) {
            double rotation1 = Math.toRadians(a -= 90.0);
            double rotation2 = Math.toRadians(90.0 - a);
            ret.setSize(Math.cos(rotation1) * height + Math.cos(rotation2) * width, Math.cos(rotation1) * width + Math.cos(rotation2) * height);
            return ret;
        }
        double rotation1 = Math.toRadians(a);
        double rotation2 = Math.toRadians(90.0 - a);
        ret.setSize(Math.cos(rotation1) * width + Math.cos(rotation2) * height, Math.cos(rotation1) * height + Math.cos(rotation2) * width);
        return ret;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

