/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.shapeexport;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.shapeexport.ExportWFS;
import de.cismet.cismap.commons.gui.shapeexport.ShapeExport;
import de.cismet.cismap.commons.gui.shapeexport.ShapeExportDialog;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ShapeExportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ShapeExportAction.class);

    public ShapeExportAction() {
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/shapeexport_small.png")));
        this.putValue("ShortDescription", NbBundle.getMessage(ShapeExportAction.class, (String)"ShapeExportAction.tooltiptext"));
        this.putValue("Name", NbBundle.getMessage(ShapeExportAction.class, (String)"ShapeExportAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<ExportWFS> wfsList = null;
        ShapeExportDialog dialog = new ShapeExportDialog((JComponent)((Object)CismapBroker.getInstance().getMappingComponent()), ShapeExport.getWFSList());
        StaticSwingTools.showDialog((JDialog)dialog);
        if (dialog.isCancelled()) {
            return;
        }
        XBoundingBox boundingBox = (XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera();
        wfsList = dialog.getSelectedWFSs();
        for (ExportWFS wfs : wfsList) {
            if (wfs.getTargetCRS() != null) {
                Geometry g = CrsTransformer.transformToGivenCrs(boundingBox.getGeometry(), wfs.getTargetCRS());
                boundingBox = new XBoundingBox(g);
            }
            wfs.setQuery(wfs.getQuery().replace(ShapeExport.getBboxToken(), boundingBox.toGml4WFS110String()));
        }
        if (!DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()))) {
            return;
        }
        String jobname = DownloadManagerDialog.getInstance().getJobName();
        DownloadManager.instance().add(this.convertToDownloads(wfsList, jobname));
    }

    private Download convertToDownloads(Collection<ExportWFS> wfss, String jobname) {
        LinkedList<HttpDownload> downloads = new LinkedList<HttpDownload>();
        String filenameFromShapeExport = ShapeExport.getDestinationFile();
        String extension = ShapeExport.getDestinationFileExtension();
        String destinationDirectory = ShapeExport.getDestinationDirectory();
        if (jobname != null && jobname.trim().length() > 0) {
            destinationDirectory = destinationDirectory.concat(File.separator).concat(jobname);
        }
        for (ExportWFS wfs : wfss) {
            String filenameForDownload = wfs.getFile();
            if (filenameForDownload == null || filenameForDownload.trim().length() == 0) {
                filenameForDownload = filenameFromShapeExport;
            }
            HttpDownload download = new HttpDownload(wfs.getUrl(), wfs.getQuery(), destinationDirectory, wfs.getTopic(), filenameForDownload, extension);
            downloads.add(download);
        }
        if (downloads.size() == 1) {
            return (Download)downloads.iterator().next();
        }
        return new MultipleDownload(downloads, jobname);
    }
}

