/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.shapeexport;

import de.cismet.cismap.commons.gui.shapeexport.ExportWFS;
import de.cismet.cismap.commons.gui.shapeexport.ShapeExport;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ShapeExportDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(ShapeExportDialog.class);
    private Collection<ExportWFS> wfsCollection;
    private Map<ExportWFS, JCheckBox> checkboxes;
    private Collection<ExportWFS> selectedWFSs = null;
    private boolean cancelled = true;
    private int countOfSelectedWFSs = 0;
    private JButton btnCancel;
    private JButton btnOK;
    private JLabel lblDialogHint;
    private JLabel lblIcon;
    private JLabel lblStep1;
    private JLabel lblStep1Header;
    private JLabel lblSteps;
    private JPanel panDesc;
    private JPanel pnlButtons;
    private JPanel pnlCheckboxes;
    private JPanel pnlControls;
    private JPanel pnlExportParameters;
    private JPanel pnlFillDesc;
    private JScrollPane scpExportParameters;
    private JSeparator sepControls;
    private JSeparator sepStep1Header;
    private JSeparator sepSteps;

    public ShapeExportDialog(JComponent parent, Collection<ExportWFS> wfsCollection) {
        this(StaticSwingTools.getParentFrame((Component)parent), true, wfsCollection);
    }

    public ShapeExportDialog(Frame parent, boolean modal, Collection<ExportWFS> wfsCollection) {
        super(parent, modal);
        this.wfsCollection = wfsCollection;
        this.checkboxes = new HashMap<ExportWFS, JCheckBox>(wfsCollection.size());
        this.initComponents();
        this.createCheckboxes();
    }

    private void createCheckboxes() {
        JCheckBox newCheckBox;
        Font font = null;
        FontRenderContext fontRenderContext = null;
        int maxWidth = -1;
        for (ExportWFS wfs : this.wfsCollection) {
            int width;
            newCheckBox = new JCheckBox(wfs.getTopic());
            newCheckBox.setFocusPainted(false);
            newCheckBox.setAlignmentX(1.0f);
            newCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() instanceof JCheckBox) {
                        JCheckBox checkbox = (JCheckBox)e.getSource();
                        if (checkbox.isSelected()) {
                            ShapeExportDialog.this.countOfSelectedWFSs++;
                        } else {
                            ShapeExportDialog.this.countOfSelectedWFSs--;
                        }
                        ShapeExportDialog.this.btnOK.setEnabled(ShapeExportDialog.this.countOfSelectedWFSs > 0);
                    }
                }
            });
            this.checkboxes.put(wfs, newCheckBox);
            if (font == null) {
                font = newCheckBox.getFont();
            }
            if (fontRenderContext == null) {
                fontRenderContext = newCheckBox.getFontMetrics(font).getFontRenderContext();
            }
            if (maxWidth >= (width = (int)font.getStringBounds(newCheckBox.getText(), fontRenderContext).getWidth())) continue;
            maxWidth = width;
        }
        for (ExportWFS wfs : this.wfsCollection) {
            newCheckBox = this.checkboxes.get(wfs);
            newCheckBox.setIconTextGap(maxWidth - (int)font.getStringBounds(newCheckBox.getText(), fontRenderContext).getWidth() + 10);
            this.pnlCheckboxes.add(newCheckBox);
        }
        this.pnlCheckboxes.add(Box.createVerticalGlue());
        this.pnlCheckboxes.validate();
        this.scpExportParameters.setMinimumSize(this.pnlCheckboxes.getMinimumSize());
        this.pack();
    }

    private void initComponents() {
        this.pnlControls = new JPanel();
        this.sepControls = new JSeparator();
        this.pnlButtons = new JPanel();
        this.btnCancel = new JButton();
        this.btnOK = new JButton();
        this.panDesc = new JPanel();
        this.lblSteps = new JLabel();
        this.sepSteps = new JSeparator();
        this.lblStep1 = new JLabel();
        this.lblIcon = new JLabel();
        this.pnlFillDesc = new JPanel();
        this.pnlExportParameters = new JPanel();
        this.lblDialogHint = new JLabel();
        this.lblStep1Header = new JLabel();
        this.sepStep1Header = new JSeparator();
        this.scpExportParameters = new JScrollPane();
        this.pnlCheckboxes = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(ShapeExportDialog.class, (String)"ShapeExportDialog.title"));
        this.setMinimumSize(new Dimension(529, 250));
        this.setModal(true);
        this.pnlControls.setLayout(new BorderLayout());
        this.pnlControls.add((Component)this.sepControls, "First");
        this.pnlButtons.setLayout(new FlowLayout(2));
        this.btnCancel.setText(NbBundle.getMessage(ShapeExportDialog.class, (String)"ShapeExportDialog.btnCancel.text"));
        this.btnCancel.setPreferredSize(new Dimension(100, 25));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShapeExportDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnCancel);
        this.btnOK.setText(NbBundle.getMessage(ShapeExportDialog.class, (String)"ShapeExportDialog.btnOK.text"));
        this.btnOK.setEnabled(false);
        this.btnOK.setPreferredSize(new Dimension(100, 25));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShapeExportDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnOK);
        this.pnlControls.add((Component)this.pnlButtons, "Center");
        this.getContentPane().add((Component)this.pnlControls, "Last");
        this.panDesc.setBackground(new Color(216, 228, 248));
        this.panDesc.setMaximumSize(new Dimension(200, Short.MAX_VALUE));
        this.panDesc.setMinimumSize(new Dimension(200, 150));
        this.panDesc.setPreferredSize(new Dimension(200, 150));
        this.panDesc.setLayout(new GridBagLayout());
        this.lblSteps.setFont(new Font("Tahoma", 1, 11));
        this.lblSteps.setText(NbBundle.getMessage(ShapeExportDialog.class, (String)"ShapeExportDialog.lblSteps.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 10, 0, 0);
        this.panDesc.add((Component)this.lblSteps, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 319;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panDesc.add((Component)this.sepSteps, gridBagConstraints);
        this.lblStep1.setText(NbBundle.getMessage(ShapeExportDialog.class, (String)"ShapeExportDialog.lblStep1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.panDesc.add((Component)this.lblStep1, gridBagConstraints);
        this.lblIcon.setHorizontalAlignment(0);
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/shapeexport.png")));
        this.lblIcon.setPreferredSize(new Dimension(128, 128));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = -8;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(5, 5, 3, 7);
        this.panDesc.add((Component)this.lblIcon, gridBagConstraints);
        this.pnlFillDesc.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panDesc.add((Component)this.pnlFillDesc, gridBagConstraints);
        this.getContentPane().add((Component)this.panDesc, "Before");
        this.pnlExportParameters.setLayout(new GridBagLayout());
        this.lblDialogHint.setText(NbBundle.getMessage(ShapeExportDialog.class, (String)"ShapeExportDialog.lblDialogHint.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 5, 5);
        this.pnlExportParameters.add((Component)this.lblDialogHint, gridBagConstraints);
        this.lblStep1Header.setFont(new Font("Tahoma", 1, 11));
        this.lblStep1Header.setText(NbBundle.getMessage(ShapeExportDialog.class, (String)"ShapeExportDialog.lblStep1Header.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 10, 0, 0);
        this.pnlExportParameters.add((Component)this.lblStep1Header, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 319;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlExportParameters.add((Component)this.sepStep1Header, gridBagConstraints);
        this.scpExportParameters.setBorder(null);
        this.pnlCheckboxes.setLayout(new BoxLayout(this.pnlCheckboxes, 3));
        this.scpExportParameters.setViewportView(this.pnlCheckboxes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.pnlExportParameters.add((Component)this.scpExportParameters, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlExportParameters, "Center");
        this.pack();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.selectedWFSs = new LinkedList<ExportWFS>();
        for (ExportWFS wfs : this.wfsCollection) {
            JCheckBox checkbox = this.checkboxes.get(wfs);
            if (!checkbox.isSelected()) continue;
            this.selectedWFSs.add(wfs);
        }
        this.setVisible(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.selectedWFSs = new LinkedList<ExportWFS>();
        this.setVisible(false);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public Collection<ExportWFS> getSelectedWFSs() {
        return this.selectedWFSs;
    }

    public static final void main(String[] args) {
        URL erraneousURL;
        URL url;
        try {
            url = new URL("http://flexo.cismet.de:8080/deegree-wfs/services");
            erraneousURL = new URL("http://doesntexist.fis-wasser-mv.de/services");
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        ExportWFS wfs1 = new ExportWFS("Test-Thema 1", "route", "<wfs:GetFeature xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:app=\"http://www.deegree.org/app\" version=\"1.1.0\" service=\"WFS\" outputFormat=\"SHAPE\" maxFeatures=\"3000\"><wfs:Query typeName=\"app:route\" srsName=\"EPSG:35833\"><ogc:Filter><ogc:BBOX><ogc:PropertyName>app:the_geom</ogc:PropertyName><cismap:BBOX/></ogc:BBOX></ogc:Filter><wfs:PropertyName>app:id</wfs:PropertyName><wfs:PropertyName>app:gwk</wfs:PropertyName><wfs:PropertyName>app:the_geom</wfs:PropertyName></wfs:Query></wfs:GetFeature>", url, null);
        ExportWFS wfs2 = new ExportWFS("Dann das Test-Thema 2", "route", "<wfs:GetFeature xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:app=\"http://www.deegree.org/app\" version='1.1.0' service=\"WFS\" outputFormat=\"SHAPE\" maxFeatures=\"3000\"><wfs:Query typeName=\"app:route\" srsName=\"EPSG:35833\"><ogc:Filter><ogc:BBOX><ogc:PropertyName>app:the_geom</ogc:PropertyName><cismap:BBOX/></ogc:BBOX></ogc:Filter><wfs:PropertyName>app:id</wfs:PropertyName><wfs:PropertyName>app:gwk</wfs:PropertyName><wfs:PropertyName>app:the_geom</wfs:PropertyName></wfs:Query></wfs:GetFeature>", url, null);
        ExportWFS wfs3 = new ExportWFS("Und dann noch das Test-Thema 3", "oeg", "<wfs:GetFeature xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:app=\"http://www.deegree.org/app\" version='1.1.0' service=\"WFS\" outputFormat=\"SHAPE\" maxFeatures=\"3000\"><wfs:Query typeName=\"app:ogc.oeg\" srsName=\"EPSG:35833\"><ogc:Filter><ogc:BBOX><ogc:PropertyName>app:the_geom</ogc:PropertyName><cismap:BBOX/></ogc:BBOX></ogc:Filter><wfs:PropertyName>app:gid</wfs:PropertyName><wfs:PropertyName>app:area</wfs:PropertyName><wfs:PropertyName>app:perimeter</wfs:PropertyName><wfs:PropertyName>app:ezg3_</wfs:PropertyName><wfs:PropertyName>app:ezg3_id</wfs:PropertyName><wfs:PropertyName>app:poly_</wfs:PropertyName><wfs:PropertyName>app:subclass</wfs:PropertyName><wfs:PropertyName>app:subclass_</wfs:PropertyName><wfs:PropertyName>app:rings_ok</wfs:PropertyName><wfs:PropertyName>app:rings_nok</wfs:PropertyName><wfs:PropertyName>app:schluessel</wfs:PropertyName><wfs:PropertyName>app:zehn</wfs:PropertyName><wfs:PropertyName>app:typ</wfs:PropertyName><wfs:PropertyName>app:typ1</wfs:PropertyName><wfs:PropertyName>app:typ2</wfs:PropertyName><wfs:PropertyName>app:teilgebnr</wfs:PropertyName><wfs:PropertyName>app:pegelnr</wfs:PropertyName><wfs:PropertyName>app:pegelname</wfs:PropertyName><wfs:PropertyName>app:pkz</wfs:PropertyName><wfs:PropertyName>app:seenr</wfs:PropertyName><wfs:PropertyName>app:seename</wfs:PropertyName><wfs:PropertyName>app:flussgeb</wfs:PropertyName><wfs:PropertyName>app:von</wfs:PropertyName><wfs:PropertyName>app:modi_geo</wfs:PropertyName><wfs:PropertyName>app:modi_gwk</wfs:PropertyName><wfs:PropertyName>app:modi_gebbz</wfs:PropertyName><wfs:PropertyName>app:key_pl</wfs:PropertyName><wfs:PropertyName>app:key_pl_ten</wfs:PropertyName><wfs:PropertyName>app:teilgeb</wfs:PropertyName><wfs:PropertyName>app:wrkarea</wfs:PropertyName><wfs:PropertyName>app:area_km2</wfs:PropertyName><wfs:PropertyName>app:mst</wfs:PropertyName><wfs:PropertyName>app:a_sum</wfs:PropertyName><wfs:PropertyName>app:id_ezg</wfs:PropertyName><wfs:PropertyName>app:nsaldo_amt</wfs:PropertyName><wfs:PropertyName>app:min_nsl_lw</wfs:PropertyName><wfs:PropertyName>app:max_nsl_lw</wfs:PropertyName><wfs:PropertyName>app:nsaldo_lw</wfs:PropertyName><wfs:PropertyName>app:area_lw</wfs:PropertyName><wfs:PropertyName>app:kg_lw</wfs:PropertyName><wfs:PropertyName>app:gwn_0</wfs:PropertyName><wfs:PropertyName>app:rd_p1</wfs:PropertyName><wfs:PropertyName>app:gwn_p1</wfs:PropertyName><wfs:PropertyName>app:no3_sw</wfs:PropertyName><wfs:PropertyName>app:no3_gw</wfs:PropertyName><wfs:PropertyName>app:no3_kg_gw</wfs:PropertyName><wfs:PropertyName>app:no3_kg_ow</wfs:PropertyName><wfs:PropertyName>app:et0</wfs:PropertyName><wfs:PropertyName>app:no3_gw1</wfs:PropertyName><wfs:PropertyName>app:no3_gw2</wfs:PropertyName><wfs:PropertyName>app:kf_hoch</wfs:PropertyName><wfs:PropertyName>app:mv</wfs:PropertyName><wfs:PropertyName>app:proz_gw</wfs:PropertyName><wfs:PropertyName>app:nsald_amt2</wfs:PropertyName><wfs:PropertyName>app:nsald_lw2</wfs:PropertyName><wfs:PropertyName>app:gwk_fluss</wfs:PropertyName><wfs:PropertyName>app:the_geom</wfs:PropertyName></wfs:Query></wfs:GetFeature>", url, null);
        ExportWFS wfs4 = new ExportWFS("Test-Thema 1", "route", "<wfs:GetFeature xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:app=\"http://www.deegree.org/app\" version=\"1.1.0\" service=\"WFS\" outputFormat=\"SHAPE\" maxFeatures=\"3000\"><wfs:Query typeName=\"app:route\" srsName=\"EPSG:35833\"><ogc:Filter><ogc:BBOX><ogc:PropertyName>app:the_geom</ogc:PropertyName><cismap:BBOX/></ogc:BBOX></ogc:Filter><wfs:PropertyName>app:id</wfs:PropertyName><wfs:PropertyName>app:gwk</wfs:PropertyName><wfs:PropertyName>app:the_geom</wfs:PropertyName></wfs:Query></wfs:GetFeature>", url, null);
        ExportWFS wfs5 = new ExportWFS("Dann das Test-Thema 2", "route", "<wfs:GetFeature xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:app=\"http://www.deegree.org/app\" version='1.1.0' service=\"WFS\" outputFormat=\"SHAPE\" maxFeatures=\"3000\"><wfs:Query typeName=\"app:route\" srsName=\"EPSG:35833\"><ogc:Filter><ogc:BBOX><ogc:PropertyName>app:the_geom</ogc:PropertyName><cismap:BBOX/></ogc:BBOX></ogc:Filter><wfs:PropertyName>app:id</wfs:PropertyName><wfs:PropertyName>app:gwk</wfs:PropertyName><wfs:PropertyName>app:the_geom</wfs:PropertyName></wfs:Query></wfs:GetFeature>", erraneousURL, null);
        ExportWFS wfs6 = new ExportWFS("Und dann noch das Test-Thema 3", "oeg", "<wfs:GetFeature xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:app=\"http://www.deegree.org/app\" version='1.1.0' service=\"WFS\" outputFormat=\"SHAPE\" maxFeatures=\"3000\"><wfs:Query typeName=\"app:ogc.oeg\" srsName=\"EPSG:35833\"><ogc:Filter><ogc:BBOX><ogc:PropertyName>app:the_geom</ogc:PropertyName><cismap:BBOX/></ogc:BBOX></ogc:Filter><wfs:PropertyName>app:gid</wfs:PropertyName><wfs:PropertyName>app:area</wfs:PropertyName><wfs:PropertyName>app:perimeter</wfs:PropertyName><wfs:PropertyName>app:ezg3_</wfs:PropertyName><wfs:PropertyName>app:ezg3_id</wfs:PropertyName><wfs:PropertyName>app:poly_</wfs:PropertyName><wfs:PropertyName>app:subclass</wfs:PropertyName><wfs:PropertyName>app:subclass_</wfs:PropertyName><wfs:PropertyName>app:rings_ok</wfs:PropertyName><wfs:PropertyName>app:rings_nok</wfs:PropertyName><wfs:PropertyName>app:schluessel</wfs:PropertyName><wfs:PropertyName>app:zehn</wfs:PropertyName><wfs:PropertyName>app:typ</wfs:PropertyName><wfs:PropertyName>app:typ1</wfs:PropertyName><wfs:PropertyName>app:typ2</wfs:PropertyName><wfs:PropertyName>app:teilgebnr</wfs:PropertyName><wfs:PropertyName>app:pegelnr</wfs:PropertyName><wfs:PropertyName>app:pegelname</wfs:PropertyName><wfs:PropertyName>app:pkz</wfs:PropertyName><wfs:PropertyName>app:seenr</wfs:PropertyName><wfs:PropertyName>app:seename</wfs:PropertyName><wfs:PropertyName>app:flussgeb</wfs:PropertyName><wfs:PropertyName>app:von</wfs:PropertyName><wfs:PropertyName>app:modi_geo</wfs:PropertyName><wfs:PropertyName>app:modi_gwk</wfs:PropertyName><wfs:PropertyName>app:modi_gebbz</wfs:PropertyName><wfs:PropertyName>app:key_pl</wfs:PropertyName><wfs:PropertyName>app:key_pl_ten</wfs:PropertyName><wfs:PropertyName>app:teilgeb</wfs:PropertyName><wfs:PropertyName>app:wrkarea</wfs:PropertyName><wfs:PropertyName>app:area_km2</wfs:PropertyName><wfs:PropertyName>app:mst</wfs:PropertyName><wfs:PropertyName>app:a_sum</wfs:PropertyName><wfs:PropertyName>app:id_ezg</wfs:PropertyName><wfs:PropertyName>app:nsaldo_amt</wfs:PropertyName><wfs:PropertyName>app:min_nsl_lw</wfs:PropertyName><wfs:PropertyName>app:max_nsl_lw</wfs:PropertyName><wfs:PropertyName>app:nsaldo_lw</wfs:PropertyName><wfs:PropertyName>app:area_lw</wfs:PropertyName><wfs:PropertyName>app:kg_lw</wfs:PropertyName><wfs:PropertyName>app:gwn_0</wfs:PropertyName><wfs:PropertyName>app:rd_p1</wfs:PropertyName><wfs:PropertyName>app:gwn_p1</wfs:PropertyName><wfs:PropertyName>app:no3_sw</wfs:PropertyName><wfs:PropertyName>app:no3_gw</wfs:PropertyName><wfs:PropertyName>app:no3_kg_gw</wfs:PropertyName><wfs:PropertyName>app:no3_kg_ow</wfs:PropertyName><wfs:PropertyName>app:et0</wfs:PropertyName><wfs:PropertyName>app:no3_gw1</wfs:PropertyName><wfs:PropertyName>app:no3_gw2</wfs:PropertyName><wfs:PropertyName>app:kf_hoch</wfs:PropertyName><wfs:PropertyName>app:mv</wfs:PropertyName><wfs:PropertyName>app:proz_gw</wfs:PropertyName><wfs:PropertyName>app:nsald_amt2</wfs:PropertyName><wfs:PropertyName>app:nsald_lw2</wfs:PropertyName><wfs:PropertyName>app:gwk_fluss</wfs:PropertyName><wfs:PropertyName>app:the_geom</wfs:PropertyName></wfs:Query></wfs:GetFeature>", url, null);
        TreeSet<ExportWFS> wfsList = new TreeSet<ExportWFS>();
        wfsList.add(wfs1);
        wfsList.add(wfs2);
        wfsList.add(wfs3);
        TreeSet<ExportWFS> selectedWFS = wfsList;
        for (ExportWFS wfs : selectedWFS) {
            wfs.setQuery(wfs.getQuery().replace(ShapeExport.getBboxToken(), "<gml:Box><gml:coord><gml:X>3.3260837108302265E7</gml:X><gml:Y>5939174.86179747</gml:Y></gml:coord><gml:coord><gml:X>3.3306013669564433E7</gml:X><gml:Y>5954878.55311782</gml:Y></gml:coord></gml:Box>"));
        }
        DownloadManagerDialog downloadManager = DownloadManagerDialog.getInstance();
        if (!downloadManager.isVisible()) {
            downloadManager.pack();
            StaticSwingTools.showDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), (JDialog)downloadManager, (boolean)true);
        }
    }
}

