/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.shapeexport;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Date;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.deegree.io.shpapi.shape_new.ShapeFile;
import org.deegree.io.shpapi.shape_new.ShapeFileWriter;
import org.deegree.model.feature.FeatureCollection;

public class ShapeExportHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeShapeFileToZip(FeatureCollection featureCollection, String shapeFileName, File tempDirectory, ZipOutputStream zipStream, String esriWKT) throws Exception {
        File tmpSubDirectory = null;
        try {
            String subDirName = null;
            String separator = System.getProperty("file.separator");
            Random rand = new Random(new Date().getTime());
            while ((tmpSubDirectory = new File(tempDirectory, subDirName = "tmp" + rand.nextInt(Integer.MAX_VALUE))).exists()) {
            }
            tmpSubDirectory.mkdirs();
            String shapeFileBase = tmpSubDirectory.getAbsoluteFile() + separator + shapeFileName;
            ShapeFile shape = new ShapeFile(featureCollection, shapeFileBase);
            ShapeFileWriter writer = new ShapeFileWriter(shape);
            writer.write();
            if (esriWKT != null) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(shapeFileBase + ".prj"));
                bw.write(esriWKT);
                bw.close();
            }
            ShapeExportHelper.zipDirectory(tmpSubDirectory, zipStream, "");
        }
        finally {
            if (tmpSubDirectory != null && tmpSubDirectory.exists()) {
                ShapeExportHelper.deleteDirectory(tmpSubDirectory);
            }
        }
    }

    private static void deleteDirectory(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                ShapeExportHelper.deleteDirectory(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDirectory(File inputDir, ZipOutputStream out, String dirName) throws Exception {
        int BYTES_ARRAY_LENGTH = 256;
        byte[] tmp = new byte[256];
        for (File f : inputDir.listFiles()) {
            if (f.isDirectory()) {
                ShapeExportHelper.zipDirectory(f, out, dirName + "/" + f.getName() + "/");
                continue;
            }
            ZipEntry entry = new ZipEntry(dirName + f.getName());
            out.putNextEntry(entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            try {
                int byteCount;
                while ((byteCount = bis.read(tmp, 0, 256)) != -1) {
                    out.write(tmp, 0, byteCount);
                }
            }
            finally {
                out.closeEntry();
                bis.close();
            }
        }
    }
}

