/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.simplelayerwidget;

import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.MappingModelEvent;
import de.cismet.cismap.commons.MappingModelListener;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.capabilitywidget.SelectionAndCapabilities;
import de.cismet.cismap.commons.gui.capabilitywidget.WFSSelectionAndCapabilities;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerTableCellEditor;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerTableCellRenderer;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerTreeCellRenderer;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidget;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.imagetooltip.ImageToolTip;
import de.cismet.tools.gui.treetable.JTreeTable;
import de.cismet.tools.gui.treetable.TreeTableCellEditor;
import de.cismet.tools.gui.treetable.TreeTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class NewSimpleInternalLayerWidget
extends JInternalFrame
implements MappingModelListener,
TableModelListener,
DropTargetListener,
Configurable {
    private static final int ROW_HEIGHT = 18;
    private static final int WIDGET_WIDTH = 350;
    private final Logger log = Logger.getLogger(this.getClass());
    private final ImageIcon UP = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/up.png"));
    private final ImageIcon DOWN = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/down.png"));
    private final ImageIcon DELETE = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/removeLayer.png"));
    private final ImageIcon DISABLE = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disable.png"));
    private final ImageIcon INVISIBLE = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerDLinvisible.png"));
    private int layerCount = 0;
    private boolean deactivatePopupMenuButtons = true;
    private ActiveLayerModel activeLayerModel;
    private JTreeTable treeTable;
    private Image errorImage;
    private MappingComponent mc;
    private JPopupMenu popupMenu;
    private JMenuItem up;
    private JMenuItem down;
    private JMenuItem del;
    private JMenuItem vis;
    private JMenuItem dis;
    private JScrollPane scpMain;

    public NewSimpleInternalLayerWidget(MappingComponent mc) {
        this(mc, true);
    }

    public NewSimpleInternalLayerWidget(MappingComponent mc, boolean deactivatePopupMenuButtons) {
        this.log.info((Object)"NewSimpleInternalLayerWidget erstellen");
        this.deactivatePopupMenuButtons = deactivatePopupMenuButtons;
        try {
            BasicInternalFrameUI fui = (BasicInternalFrameUI)this.getUI();
            JComponent north = fui.getNorthPane();
            MouseMotionListener[] listener = (MouseMotionListener[])north.getListeners(MouseMotionListener.class);
            for (int i = 0; i < listener.length; ++i) {
                north.removeMouseMotionListener(listener[i]);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error during the removal of the Mousemotionlisteners", (Throwable)e);
        }
        this.initComponents();
        this.mc = mc;
        this.activeLayerModel = (ActiveLayerModel)mc.getMappingModel();
        this.popupMenu = new JPopupMenu();
        this.up = new JMenuItem();
        this.up.setText(NbBundle.getMessage(NewSimpleInternalLayerWidget.class, (String)"NewSimpleInternalLayerWidget.up.text"));
        this.up.setIcon(this.UP);
        this.up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final TreePath tp = NewSimpleInternalLayerWidget.this.treeTable.getTree().getSelectionPath();
                if (tp != null) {
                    NewSimpleInternalLayerWidget.this.activeLayerModel.moveLayerUp(tp);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewSimpleInternalLayerWidget.this.treeTable.getTree().setSelectionPath(tp);
                        StaticSwingTools.jTableScrollToVisible((JTable)NewSimpleInternalLayerWidget.this.treeTable, (int)NewSimpleInternalLayerWidget.this.treeTable.getSelectedRow(), (int)0);
                    }
                });
            }
        });
        this.down = new JMenuItem();
        this.down.setText(NbBundle.getMessage(NewSimpleInternalLayerWidget.class, (String)"NewSimpleInternalLayerWidget.down.text"));
        this.down.setIcon(this.DOWN);
        this.down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final TreePath tp = NewSimpleInternalLayerWidget.this.treeTable.getTree().getSelectionPath();
                if (tp != null) {
                    NewSimpleInternalLayerWidget.this.activeLayerModel.moveLayerDown(tp);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewSimpleInternalLayerWidget.this.treeTable.getTree().setSelectionPath(tp);
                        StaticSwingTools.jTableScrollToVisible((JTable)NewSimpleInternalLayerWidget.this.treeTable, (int)NewSimpleInternalLayerWidget.this.treeTable.getSelectedRow(), (int)0);
                    }
                });
            }
        });
        this.dis = new JMenuItem();
        this.dis.setText(NbBundle.getMessage(NewSimpleInternalLayerWidget.class, (String)"NewSimpleInternalLayerWidget.dis.text"));
        this.dis.setIcon(this.DISABLE);
        this.dis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final TreePath tp = NewSimpleInternalLayerWidget.this.treeTable.getTree().getSelectionPath();
                if (tp != null) {
                    NewSimpleInternalLayerWidget.this.activeLayerModel.disableLayer(tp);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewSimpleInternalLayerWidget.this.treeTable.getTree().setSelectionPath(tp);
                    }
                });
            }
        });
        this.del = new JMenuItem();
        this.del.setText(NbBundle.getMessage(NewSimpleInternalLayerWidget.class, (String)"NewSimpleInternalLayerWidget.del.text"));
        this.del.setIcon(this.DELETE);
        this.del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath tp = NewSimpleInternalLayerWidget.this.treeTable.getTree().getSelectionPath();
                final int row = NewSimpleInternalLayerWidget.this.treeTable.getSelectedRow();
                if (tp != null) {
                    NewSimpleInternalLayerWidget.this.activeLayerModel.removeLayer(tp);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewSimpleInternalLayerWidget.this.treeTable.getSelectionModel().setSelectionInterval(row, row);
                    }
                });
            }
        });
        this.vis = new JMenuItem();
        this.vis.setText(NbBundle.getMessage(NewSimpleInternalLayerWidget.class, (String)"NewSimpleInternalLayerWidget.vis.text"));
        this.vis.setIcon(this.INVISIBLE);
        this.vis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final TreePath tp = NewSimpleInternalLayerWidget.this.treeTable.getTree().getSelectionPath();
                if (tp != null) {
                    NewSimpleInternalLayerWidget.this.activeLayerModel.handleVisibility(tp);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewSimpleInternalLayerWidget.this.treeTable.getTree().setSelectionPath(tp);
                    }
                });
            }
        });
        this.popupMenu.add(this.up);
        this.popupMenu.add(this.down);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.dis);
        if (!deactivatePopupMenuButtons) {
            this.popupMenu.add(this.del);
        }
        this.popupMenu.add(this.vis);
        try {
            this.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        }
        catch (Throwable t) {
            this.log.error((Object)("Fehler beim setzen der Client Property isPalette: " + t.getMessage()), t);
        }
        if (this.activeLayerModel != null) {
            this.createTree();
        }
        mc.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NewSimpleInternalLayerWidget.this.reshapeWidget(false);
            }
        });
        this.pack();
    }

    public void setMappingModel(MappingModel mm) {
        if (mm instanceof ActiveLayerModel) {
            this.activeLayerModel = (ActiveLayerModel)mm;
            this.createTree();
        } else {
            this.log.info((Object)"MappingModel ist kein ActiveLayerModel, kann InternalWidget nicht erstellen");
        }
    }

    public boolean isDeactivatePopupMenuButtons() {
        return this.deactivatePopupMenuButtons;
    }

    public void setDeactivatePopupMenuButtons(boolean deactivate) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"setDeactivatePopupMenuButtons");
        }
        if (!this.deactivatePopupMenuButtons && deactivate) {
            this.popupMenu.remove(this.del);
        } else if (this.deactivatePopupMenuButtons && !deactivate) {
            this.popupMenu.remove(this.vis);
            this.popupMenu.add(this.del);
            this.popupMenu.add(this.vis);
        }
        this.deactivatePopupMenuButtons = deactivate;
    }

    private void createTree() {
        try {
            this.treeTable = new JTreeTable((TreeTableModel)this.activeLayerModel){

                public JToolTip createToolTip() {
                    if (NewSimpleInternalLayerWidget.this.log.isDebugEnabled()) {
                        NewSimpleInternalLayerWidget.this.log.debug((Object)"Tooltip");
                    }
                    if (NewSimpleInternalLayerWidget.this.errorImage != null) {
                        return new ImageToolTip(NewSimpleInternalLayerWidget.this.errorImage);
                    }
                    return super.createToolTip();
                }
            };
            this.treeTable.setAutoCreateColumnsFromModel(true);
            this.treeTable.setShowGrid(true);
            this.treeTable.setGridColor(this.getBackground());
            this.treeTable.setTableHeader(null);
            this.treeTable.getTree().setShowsRootHandles(true);
            this.treeTable.getTree().setRootVisible(false);
            this.treeTable.getTree().setCellRenderer(new ActiveLayerTreeCellRenderer());
            this.treeTable.getModel().addTableModelListener(this);
            this.activeLayerModel.addMappingModelListener(this);
            ActiveLayerTableCellEditor cellEditor = new ActiveLayerTableCellEditor();
            ActiveLayerTableCellRenderer tableCellRenderer = new ActiveLayerTableCellRenderer(true);
            TreeTableCellEditor treeTableCellEditor = new TreeTableCellEditor(this.treeTable, this.treeTable.getTree());
            treeTableCellEditor.setClickCountToStart(2);
            this.treeTable.setDefaultEditor(TreeTableModel.class, (TableCellEditor)treeTableCellEditor);
            this.treeTable.getColumnModel().removeColumn(this.treeTable.getColumnModel().getColumn(5));
            this.treeTable.getColumnModel().removeColumn(this.treeTable.getColumnModel().getColumn(3));
            this.treeTable.getColumnModel().removeColumn(this.treeTable.getColumnModel().getColumn(2));
            this.treeTable.getColumnModel().getColumn(0).setMaxWidth(20);
            this.treeTable.getColumnModel().getColumn(2).setMaxWidth(100);
            this.treeTable.getColumnModel().getColumn(0).setCellEditor(cellEditor);
            this.treeTable.getColumnModel().getColumn(2).setCellEditor(cellEditor);
            this.treeTable.getColumnModel().getColumn(0).setCellRenderer(tableCellRenderer);
            this.treeTable.getColumnModel().getColumn(2).setCellRenderer(tableCellRenderer);
            this.treeTable.setSelectionMode(0);
            this.treeTable.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    if (NewSimpleInternalLayerWidget.this.treeTable.getTree().getSelectionPath() != null) {
                        if (NewSimpleInternalLayerWidget.this.log.isDebugEnabled()) {
                            NewSimpleInternalLayerWidget.this.log.debug((Object)("ActiveLayerWidget: selectionChanged()\n" + e));
                        }
                        try {
                            ActiveLayerEvent ale = new ActiveLayerEvent();
                            ale.setLayer(NewSimpleInternalLayerWidget.this.treeTable.getTree().getSelectionPath().getLastPathComponent());
                            if (ale.getLayer() instanceof WMSServiceLayer) {
                                ale.setCapabilities(((WMSServiceLayer)ale.getLayer()).getWmsCapabilities());
                            }
                            CismapBroker.getInstance().fireLayerSelectionChanged(ale);
                        }
                        catch (Exception ex) {
                            NewSimpleInternalLayerWidget.this.log.warn((Object)"Error at fireLayerSelectionChanged ... no problem");
                        }
                    }
                }
            });
            this.treeTable.setGridColor(this.getBackground());
            this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        NewSimpleInternalLayerWidget.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        NewSimpleInternalLayerWidget.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.reshapeWidget(true);
            this.scpMain.setViewportView((Component)this.treeTable);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    NewSimpleInternalLayerWidget.this.treeTable.repaint();
                }
            });
        }
        catch (Exception ex) {
            this.log.error((Object)"Error during the creation of a TreeTable!", (Throwable)ex);
        }
    }

    private void initComponents() {
        this.scpMain = new JScrollPane();
        this.setMinimumSize(new Dimension(350, 50));
        this.setPreferredSize(new Dimension(350, 100));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                NewSimpleInternalLayerWidget.this.formKeyPressed(evt);
            }
        });
        this.scpMain.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.scpMain, "Center");
        this.pack();
    }

    private void formKeyPressed(KeyEvent evt) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DataFlavor TREEPATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "SelectionAndCapabilities");
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("There are " + dtde.getTransferable().getTransferDataFlavors().length + "DataFlavours"));
            }
            for (int i = 0; i < dtde.getTransferable().getTransferDataFlavors().length; ++i) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("DataFlavour" + i + ":" + dtde.getTransferable().getTransferDataFlavors()[i]));
            }
            Object trasferData = dtde.getTransferable().getTransferData(TREEPATH_FLAVOR);
            Vector<TreePath> treePaths = new Vector<TreePath>();
            dtde.dropComplete(true);
            if (trasferData instanceof SelectionAndCapabilities) {
                TreePath[] tpa = ((SelectionAndCapabilities)trasferData).getSelection();
                for (int i = 0; i < tpa.length; ++i) {
                    treePaths.add(tpa[i]);
                }
                WMSServiceLayer l = new WMSServiceLayer(treePaths);
                if (l.getWMSLayers().size() > 0) {
                    if (this.treeTable.getEditingRow() != -1 && this.treeTable.getEditingColumn() != -1) {
                        this.treeTable.getCellEditor(this.treeTable.getEditingRow(), this.treeTable.getEditingColumn()).stopCellEditing();
                    }
                    l.setWmsCapabilities(((SelectionAndCapabilities)trasferData).getCapabilities());
                    this.activeLayerModel.addLayer(l);
                }
                l.setWmsCapabilities(((SelectionAndCapabilities)trasferData).getCapabilities());
                l.setCapabilitiesUrl(((SelectionAndCapabilities)trasferData).getUrl());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("((SelectionAndCapabilities)o).getUrl()" + ((SelectionAndCapabilities)trasferData).getUrl()));
                }
            } else if (trasferData instanceof WFSSelectionAndCapabilities) {
                WFSSelectionAndCapabilities sac = (WFSSelectionAndCapabilities)trasferData;
                for (FeatureType feature : sac.getFeatures()) {
                    try {
                        WebFeatureService wfs = new WebFeatureService(feature.getPrefixedNameString(), feature.getWFSCapabilities().getURL().toString(), feature.getWFSQuery(), feature.getFeatureAttributes(), feature);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("setting PrimaryAnnotationExpression of WFS Layer to '" + sac.getIdentifier() + "' (EXPRESSIONTYPE_PROPERTYNAME)"));
                        }
                        wfs.getLayerProperties().setPrimaryAnnotationExpression(sac.getIdentifier(), 1);
                        this.activeLayerModel.addLayer(wfs);
                    }
                    catch (IllegalArgumentException schonVorhanden) {
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop(DropTargetDropEvent).JOptionPane.message"), NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop(DropTargetDropEvent).JOptionPane.title"), 0);
                    }
                }
                this.scpMain.setViewportView((Component)this.treeTable);
            }
        }
        catch (IllegalArgumentException schonVorhanden) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(NewSimpleInternalLayerWidget.class, (String)"NewSimpleInternalLayerWidget.drop(DropTargetDropEvent).JOptionPane.message"), NbBundle.getMessage(NewSimpleInternalLayerWidget.class, (String)"NewSimpleInternalLayerWidget.drop(DropTargetDropEvent).JOptionPane.title"), 0);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
    }

    public void configure(Element parent) {
        this.activeLayerModel.configure(parent);
    }

    public void masterConfigure(Element parent) {
        this.activeLayerModel.masterConfigure(parent);
    }

    public Element getConfiguration() throws NoWriteError {
        return this.activeLayerModel.getConfiguration();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        e.getColumn();
        this.treeTable.repaint(this.treeTable.getBounds());
    }

    private void reshapeWidget(boolean add) {
        Dimension pref = this.treeTable.getPreferredSize();
        pref.setSize(350, pref.height + 23);
        this.setPreferredSize(pref);
        int posX = this.mc.getWidth() - this.getWidth() - 1;
        int posY = this.mc.getHeight() - this.getHeight() - 1;
        if (add) {
            this.setBounds(posX, posY - 18, pref.width, pref.height + 18);
        } else {
            this.setBounds(posX, posY + 18, pref.width, pref.height);
        }
    }

    public void setErrorImage(Image errorImage) {
        this.errorImage = errorImage;
    }

    @Override
    public void mapServiceLayerStructureChanged(MappingModelEvent mme) {
    }

    @Override
    public void mapServiceAdded(MapService mapService) {
        this.reshapeWidget(true);
    }

    @Override
    public void mapServiceRemoved(MapService mapService) {
        this.reshapeWidget(false);
    }
}

