/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.interaction;

import com.vividsolutions.jts.geom.Coordinate;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.MappingModelListener;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidget;
import de.cismet.cismap.commons.gui.options.GPSDirectionOptions;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MeasurementListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MetaSearchFacade;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SimpleMoveListener;
import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CapabilityListener;
import de.cismet.cismap.commons.interaction.CrsChangeListener;
import de.cismet.cismap.commons.interaction.MapBoundsListener;
import de.cismet.cismap.commons.interaction.MapClickListener;
import de.cismet.cismap.commons.interaction.MapDnDListener;
import de.cismet.cismap.commons.interaction.MapSearchListener;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.interaction.events.CapabilityEvent;
import de.cismet.cismap.commons.interaction.events.CrsChangedEvent;
import de.cismet.cismap.commons.interaction.events.MapClickedEvent;
import de.cismet.cismap.commons.interaction.events.MapDnDEvent;
import de.cismet.cismap.commons.interaction.events.MapSearchEvent;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.cismap.commons.security.AbstractCredentialsProvider;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.StaticDecimalTools;
import de.cismet.tools.gui.historybutton.HistoryModelListener;
import edu.umd.cs.piccolox.event.PNotification;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class CismapBroker {
    private static final String FS = System.getProperty("file.separator");
    private static final String USER_HOME_DIRECTORY = System.getProperty("user.home");
    private static final String SERVERALIAS_FILE_NAME = "serverAliases.properties";
    private static final String DEFAULT_CISMAP_FOLDER = ".cismap";
    private static final String DEFAULT_ALIAS_FILE_PATH = "appLib" + FS + "serverAliases.properties";
    PFeature oldPfeature = null;
    private final Logger log = Logger.getLogger(this.getClass());
    private final Properties userProperties = new Properties();
    private Properties defaultProperties;
    private String cismapFolderPath = USER_HOME_DIRECTORY + FS + ".cismap";
    private File defaultAliasFile;
    private File userAliasFile;
    private Vector<CapabilityListener> capabilityListeners = new Vector();
    private Vector<MappingModelListener> mappingModelListeners = new Vector();
    private Vector<StatusListener> statusListeners = new Vector();
    private Vector<HistoryModelListener> historyModelListeners = new Vector();
    private Vector<ActiveLayerListener> activeLayerListeners = new Vector();
    private Vector<MapClickListener> mapClickListeners = new Vector();
    private Vector<MapSearchListener> mapSearchListeners = new Vector();
    private Vector<MapDnDListener> mapDnDListeners = new Vector();
    private Vector<FeatureCollectionListener> featureCollectionListeners = new Vector();
    private Vector<MapBoundsListener> mapBoundsListeners = new Vector();
    private Vector<CrsChangeListener> crsChangeListeners = new Vector();
    private Crs srs;
    private String preferredRasterFormat;
    private String preferredTransparentPref;
    private String preferredBGColor;
    private String preferredExceptionsFormat;
    private MappingComponent mappingComponent = null;
    private LayerWidget layerWidget = null;
    private ExecutorService execService = null;
    private boolean serverAliasesInited = false;
    private String defaultCrs = "EPSG:31466";
    private int DefaultCrsAlias = -1;
    private MetaSearchFacade metaSearch;
    private boolean useInternalDb = false;
    private boolean checkForOverlappingGeometriesAfterFeatureRotation = true;
    private String featureStylingComponentKey = "basic";
    private PFeature snappingVetoFeature;
    private Float minOpacityToStayEnabled = null;
    private boolean multiFeaturePopupMenuEnabled = false;
    private float defaultTranslucency = 0.2f;
    private boolean highlightFeatureOnMouseOver = true;
    private boolean enableDummyLayerWhenAvailable = true;
    private boolean enableRasterGeoReferencingToolbar = true;
    private Color measurementFillingColor;
    private Color measurementLineColor;
    private Integer measurementLineWidth;
    private GPSDirectionOptions.GPSDirection gpsAngleDirection = GPSDirectionOptions.GPSDirection.AUTO;
    private boolean WMSLayerNamesWithPath = false;
    private Map<String, String> urlAliasMapping = new HashMap<String, String>();
    private Map<String, String> variableMapping = new HashMap<String, String>();

    private CismapBroker() {
        this.execService = Executors.newCachedThreadPool();
    }

    public Map<String, String> getUrlAliasMapping() {
        return this.urlAliasMapping;
    }

    public void setUrlAliasMapping(Map<String, String> urlAliasMapping) {
        this.urlAliasMapping = urlAliasMapping;
    }

    public Map<String, String> getVariableMapping() {
        return this.variableMapping;
    }

    public void setVariableMapping(Map<String, String> variableMapping) {
        this.variableMapping = variableMapping;
    }

    public boolean isWMSLayerNamesWithPath() {
        return this.WMSLayerNamesWithPath;
    }

    public void setWMSLayerNamesWithPath(boolean WMSLayerNamesWithPath) {
        this.WMSLayerNamesWithPath = WMSLayerNamesWithPath;
    }

    public GPSDirectionOptions.GPSDirection getGpsAngleDirection() {
        return this.gpsAngleDirection;
    }

    public void setGpsAngleDirection(GPSDirectionOptions.GPSDirection gpsAngleDirection) {
        this.gpsAngleDirection = gpsAngleDirection;
    }

    public boolean isEnableRasterGeoReferencingToolbar() {
        return this.enableRasterGeoReferencingToolbar;
    }

    public void setEnableRasterGeoReferencingToolbar(boolean enableRasterGeoReferencingToolbar) {
        this.enableRasterGeoReferencingToolbar = enableRasterGeoReferencingToolbar;
    }

    public boolean isEnableDummyLayerWhenAvailable() {
        return this.enableDummyLayerWhenAvailable;
    }

    public void setEnableDummyLayerWhenAvailable(boolean enableDummyLayerWhenAvailable) {
        this.enableDummyLayerWhenAvailable = enableDummyLayerWhenAvailable;
    }

    public float getDefaultTranslucency() {
        return this.defaultTranslucency;
    }

    public void setDefaultTranslucency(float defaultTranslucency) {
        this.defaultTranslucency = defaultTranslucency;
    }

    public static CismapBroker getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public void addCapabilityListener(CapabilityListener cl) {
        if (!this.capabilityListeners.contains(cl)) {
            this.capabilityListeners.add(cl);
        }
    }

    public void removeCapabilityListener(CapabilityListener cl) {
        this.capabilityListeners.remove(cl);
    }

    public void addMappingModelListener(MappingModelListener ml) {
        if (!this.mappingModelListeners.contains(ml)) {
            this.mappingModelListeners.add(ml);
        }
    }

    public void removeMappingModelListener(MappingModelListener ml) {
        this.mappingModelListeners.remove(ml);
    }

    public void addStatusListener(StatusListener sl) {
        if (!this.statusListeners.contains(sl)) {
            this.statusListeners.add(sl);
        }
    }

    public void removeStatusListener(StatusListener sl) {
        this.statusListeners.remove(sl);
    }

    public void addHistoryModelListener(HistoryModelListener hml) {
        if (!this.historyModelListeners.contains(hml)) {
            this.historyModelListeners.add(hml);
        }
    }

    public void removeHistoryModelListener(HistoryModelListener hml) {
        this.historyModelListeners.remove(hml);
    }

    public void addActiveLayerListener(ActiveLayerListener all) {
        if (!this.activeLayerListeners.contains(all)) {
            this.activeLayerListeners.add(all);
        }
    }

    public void removeActiveLayerListener(ActiveLayerListener all) {
        this.activeLayerListeners.remove(all);
    }

    public void addMapClickListener(MapClickListener mcl) {
        if (!this.mapClickListeners.contains(mcl)) {
            this.mapClickListeners.add(mcl);
        }
    }

    public void removeMapClickListener(MapClickListener mcl) {
        this.mapClickListeners.remove(mcl);
    }

    public void addMapSearchListener(MapSearchListener msl) {
        if (!this.mapSearchListeners.contains(msl)) {
            this.mapSearchListeners.add(msl);
        }
    }

    public void removeMapSearchListener(MapSearchListener msl) {
        this.mapSearchListeners.remove(msl);
    }

    public void addMapDnDListener(MapDnDListener mdl) {
        if (!this.mapDnDListeners.contains(mdl)) {
            this.mapDnDListeners.add(mdl);
        }
    }

    public void removeMapDnDListener(MapDnDListener mdl) {
        this.mapDnDListeners.remove(mdl);
    }

    public void addFeatureCollectionListener(FeatureCollectionListener fcl) {
        if (!this.featureCollectionListeners.contains(fcl)) {
            this.featureCollectionListeners.add(fcl);
        }
    }

    public void removeFeatureCollectionListener(FeatureCollectionListener fcl) {
        this.featureCollectionListeners.remove(fcl);
    }

    public void addMapBoundsListener(MapBoundsListener mbl) {
        if (!this.mapBoundsListeners.contains(mbl)) {
            this.mapBoundsListeners.add(mbl);
        }
    }

    public void removeFMapBoundsListener(MapBoundsListener mbl) {
        this.mapBoundsListeners.remove(mbl);
    }

    public void addCrsChangeListener(CrsChangeListener mbl) {
        if (!this.crsChangeListeners.contains(mbl)) {
            this.crsChangeListeners.add(mbl);
        }
    }

    public void removeCrsChangeListener(CrsChangeListener mbl) {
        this.crsChangeListeners.remove(mbl);
    }

    public void fireCapabilityServerChanged(CapabilityEvent ce) {
        for (CapabilityListener listener : this.capabilityListeners) {
            listener.serverChanged(ce);
        }
    }

    public void fireCapabilityLayerChanged(CapabilityEvent ce) {
        for (CapabilityListener listener : this.capabilityListeners) {
            listener.layerChanged(ce);
        }
    }

    public void fireLayerAdded(ActiveLayerEvent ale) {
        Iterator<ActiveLayerListener> it = this.activeLayerListeners.iterator();
        while (it.hasNext()) {
            it.next().layerAdded(ale);
        }
    }

    public void fireLayerRemoved(ActiveLayerEvent ale) {
        for (ActiveLayerListener listener : new ArrayList<ActiveLayerListener>(this.activeLayerListeners)) {
            listener.layerRemoved(ale);
        }
    }

    public void fireLayerPositionChanged(ActiveLayerEvent ale) {
        Iterator<ActiveLayerListener> it = this.activeLayerListeners.iterator();
        while (it.hasNext()) {
            it.next().layerPositionChanged(ale);
        }
    }

    public void fireLayerVisibilityChanged(ActiveLayerEvent ale) {
        Iterator<ActiveLayerListener> it = this.activeLayerListeners.iterator();
        while (it.hasNext()) {
            it.next().layerVisibilityChanged(ale);
        }
    }

    public void fireLayerAvailabilityChanged(ActiveLayerEvent ale) {
        Iterator<ActiveLayerListener> it = this.activeLayerListeners.iterator();
        while (it.hasNext()) {
            it.next().layerAvailabilityChanged(ale);
        }
    }

    public void fireLayerInformationStatusChanged(ActiveLayerEvent ale) {
        Iterator<ActiveLayerListener> it = this.activeLayerListeners.iterator();
        while (it.hasNext()) {
            it.next().layerInformationStatusChanged(ale);
        }
    }

    public void fireLayerSelectionChanged(ActiveLayerEvent ale) {
        Iterator<ActiveLayerListener> it = this.activeLayerListeners.iterator();
        while (it.hasNext()) {
            it.next().layerSelectionChanged(ale);
        }
    }

    public void fireStatusValueChanged(StatusEvent se) {
        ArrayList<StatusListener> listenerCopy = new ArrayList<StatusListener>(this.statusListeners);
        Iterator it = listenerCopy.iterator();
        while (it.hasNext()) {
            ((StatusListener)it.next()).statusValueChanged(se);
        }
    }

    public void fireClickOnMap(MapClickedEvent mce) {
        Iterator<MapClickListener> it = this.mapClickListeners.iterator();
        while (it.hasNext()) {
            it.next().clickedOnMap(mce);
        }
    }

    public void fireMapSearchInited(MapSearchEvent mse) {
        Iterator<MapSearchListener> it = this.mapSearchListeners.iterator();
        while (it.hasNext()) {
            it.next().mapSearchStarted(mse);
        }
    }

    public void fireDropOnMap(MapDnDEvent mde) {
        Iterator<MapDnDListener> it = this.mapDnDListeners.iterator();
        while (it.hasNext()) {
            it.next().dropOnMap(mde);
        }
    }

    public void fireDragOverMap(MapDnDEvent mde) {
        Iterator<MapDnDListener> it = this.mapDnDListeners.iterator();
        while (it.hasNext()) {
            it.next().dragOverMap(mde);
        }
    }

    public void fireMapBoundsChanged() {
        Iterator<MapBoundsListener> it = this.mapBoundsListeners.iterator();
        while (it.hasNext()) {
            it.next().shownMapBoundsChanged();
        }
    }

    public void fireCrsChanged(CrsChangedEvent event) {
        Iterator<CrsChangeListener> it = this.crsChangeListeners.iterator();
        while (it.hasNext()) {
            it.next().crsChanged(event);
        }
    }

    public Vector<MapClickListener> getMapClickListeners() {
        return this.mapClickListeners;
    }

    public Crs getSrs() {
        if (this.srs == null) {
            if (this.mappingComponent == null || this.mappingComponent.isLocked()) {
                Crs crs = new Crs("dummy", "dummy", "EPSG:31466", true, false);
                return crs;
            }
            this.log.error((Object)"srs is not set. Use EPSG:31466 ", (Throwable)new CurrentStackTrace());
            Crs crs = new Crs("EPSG:31466", "EPSG:31466", "EPSG:31466", true, false);
            return crs;
        }
        return this.srs;
    }

    public void setSrs(Crs srs) {
        if (this.srs == null || !this.srs.equals(srs)) {
            StatusEvent event = new StatusEvent("crs", srs);
            CrsChangedEvent ce = new CrsChangedEvent(this.srs, srs);
            this.srs = srs;
            this.fireCrsChanged(ce);
            this.fireStatusValueChanged(event);
        }
    }

    public String getPreferredRasterFormat() {
        return this.preferredRasterFormat;
    }

    public void setPreferredRasterFormat(String preferredRasterFormat) {
        this.preferredRasterFormat = preferredRasterFormat;
    }

    public String getPreferredTransparentPref() {
        return this.preferredTransparentPref;
    }

    public void setPreferredTransparentPref(String preferredTransparentPref) {
        this.preferredTransparentPref = preferredTransparentPref;
    }

    public String getPreferredBGColor() {
        return this.preferredBGColor;
    }

    public void setPreferredBGColor(String preferredBGColor) {
        this.preferredBGColor = preferredBGColor;
    }

    public String getPreferredExceptionsFormat() {
        return this.preferredExceptionsFormat;
    }

    public void setPreferredExceptionsFormat(String preferredExceptionsFormat) {
        this.preferredExceptionsFormat = preferredExceptionsFormat;
    }

    public void setMappingComponent(MappingComponent mappingComponent) {
        this.mappingComponent = mappingComponent;
        PNotificationCenter.defaultCenter().addListener((Object)this, "coordinatesChanged", "COORDINATES_CHANGED", (Object)mappingComponent.getInputListener("MOTION"));
        PNotificationCenter.defaultCenter().addListener((Object)this, "lengthChanged", "LENGTH_CHANGED", (Object)mappingComponent.getInputListener("MEASUREMENT"));
        PNotificationCenter.defaultCenter().addListener((Object)this, "selectionChanged", "SELECTION_CHANGED_NOTIFICATION", (Object)mappingComponent.getInputListener("SELECT"));
    }

    public MetaSearchFacade getMetaSearch() {
        return this.metaSearch;
    }

    public void setMetaSearch(MetaSearchFacade metaSearch) {
        this.metaSearch = metaSearch;
    }

    public void coordinatesChanged(PNotification notification) {
        Object o = notification.getObject();
        if (o instanceof SimpleMoveListener) {
            double x = ((SimpleMoveListener)((Object)o)).getXCoord();
            double y = ((SimpleMoveListener)((Object)o)).getYCoord();
            this.fireStatusValueChanged(new StatusEvent("coordinate_string", new Coordinate(x, y)));
            PFeature pf = ((SimpleMoveListener)((Object)o)).getUnderlyingPFeature();
            if (pf != this.oldPfeature) {
                this.fireStatusValueChanged(new StatusEvent("object_infos", pf));
                this.oldPfeature = pf;
            }
        }
    }

    public void lengthChanged(PNotification notification) {
        Object o = notification.getObject();
        if (o instanceof MeasurementListener) {
            double length = ((MeasurementListener)((Object)o)).getMeasuredLength();
            this.fireStatusValueChanged(new StatusEvent("measurement", StaticDecimalTools.round((String)"0.00", (double)length) + " m"));
        }
    }

    public void selectionChanged(PNotification notification) {
    }

    public MappingComponent getMappingComponent() {
        return this.mappingComponent;
    }

    public String aliasToUrl(String url) {
        if (url == null) {
            return null;
        }
        for (String alias : this.urlAliasMapping.keySet()) {
            if (!url.equals(alias)) continue;
            return this.replaceVariableInAlias(this.urlAliasMapping.get(alias));
        }
        return url;
    }

    public String urlToAlias(String url) {
        String alias = this.toAliasIfExists(url);
        if (alias != null) {
            return alias;
        }
        return url;
    }

    private String toAliasIfExists(String url) {
        if (url == null) {
            return null;
        }
        for (String alias : this.urlAliasMapping.keySet()) {
            Map<String, String> urlAliasMap;
            Map<String, String> urlMap;
            String urlPart = this.urlAliasMapping.get(alias);
            if (urlPart.endsWith("&")) {
                urlPart = urlPart.substring(0, urlPart.length() - 1);
            }
            if (url.endsWith("&")) {
                url = url.substring(0, url.length() - 1);
            }
            if (url.equals(urlPart) || url.equals(this.replaceVariableInAlias(urlPart))) {
                return alias;
            }
            String aliasUrl = this.replaceVariableInAlias(urlPart);
            if (!url.contains("?") || aliasUrl == null || !aliasUrl.contains("?") || !url.substring(0, url.indexOf("?")).equalsIgnoreCase(aliasUrl.substring(0, aliasUrl.indexOf("?"))) || !(urlMap = this.getParameterMap(url)).equals(urlAliasMap = this.getParameterMap(aliasUrl))) continue;
            return alias;
        }
        return null;
    }

    private Map<String, String> getParameterMap(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (url != null && url.contains("?") && url.length() > url.indexOf("?") + 1) {
            String parameters = url.substring(url.indexOf("?") + 1);
            StringTokenizer st = new StringTokenizer(parameters, "&");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                if (param.contains("=")) {
                    map.put(param.substring(0, param.indexOf("=")), param.substring(param.indexOf("=") + 1));
                    continue;
                }
                map.put(param, "");
            }
        }
        return map;
    }

    public String replaceVariableInAlias(String url) {
        String result = url;
        if (result == null) {
            return null;
        }
        for (String alias : this.variableMapping.keySet()) {
            if (!result.contains("${{" + alias + "}}")) continue;
            result = result.replace("${{" + alias + "}}", this.variableMapping.get(alias));
        }
        return result;
    }

    public boolean isAlias(String link) {
        return this.urlAliasMapping.containsKey(link);
    }

    public boolean isAliasDefinedForUrl(String url) {
        String alias = this.toAliasIfExists(url);
        return alias != null;
    }

    private void initAliases() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"initializing server aliases property");
        }
        try {
            FileInputStream in;
            this.userAliasFile = new File(this.getCismapFolderPath() + FS + SERVERALIAS_FILE_NAME);
            File cismapFolder = new File(this.getCismapFolderPath());
            if (!cismapFolder.exists()) {
                cismapFolder.mkdir();
            }
            if (this.userAliasFile.exists()) {
                in = new FileInputStream(this.userAliasFile);
                this.userProperties.load(in);
                in.close();
            } else {
                this.userAliasFile.createNewFile();
            }
            this.defaultAliasFile = new File(DEFAULT_ALIAS_FILE_PATH);
            this.defaultProperties = new Properties(this.userProperties);
            if (this.defaultAliasFile.exists()) {
                in = new FileInputStream(this.defaultAliasFile);
                this.defaultProperties.load(in);
                in.close();
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"Error during reading the server aliases from file", (Throwable)ex);
        }
        this.serverAliasesInited = true;
    }

    public void cleanUpSystemRegistry() {
        Preferences appPrefs = Preferences.userNodeForPackage(AbstractCredentialsProvider.class);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Try to delete preferences of the password dialog");
            }
            appPrefs.removeNode();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"deletion of the preferences successfully");
            }
        }
        catch (BackingStoreException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Error during the deletion of the preferences");
            }
            ex.printStackTrace();
        }
    }

    public void writePropertyFile() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"writing server Aliases to File");
        }
        if (!this.serverAliasesInited) {
            this.initAliases();
        }
        try {
            if (this.userAliasFile.exists()) {
                FileOutputStream out = new FileOutputStream(this.userAliasFile);
                this.userProperties.store(out, "Server Aliases URL <---> Alias");
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"Error during writing the server aliases to file", (Throwable)ex);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Server Aliases wrote to File");
        }
    }

    public void addProperty(String key, String value) {
        if (!this.serverAliasesInited) {
            this.initAliases();
        }
        this.userProperties.setProperty(key, value);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Server alias added  key: " + key + " value: " + value));
        }
    }

    public String getProperty(String key) {
        if (!this.serverAliasesInited) {
            this.initAliases();
        }
        return this.defaultProperties.getProperty(key);
    }

    public void execute(SwingWorker workerThread) {
        try {
            this.execService.submit(workerThread);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"SwingWorker submitted to Threadpool");
            }
        }
        catch (Exception ex) {
            this.log.fatal((Object)"SwingWorker Error", (Throwable)ex);
        }
    }

    public String getCismapFolderPath() {
        return this.cismapFolderPath;
    }

    public void setCismapFolderPath(String cismapFolderPath) {
        try {
            File cismapFolder = new File(cismapFolderPath);
            if (!cismapFolder.exists()) {
                cismapFolder.mkdir();
            }
        }
        catch (Exception e) {
            this.log.fatal((Object)("Error during the creation of " + cismapFolderPath), (Throwable)e);
        }
        this.cismapFolderPath = cismapFolderPath;
    }

    public String getDefaultCrs() {
        return this.defaultCrs;
    }

    public void setDefaultCrs(String defaultCrs) {
        this.defaultCrs = defaultCrs;
    }

    public int getDefaultCrsAlias() {
        return this.DefaultCrsAlias;
    }

    public void setDefaultCrsAlias(int DefaultCrsAlias) {
        this.DefaultCrsAlias = DefaultCrsAlias;
    }

    public Crs crsFromCode(String code) {
        Crs result = null;
        if (code == null || code.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"The given code is null or empty. Can't find a Crs object without a code.");
            }
            return result;
        }
        if (this.mappingComponent == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"CismapBroker didn't provide a mapping component. So it's impossible to retrieve the crs list.");
            }
            return result;
        }
        List<Crs> crsList = this.mappingComponent.getCrsList();
        if (crsList == null || crsList.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"The crs list of the mapping component is empty. So it's impossible to find a matching Crs object.");
            }
            return result;
        }
        String matchCode = !code.toUpperCase().startsWith("EPSG:") ? "EPSG:".concat(code) : code;
        for (Crs crs : crsList) {
            if (crs == null || crs.getCode() == null || !crs.getCode().equalsIgnoreCase(matchCode)) continue;
            result = crs;
        }
        if (result == null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Couldn't find a crs for code '" + code + "' in crs list '" + crsList + "'."));
        }
        return result;
    }

    public boolean isUseInternalDb() {
        return this.useInternalDb;
    }

    public void setUseInternalDb(boolean useInternalDb) {
        this.useInternalDb = useInternalDb;
    }

    public boolean isCheckForOverlappingGeometriesAfterFeatureRotation() {
        return this.checkForOverlappingGeometriesAfterFeatureRotation;
    }

    public void setCheckForOverlappingGeometriesAfterFeatureRotation(boolean checkForOverlappingGeometriesAfterFeatureRotation) {
        this.checkForOverlappingGeometriesAfterFeatureRotation = checkForOverlappingGeometriesAfterFeatureRotation;
    }

    public String getFeatureStylingComponentKey() {
        return this.featureStylingComponentKey;
    }

    public void setFeatureStylingComponentKey(String featureStylingComponentKey) {
        this.featureStylingComponentKey = featureStylingComponentKey;
    }

    public PFeature getSnappingVetoFeature() {
        return this.snappingVetoFeature;
    }

    public void setSnappingVetoFeature(PFeature snappingVetoFeature) {
        this.snappingVetoFeature = snappingVetoFeature;
    }

    public Float getMinOpacityToStayEnabled() {
        return this.minOpacityToStayEnabled;
    }

    public void setMinOpacityToStayEnabled(Float minOpacityToStayEnabled) {
        this.minOpacityToStayEnabled = minOpacityToStayEnabled;
    }

    public boolean isMultiFeaturePopupMenuEnabled() {
        return this.multiFeaturePopupMenuEnabled;
    }

    public void setMultiFeaturePopupMenuEnabled(boolean multiFeaturePopupMenuEnabled) {
        this.multiFeaturePopupMenuEnabled = multiFeaturePopupMenuEnabled;
    }

    public boolean isHighlightFeatureOnMouseOver() {
        return this.highlightFeatureOnMouseOver;
    }

    public void setHighlightFeatureOnMouseOver(boolean highlightFeatureOnMouseOver) {
        this.highlightFeatureOnMouseOver = highlightFeatureOnMouseOver;
    }

    public Color getMeasurementFillingColor() {
        return this.measurementFillingColor;
    }

    public void setMeasurementFillingColor(Color measurementFillingColor) {
        this.measurementFillingColor = measurementFillingColor;
    }

    public Color getMeasurementLineColor() {
        return this.measurementLineColor;
    }

    public void setMeasurementLineColor(Color measurementLineColor) {
        this.measurementLineColor = measurementLineColor;
    }

    public Integer getMeasurementLineWidth() {
        return this.measurementLineWidth;
    }

    public void setMeasurementLineWidth(Integer measurementLineWidth) {
        this.measurementLineWidth = measurementLineWidth;
    }

    private static final class LazyInitialiser {
        private static final CismapBroker INSTANCE = new CismapBroker();

        private LazyInitialiser() {
        }
    }
}

