/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.interaction;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class DefaultQueryButtonAction
implements ActionListener {
    protected Logger LOG = Logger.getLogger(DefaultQueryButtonAction.class);
    protected JTextArea queryTextArea;
    protected String text;
    protected String queryText;
    protected int width;
    protected boolean startWithSpace = true;
    protected int posCorrection = 0;

    public DefaultQueryButtonAction() {
        this("");
    }

    public DefaultQueryButtonAction(String text) {
        this(text, 2);
    }

    public DefaultQueryButtonAction(String queryText, String text) {
        this(queryText, text, 2);
    }

    public DefaultQueryButtonAction(String text, int width) {
        this(text, 2, 0);
    }

    public DefaultQueryButtonAction(String queryText, String text, int width) {
        this(queryText, text, 2, 0);
    }

    public DefaultQueryButtonAction(String text, int width, int posCorrection) {
        this(text, text, width, posCorrection);
    }

    public DefaultQueryButtonAction(String queryText, String text, int width, int posCorrection) {
        this.queryText = queryText;
        this.text = text;
        this.width = width;
        this.posCorrection = posCorrection;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getQueryTextArea().getSelectionEnd() == this.getQueryTextArea().getSelectionStart()) {
            this.AppendString(this.queryText);
            this.CorrectCarret(this.posCorrection);
        } else {
            this.WriteOver(this.queryText);
            this.CorrectCarret(this.posCorrection);
        }
    }

    protected void CorrectCarret(int change) {
        if (change != 0) {
            this.getQueryTextArea().setCaretPosition(this.getQueryTextArea().getCaretPosition() + change);
        }
    }

    protected void WriteOver(String str) {
        String text1 = this.getQueryTextArea().getText().substring(0, this.getQueryTextArea().getSelectionStart());
        String text2 = this.getQueryTextArea().getText().substring(this.getQueryTextArea().getSelectionEnd());
        if (text1.length() >= 1) {
            switch (text1.charAt(text1.length() - 1)) {
                case ' ': 
                case '(': {
                    text1 = text1 + " ";
                }
            }
        }
        if (text2.length() >= 1) {
            switch (text2.charAt(0)) {
                case ' ': 
                case '(': {
                    text2 = " " + text2;
                }
            }
        }
        this.getQueryTextArea().setText(text1 + str + text2);
    }

    protected void AppendString(String str) {
        if (this.getQueryTextArea().getText() != null && !this.queryTextArea.getText().isEmpty()) {
            try {
                if (!this.queryTextArea.getText(this.queryTextArea.getCaretPosition() - 1, 1).contains("(")) {
                    str = (this.startWithSpace ? " " : "") + str;
                }
            }
            catch (BadLocationException ex) {
                this.LOG.error((Object)"Error ewhile appending string", (Throwable)ex);
                str = (this.startWithSpace ? " " : "") + str;
            }
        }
        this.getQueryTextArea().insert(str, this.getQueryTextArea().getCaretPosition());
    }

    public JTextArea getQueryTextArea() {
        return this.queryTextArea;
    }

    public void setQueryTextArea(JTextArea queryTextArea) {
        this.queryTextArea = queryTextArea;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

