/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.preferences;

import de.cismet.cismap.commons.interaction.CismapBroker;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class CapabilityLink {
    public static final String OGC = "OGC";
    public static final String OGC_DEPRECATED = "OGC-WMS";
    public static final String SEPARATOR = "SEPARATOR";
    public static final String MENU = "MENU";
    public static final String INTERNAL_DB = "INTERNAL-DB";
    private String type;
    private String subparent;
    private String link;
    private String alias;
    private String title;
    private String version;
    private boolean active = false;
    private boolean reverseAxisOrder = false;

    public CapabilityLink(Element parent) {
        Element e = parent.getChild("capabilities");
        this.type = e.getAttribute("type").getValue();
        try {
            this.active = e.getAttribute("active").getBooleanValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.reverseAxisOrder = e.getAttribute("reverseAxisOrder").getBooleanValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.alias = e.getAttributeValue("alias");
        this.link = e.getTextTrim();
        this.link = CismapBroker.getInstance().urlToAlias(this.link);
        if (e.getAttribute("version") != null) {
            this.version = e.getAttribute("version").getValue();
        }
    }

    public CapabilityLink(String type, String link, boolean reverseAxisOrder, boolean active) {
        this(type, link, reverseAxisOrder, active, null, CismapBroker.getInstance().urlToAlias(link));
    }

    public CapabilityLink(String type, String link, boolean reverseAxisOrder, String title) {
        this(type, link, reverseAxisOrder, title, null);
    }

    public CapabilityLink(String type, String link, boolean reverseAxisOrder, String title, String subparent) {
        this.type = type;
        this.link = CismapBroker.getInstance().urlToAlias(link);
        this.title = title;
        this.subparent = subparent;
        this.reverseAxisOrder = reverseAxisOrder;
    }

    public CapabilityLink(String type, String link, boolean reverseAxisOrder, boolean active, String subparent, String alias) {
        this.type = type;
        this.link = link;
        this.active = active;
        this.subparent = subparent;
        this.alias = alias;
        this.reverseAxisOrder = reverseAxisOrder;
    }

    public CapabilityLink(String type, String link, boolean reverseAxisOrder, String version, boolean active, String alias) {
        this(type, link, active, null);
        this.version = version;
        this.alias = alias;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLink() {
        if (this.alias != null && CismapBroker.getInstance().isAlias(this.alias)) {
            return CismapBroker.getInstance().aliasToUrl(this.alias);
        }
        return CismapBroker.getInstance().aliasToUrl(this.link);
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Element getElement() {
        Element elem = new Element("capabilities");
        if (CismapBroker.getInstance().isAlias(this.link)) {
            elem.setAttribute("alias", this.link);
        } else if (CismapBroker.getInstance().isAliasDefinedForUrl(this.link)) {
            elem.setAttribute("alias", CismapBroker.getInstance().urlToAlias(this.link));
        }
        CDATA cd = new CDATA(CismapBroker.getInstance().aliasToUrl(this.link));
        elem.addContent((Content)cd);
        elem.setAttribute(new Attribute("type", this.type));
        if (this.isReverseAxisOrder()) {
            elem.setAttribute("reverseAxisOrder", String.valueOf(this.isReverseAxisOrder()));
        }
        if (this.subparent != null) {
            elem.setAttribute(new Attribute("subparent", this.subparent));
        }
        elem.setAttribute(new Attribute("active", new Boolean(this.active).toString()));
        if (this.version != null) {
            elem.setAttribute(new Attribute("version", this.version));
        }
        return elem;
    }

    public Element getElementAsListEntry() {
        Element elem = new Element("capabilitiesList");
        CDATA cd = new CDATA(this.link);
        elem.addContent((Content)cd);
        elem.setAttribute("titlestring", this.title);
        if (!this.isReverseAxisOrder()) {
            elem.setAttribute("reverseAxisOrder", String.valueOf(this.isReverseAxisOrder()));
        }
        elem.setAttribute(new Attribute("type", this.type));
        if (this.subparent != null) {
            elem.setAttribute(new Attribute("subparent", this.subparent));
        }
        if (this.version != null) {
            elem.setAttribute(new Attribute("version", this.version));
        }
        return elem;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getSubparent() {
        return this.subparent;
    }

    public void setSubparent(String subparent) {
        this.subparent = subparent;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isReverseAxisOrder() {
        return this.reverseAxisOrder;
    }

    public void setReverseAxisOrder(boolean reverseAxisOrder) {
        this.reverseAxisOrder = reverseAxisOrder;
    }
}

