/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms.googlemaps;

import de.cismet.cismap.commons.raster.wms.googlemaps.GMGISPosition;

class GMBoundingBox {
    private GMGISPosition topLeft = null;
    private GMGISPosition bottomRight = null;

    public GMBoundingBox() {
    }

    public GMBoundingBox(GMGISPosition top, GMGISPosition bottom) {
        this.topLeft = top;
        this.bottomRight = bottom;
    }

    public GMGISPosition getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(GMGISPosition bottomRight) {
        this.bottomRight = bottomRight;
    }

    public GMGISPosition getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(GMGISPosition topLeft) {
        this.topLeft = topLeft;
    }

    public GMGISPosition middle() {
        return GMBoundingBox.middle(this);
    }

    public static GMGISPosition middle(GMBoundingBox box) {
        double west = box.getTopLeft().longitude;
        double north = box.getTopLeft().latitude;
        double east = box.getBottomRight().longitude;
        double south = box.getBottomRight().latitude;
        double middlelat = -1.0;
        double middlelong = -1.0;
        middlelat = north > south ? north + (south - north) / 2.0 : north + (north - south) / 2.0;
        middlelong = east > west ? west + (east - west) / 2.0 : west + (west - east) / 2.0;
        return new GMGISPosition(middlelat, middlelong);
    }

    public double width() {
        return GMBoundingBox.width(this);
    }

    public static double width(GMBoundingBox box) {
        double west = box.getTopLeft().longitude;
        double east = box.getBottomRight().longitude;
        double width = -1.0;
        width = east > west ? east - west : west - east;
        return width;
    }

    public double height() {
        return GMBoundingBox.height(this);
    }

    public static double height(GMBoundingBox box) {
        double north = box.getTopLeft().latitude;
        double south = box.getBottomRight().latitude;
        double height = -1.0;
        height = north > south ? north - south : south - north;
        return height;
    }
}

