/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms.googlemaps;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;

public class GoogleTileUtils {
    private GoogleTileUtils() {
    }

    public static BufferedImage getDebugTileFor(String keyholeString) {
        BufferedImage img = new BufferedImage(256, 256, 1);
        Graphics g = img.getGraphics();
        g.setColor(Color.gray);
        g.fillRect(0, 0, 256, 256);
        g.setColor(Color.black);
        int scale = 400 / keyholeString.length();
        g.setFont(new Font("Serif", 1, scale));
        g.drawString(keyholeString + " (z=" + GoogleTileUtils.getTileZoom(keyholeString) + ")", 10, 200);
        Rectangle2D.Double r = GoogleTileUtils.getLatLong(keyholeString);
        DecimalFormat df = new DecimalFormat("#.####");
        g.setFont(new Font("SanSerif", 0, 15));
        g.drawString(df.format(r.getMinY()) + "," + df.format(r.getMinX()) + " (w:" + df.format(((RectangularShape)r).getWidth()) + " h:" + df.format(((RectangularShape)r).getHeight()) + ")", 10, 250);
        g.drawString(df.format(r.getMaxY()) + "," + df.format(r.getMaxX()), 150, 20);
        g.drawRect(1, 1, 255, 255);
        g.dispose();
        return img;
    }

    public static BufferedImage getDebugTileFor(int x, int y, int zoom) {
        BufferedImage img = new BufferedImage(256, 256, 1);
        Graphics g = img.getGraphics();
        g.setColor(Color.gray);
        g.fillRect(0, 0, 256, 256);
        g.setColor(Color.black);
        int scale = 20;
        g.setFont(new Font("Serif", 1, 20));
        g.drawString("x:" + x + " y:" + y + " z:" + zoom, 10, 200);
        Rectangle2D.Double r = GoogleTileUtils.getLatLong(x, y, zoom);
        DecimalFormat df = new DecimalFormat("#.####");
        g.setFont(new Font("SanSerif", 0, 15));
        g.drawString(df.format(r.getMinY()) + "," + df.format(r.getMinX()) + " (w:" + df.format(((RectangularShape)r).getWidth()) + " h:" + df.format(((RectangularShape)r).getHeight()) + ")", 10, 250);
        g.drawString(df.format(r.getMaxY()) + "," + df.format(r.getMaxX()), 150, 20);
        g.drawRect(1, 1, 255, 255);
        g.dispose();
        return img;
    }

    public static Rectangle2D.Double getLatLong(String keyholeStr) {
        if (keyholeStr == null || keyholeStr.length() == 0 || keyholeStr.charAt(0) != 't') {
            throw new RuntimeException("Keyhole string must start with 't'");
        }
        double lon = -180.0;
        double lonWidth = 360.0;
        double lat = -1.0;
        double latHeight = 2.0;
        block6: for (int i = 1; i < keyholeStr.length(); ++i) {
            lonWidth /= 2.0;
            latHeight /= 2.0;
            char c = keyholeStr.charAt(i);
            switch (c) {
                case 's': {
                    lon += lonWidth;
                    continue block6;
                }
                case 'r': {
                    lat += latHeight;
                    lon += lonWidth;
                    continue block6;
                }
                case 'q': {
                    lat += latHeight;
                    continue block6;
                }
                case 't': {
                    continue block6;
                }
                default: {
                    throw new RuntimeException("unknown char '" + c + "' when decoding keyhole string.");
                }
            }
        }
        latHeight += lat;
        latHeight = 2.0 * Math.atan(Math.exp(Math.PI * latHeight)) - 1.5707963267948966;
        latHeight *= 57.29577951308232;
        lat = 2.0 * Math.atan(Math.exp(Math.PI * lat)) - 1.5707963267948966;
        latHeight -= (lat *= 57.29577951308232);
        if (lonWidth < 0.0) {
            lon += lonWidth;
            lonWidth = -lonWidth;
        }
        if (latHeight < 0.0) {
            lat += latHeight;
            latHeight = -latHeight;
        }
        return new Rectangle2D.Double(lon, lat, lonWidth, latHeight);
    }

    public static Rectangle2D.Double getLatLong(int x, int y, int zoom) {
        double lon = -180.0;
        double lonWidth = 360.0;
        double lat = -1.0;
        double latHeight = 2.0;
        int tilesAtThisZoom = 1 << 17 - zoom;
        lonWidth = 360.0 / (double)tilesAtThisZoom;
        lon = -180.0 + (double)x * lonWidth;
        latHeight = -2.0 / (double)tilesAtThisZoom;
        lat = 1.0 + (double)y * latHeight;
        latHeight += lat;
        latHeight = 2.0 * Math.atan(Math.exp(Math.PI * latHeight)) - 1.5707963267948966;
        latHeight *= 57.29577951308232;
        lat = 2.0 * Math.atan(Math.exp(Math.PI * lat)) - 1.5707963267948966;
        latHeight -= (lat *= 57.29577951308232);
        if (lonWidth < 0.0) {
            lon += lonWidth;
            lonWidth = -lonWidth;
        }
        if (latHeight < 0.0) {
            lat += latHeight;
            latHeight = -latHeight;
        }
        return new Rectangle2D.Double(lon, lat, lonWidth, latHeight);
    }

    public static String getTileRef(double lon, double lat, int zoom) {
        zoom = 18 - zoom;
        if (lon > 180.0) {
            lon -= 360.0;
        }
        lon /= 180.0;
        lat = Math.log(Math.tan(0.7853981633974483 + 1.5707963267948966 * lat / 180.0)) / Math.PI;
        double tLat = -1.0;
        double tLon = -1.0;
        double lonWidth = 2.0;
        double latHeight = 2.0;
        StringBuffer keyholeString = new StringBuffer("t");
        for (int i = 0; i < zoom; ++i) {
            lonWidth /= 2.0;
            if (tLat + (latHeight /= 2.0) > lat) {
                if (tLon + lonWidth > lon) {
                    keyholeString.append('t');
                    continue;
                }
                tLon += lonWidth;
                keyholeString.append('s');
                continue;
            }
            tLat += latHeight;
            if (tLon + lonWidth > lon) {
                keyholeString.append('q');
                continue;
            }
            tLon += lonWidth;
            keyholeString.append('r');
        }
        return keyholeString.toString();
    }

    public static int getTileZoom(String keyHoleString) {
        return 18 - keyHoleString.length();
    }

    public static void main(String[] args) {
        System.out.println(GoogleTileUtils.getLatLong(0, 0, 15));
        System.out.println(GoogleTileUtils.getLatLong(1, 1, 15));
        System.out.println(GoogleTileUtils.getLatLong(2, 2, 15));
        System.out.println(GoogleTileUtils.getLatLong(3, 3, 15));
    }
}

