/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice;

import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.swing.JComponent;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class HTTPImageRetrieval
extends Thread {
    Image image = null;
    HttpClient client;
    GetMethod method;
    String url;
    private final Logger log = Logger.getLogger(this.getClass());
    private RetrievalListener listener = null;
    private ImageObserverInterceptor observer;
    private ByteArrayOutputStream byteArrayOut = null;
    private boolean youngerCall = false;

    public HTTPImageRetrieval(RetrievalListener listener) {
        super("HTTPImageRetrieval");
        String proxySet;
        this.listener = listener;
        this.client = new HttpClient();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("proxySet:" + System.getProperty("http.proxyHost")));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ProxyHost:" + System.getProperty("http.proxyHost")));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ProxyPort:" + System.getProperty("http.proxyPort")));
        }
        if ((proxySet = System.getProperty("proxySet")) != null && proxySet.equals("true")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"proxyIs Set");
                this.log.debug((Object)("ProxyHost:" + System.getProperty("http.proxyHost")));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ProxyPort:" + System.getProperty("http.proxyPort")));
            }
            try {
                this.client.getHostConfiguration().setProxy(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")));
            }
            catch (Exception e) {
                this.log.error((Object)"Problem while setting proxy", (Throwable)e);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"no proxyIs Set");
        }
    }

    @Override
    public void run() {
        block13: {
            if (this.method != null) {
                this.method.abort();
            }
            this.method = new GetMethod(this.url);
            if (!this.method.isAborted()) {
                try {
                    block14: {
                        int c;
                        int statusCode = this.client.executeMethod((HttpMethod)this.method);
                        if (statusCode == -1) break block13;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("reading: " + this.url));
                        }
                        InputStream is = this.method.getResponseBodyAsStream();
                        BufferedInputStream in = new BufferedInputStream(is);
                        this.byteArrayOut = new ByteArrayOutputStream();
                        while ((c = in.read()) != -1) {
                            this.byteArrayOut.write(c);
                            if (!this.youngerCall) continue;
                            this.fireLoadingAborted();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"interrupt during retrieval");
                            }
                            return;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"creating image");
                        }
                        this.observer = new ImageObserverInterceptor();
                        this.image = Toolkit.getDefaultToolkit().createImage(this.byteArrayOut.toByteArray());
                        this.observer.prepareImage(this.image, this.observer);
                        do {
                            if ((this.observer.checkImage(this.image, this.observer) & 0x20) == 32) break block14;
                            Thread.sleep(10L);
                        } while (!this.youngerCall);
                        this.fireLoadingAborted();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"interrupt during assembling");
                        }
                        return;
                    }
                    RetrievalEvent e = new RetrievalEvent();
                    e.setIsComplete(true);
                    e.setRetrievedObject(this.image);
                    if (!this.youngerCall) {
                        this.listener.retrievalComplete(e);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Retrieval complete");
                        }
                    } else {
                        this.fireLoadingAborted();
                    }
                    this.method.releaseConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void endRetrieval() {
        if (this.method != null) {
            this.method.abort();
        }
        this.youngerCall = true;
    }

    public void fireLoadingAborted() {
        this.log.info((Object)"Retrieval interrupted");
        if (this.method != null && !this.method.isAborted()) {
            this.method.abort();
        }
        this.image = null;
        this.observer = null;
        System.gc();
    }

    private class ImageObserverInterceptor
    extends JComponent {
        private ImageObserverInterceptor() {
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            boolean ret = super.imageUpdate(img, infoflags, x, y, width, height);
            if ((infoflags & 8) != 0) {
                RetrievalEvent e = new RetrievalEvent();
                e.setPercentageDone((int)((double)y / ((double)img.getHeight(this) - 1.0) * 100.0));
                HTTPImageRetrieval.this.listener.retrievalProgress(e);
            } else if ((infoflags & 0x80) == 0 && (infoflags & 0x40) != 0) {
                RetrievalEvent e = new RetrievalEvent();
                e.setHasErrors(true);
                String error = new String(HTTPImageRetrieval.this.byteArrayOut.toByteArray());
                e.setRetrievedObject(error);
                HTTPImageRetrieval.this.listener.retrievalError(e);
            }
            return ret;
        }
    }
}

