/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice;

import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

@Deprecated
public class HTTPImageRetrievalWithAuth
extends Thread {
    Image image = null;
    HttpClient client;
    GetMethod method;
    String url;
    private final Logger log = Logger.getLogger(this.getClass());
    private RetrievalListener listener = null;
    private ImageObserverInterceptor observer;
    private ByteArrayOutputStream byteArrayOut = null;
    private boolean youngerCall = false;

    public HTTPImageRetrievalWithAuth(RetrievalListener listener) {
        super("HTTPImageRetrievalWithAuth");
        this.listener = listener;
        this.client = new HttpClient();
        String proxySet = System.getProperty("proxySet");
        if (proxySet != null && proxySet.equals("true")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"proxyIs Set");
                this.log.debug((Object)("ProxyHost:" + System.getProperty("http.proxyHost")));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ProxyPort:" + System.getProperty("http.proxyPort")));
            }
            try {
                this.client.getHostConfiguration().setProxy(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")));
            }
            catch (Exception e) {
                this.log.error((Object)"Problem while setting proxy", (Throwable)e);
            }
        }
        this.client.getParams().setParameter("http.authentication.credential-provider", (Object)new ConsoleAuthPrompter());
    }

    @Override
    public void run() {
        if (this.method != null) {
            this.method.abort();
        }
        this.method = new GetMethod(this.url);
        this.method.setDoAuthentication(true);
        if (!this.method.isAborted()) {
            try {
                int statusCode = this.client.executeMethod((HttpMethod)this.method);
                if (statusCode == 401) {
                    System.err.println("Unauthorized: " + this.method.getStatusLine());
                    this.fireAuthenticationFailed();
                    this.method.releaseConnection();
                    RetrievalEvent e = new RetrievalEvent();
                    e.setIsComplete(true);
                    this.listener.retrievalAborted(e);
                } else if (statusCode != -1) {
                    int c;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("reading: " + this.url));
                    }
                    InputStream is = this.method.getResponseBodyAsStream();
                    BufferedInputStream in = new BufferedInputStream(is);
                    this.byteArrayOut = new ByteArrayOutputStream();
                    while ((c = in.read()) != -1) {
                        this.byteArrayOut.write(c);
                        if (!this.youngerCall) continue;
                        this.fireLoadingAborted();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"interrupt during retrieval");
                        }
                        return;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"creating image");
                    }
                    this.observer = new ImageObserverInterceptor();
                    this.image = Toolkit.getDefaultToolkit().createImage(this.byteArrayOut.toByteArray());
                    this.observer.prepareImage(this.image, this.observer);
                    while ((this.observer.checkImage(this.image, this.observer) & 0x20) != 32) {
                        Thread.sleep(10L);
                        if (!this.youngerCall) continue;
                        this.fireLoadingAborted();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"interrupt during assembling");
                        }
                        return;
                    }
                    RetrievalEvent e = new RetrievalEvent();
                    e.setIsComplete(true);
                    e.setRetrievedObject(this.image);
                    if (!this.youngerCall) {
                        this.listener.retrievalComplete(e);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Retrieval complete");
                        }
                    } else {
                        this.fireLoadingAborted();
                    }
                    this.method.releaseConnection();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void endRetrieval() {
        if (this.method != null) {
            this.method.abort();
        }
        this.youngerCall = true;
    }

    public void fireLoadingAborted() {
        this.log.info((Object)"Retrieval interrupted");
        if (this.method != null && !this.method.isAborted()) {
            this.method.abort();
        }
        this.image = null;
        this.observer = null;
        System.gc();
    }

    public void fireAuthenticationFailed() {
        this.log.info((Object)"AuthenticationFailed");
        if (this.method != null && !this.method.isAborted()) {
            this.method.abort();
        }
        this.image = null;
        this.observer = null;
        System.gc();
    }

    public class ConsoleAuthPrompter
    implements CredentialsProvider {
        private UsernamePasswordCredentials creds;

        public void setUsernamePassword(UsernamePasswordCredentials creds) {
            this.creds = creds;
        }

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            if (authscheme == null) {
                return null;
            }
            try {
                if (authscheme instanceof NTLMScheme) {
                    this.requestUsernamePassword();
                    return this.creds;
                }
                if (authscheme instanceof RFC2617Scheme) {
                    this.requestUsernamePassword();
                    return this.creds;
                }
                throw new CredentialsNotAvailableException("Unna gsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }

        private void requestUsernamePassword() {
            Frame dummy = null;
            final JDialog requestDialog = new JDialog(dummy, NbBundle.getMessage(HTTPImageRetrievalWithAuth.class, (String)"HTTPImageRetrievalWithAuth.requestUsernamePassword().title"), true);
            requestDialog.setLayout(new GridLayout(0, 1));
            requestDialog.setPreferredSize(new Dimension(400, 200));
            JLabel usernameLabel = new JLabel(NbBundle.getMessage(HTTPImageRetrievalWithAuth.class, (String)"HTTPImageRetrievalWithAuth.requestUsernamePassword().usernameLabel.text"));
            requestDialog.add(usernameLabel);
            final JTextField usernameField = new JTextField();
            usernameField.setBackground(Color.lightGray);
            requestDialog.add(usernameField);
            JLabel passwordLabel = new JLabel(NbBundle.getMessage(HTTPImageRetrievalWithAuth.class, (String)"HTTPImageRetrievalWithAuth.requestUsernamePassword().passwordLabel.text"));
            requestDialog.add(passwordLabel);
            final JPasswordField passwordField = new JPasswordField();
            passwordField.setBackground(Color.lightGray);
            requestDialog.add(passwordField);
            JButton okButton = new JButton(NbBundle.getMessage(HTTPImageRetrievalWithAuth.class, (String)"HTTPImageRetrievalWithAuth.requestUsernamePassword().okButton.text"));
            requestDialog.add(okButton);
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsoleAuthPrompter.this.setUsernamePassword(new UsernamePasswordCredentials(usernameField.getText(), new String(passwordField.getPassword())));
                    requestDialog.dispose();
                }
            });
            JButton cancelButton = new JButton("Abbrechen");
            requestDialog.add(cancelButton);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    requestDialog.dispose();
                }
            });
            requestDialog.pack();
            StaticSwingTools.showDialog((JDialog)requestDialog);
        }
    }

    private class ImageObserverInterceptor
    extends JComponent {
        private ImageObserverInterceptor() {
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            boolean ret = super.imageUpdate(img, infoflags, x, y, width, height);
            if ((infoflags & 8) != 0) {
                RetrievalEvent e = new RetrievalEvent();
                e.setPercentageDone((int)((double)y / ((double)img.getHeight(this) - 1.0) * 100.0));
                HTTPImageRetrievalWithAuth.this.listener.retrievalProgress(e);
            } else if ((infoflags & 0x80) == 0 && (infoflags & 0x40) != 0) {
                RetrievalEvent e = new RetrievalEvent();
                e.setHasErrors(true);
                String error = new String(HTTPImageRetrievalWithAuth.this.byteArrayOut.toByteArray());
                e.setRetrievedObject(error);
                HTTPImageRetrievalWithAuth.this.listener.retrievalError(e);
            }
            return ret;
        }
    }
}

