/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice;

import com.vividsolutions.jts.geom.Envelope;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.ImageFileMetaData;
import de.cismet.cismap.commons.rasterservice.ImageFileUtils;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingBackend;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.deegree.io.geotiff.GeoTiffException;
import org.deegree.io.geotiff.GeoTiffReader;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ImageFileRetrieval
extends Thread {
    private static final Logger LOG = Logger.getLogger(ImageFileRetrieval.class);
    private int width;
    private int height;
    private double x1;
    private double x2;
    private double y1;
    private double y2;
    private File imageFile;
    private RetrievalListener listener = null;
    private volatile boolean youngerCall = false;
    private ImageFileMetaData metaData;
    private final ImageFileUtils.Mode mode;

    public ImageFileRetrieval(File imageFile, RetrievalListener listener, ImageFileUtils.Mode mode) {
        super("ImageFileRetrieval");
        this.imageFile = imageFile;
        this.listener = listener;
        this.mode = mode;
    }

    public void youngerCall() {
        this.youngerCall = true;
    }

    @Override
    public void run() {
        try {
            this.listener.retrievalStarted(new RetrievalEvent());
            if (this.metaData == null) {
                this.metaData = this.getImageMetaData();
            }
            if (this.metaData == null) {
                RetrievalEvent re = new RetrievalEvent();
                JOptionPane.showMessageDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(ImageFileRetrieval.class, (String)"ImageFileRetrieval.run().message"), NbBundle.getMessage(ImageFileRetrieval.class, (String)"ImageFileRetrieval.run().title"), 0);
                re.setIsComplete(false);
                re.setRetrievedObject(NbBundle.getMessage(ImageFileRetrieval.class, (String)"ImageFileRetrieval.run().message"));
                re.setErrorType("CLIENTERROR");
                this.listener.retrievalError(re);
                return;
            }
            if (this.youngerCall && this.isInterrupted()) {
                LOG.warn((Object)"Image retrieval aborted");
                return;
            }
            BufferedImage mapImage = this.createImage(this.metaData);
            RetrievalEvent re = new RetrievalEvent();
            re.setIsComplete(true);
            re.setRetrievedObject(mapImage);
            this.listener.retrievalComplete(re);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Image retrieval aborted");
        }
        catch (OutOfMemoryError ex) {
            LOG.error((Object)"Image retrieval aborted. Out o memory error.", (Throwable)ex);
            RetrievalEvent re = new RetrievalEvent();
            re.setIsComplete(false);
            re.setRetrievedObject(ex.getMessage());
            re.setErrorType("CLIENTERROR");
            this.listener.retrievalError(re);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error during image processing.", (Throwable)ex);
            RetrievalEvent re = new RetrievalEvent();
            re.setIsComplete(false);
            if (ex.getMessage() == null || ex.getMessage().equals("null")) {
                try {
                    String cause = ex.getCause().getMessage();
                    re.setRetrievedObject(cause);
                }
                catch (Exception exception) {}
            } else {
                re.setRetrievedObject(ex.getMessage());
                re.setErrorType("CLIENTERROR");
            }
            this.listener.retrievalError(re);
        }
    }

    private Rectangle getClippingRect(Rectangle2D.Double mapWorldBounds, Point2D.Double imageMapWorldOffset, Rectangle imageBounds, AffineTransform worldFileTransform) {
        int mapPartStartX = (int)Math.floor(-imageMapWorldOffset.getX() / worldFileTransform.getScaleX());
        int mapPartStartY = (int)Math.floor(-imageMapWorldOffset.getY() / -worldFileTransform.getScaleY());
        int mapPartWidth = (int)Math.ceil(mapWorldBounds.getWidth() / worldFileTransform.getScaleX()) + 1;
        int mapPartHeight = (int)Math.ceil(mapWorldBounds.getHeight() / -worldFileTransform.getScaleY()) + 1;
        if (mapPartStartX < 0) {
            mapPartStartX = 0;
            mapPartWidth += mapPartStartX;
        }
        if (mapPartStartY < 0) {
            mapPartStartY = 0;
            mapPartHeight += mapPartStartY;
        }
        if ((double)(mapPartStartX + mapPartWidth) > imageBounds.getWidth()) {
            mapPartWidth = (int)imageBounds.getWidth() - mapPartStartX;
        }
        if ((double)(mapPartStartY + mapPartHeight) > imageBounds.getHeight()) {
            mapPartHeight = (int)imageBounds.getHeight() - mapPartStartY;
        }
        return new Rectangle(mapPartStartX, mapPartStartY, mapPartWidth, mapPartHeight);
    }

    private BufferedImage createImage(ImageFileMetaData metaData) throws IOException, InterruptedException, NoninvertibleTransformException {
        BufferedImage clippedImage;
        Point2D.Double clippingWorldOffset;
        if (metaData.getTransform() == null) {
            Envelope en = metaData.getImageEnvelope();
            Rectangle rec = metaData.getImageBounds();
            return this.createImage(rec, en);
        }
        double[] matrix = metaData.getTransform().getMatrixEntries();
        AffineTransform worldFileTransform = new AffineTransform(matrix[0], matrix[3], matrix[1], matrix[4], matrix[2], matrix[5]);
        Rectangle mapBounds = new Rectangle(this.width, this.height);
        Rectangle imageBounds = metaData.getImageBounds();
        Rectangle2D.Double mapWorldBounds = new Rectangle2D.Double(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
        Envelope imageWorldBounds = metaData.getImageEnvelope();
        Point2D.Double imageMapWorldOffset = new Point2D.Double(imageWorldBounds.getMinX() - mapWorldBounds.getMinX(), mapWorldBounds.getMaxY() - imageWorldBounds.getMaxY());
        Rectangle2D.Double meterPerPixel = new Rectangle2D.Double(0.0, 0.0, mapWorldBounds.getWidth() / mapBounds.getWidth(), mapWorldBounds.getHeight() / mapBounds.getHeight());
        BufferedImage rawImage = ImageIO.read(this.imageFile);
        this.handleInterruption();
        if (worldFileTransform.getShearX() == 0.0 && worldFileTransform.getShearY() == 0.0) {
            Rectangle clippingRect = this.getClippingRect(mapWorldBounds, imageMapWorldOffset, imageBounds, worldFileTransform);
            clippingWorldOffset = new Point2D.Double(clippingRect.getX() * worldFileTransform.getScaleX(), -clippingRect.getY() * worldFileTransform.getScaleY());
            clippedImage = clippingRect.getWidth() >= 0.0 && clippingRect.getHeight() >= 0.0 ? rawImage.getSubimage((int)clippingRect.getX(), (int)clippingRect.getY(), (int)clippingRect.getWidth(), (int)clippingRect.getHeight()) : null;
        } else {
            clippingWorldOffset = new Point2D.Double(0.0, 0.0);
            clippedImage = rawImage;
        }
        rawImage = null;
        System.gc();
        this.handleInterruption();
        AffineTransform transformation = new AffineTransform(worldFileTransform.getScaleX() / meterPerPixel.getWidth(), -worldFileTransform.getShearY() / meterPerPixel.getHeight(), worldFileTransform.getShearX() / meterPerPixel.getWidth(), -worldFileTransform.getScaleY() / meterPerPixel.getHeight(), 0.0, 0.0);
        Rectangle shapeBounds = transformation.createTransformedShape(imageBounds).getBounds();
        AffineTransform transformation2 = new AffineTransform(transformation.getScaleX(), transformation.getShearY(), transformation.getShearX(), transformation.getScaleY(), (imageMapWorldOffset.getX() + clippingWorldOffset.getX()) / meterPerPixel.getWidth() - shapeBounds.getX(), (imageMapWorldOffset.getY() + clippingWorldOffset.getY()) / meterPerPixel.getHeight() - shapeBounds.getY());
        BufferedImage transformedImage = this.transform(transformation2, clippedImage);
        clippedImage = null;
        System.gc();
        return transformedImage;
    }

    private BufferedImage createImage(Rectangle origImageBounds, Envelope origImageCoords) throws IOException, InterruptedException {
        double meterPerPixelWidth = origImageCoords.getWidth() / origImageBounds.getWidth();
        double meterPerPixelHeight = origImageCoords.getHeight() / origImageBounds.getHeight();
        int mapPartStartX = (int)((this.x1 - origImageCoords.getMinX()) / meterPerPixelWidth);
        int mapPartStartY = (int)((origImageCoords.getMaxY() - this.y2) / meterPerPixelHeight);
        int mapPartWidth = (int)((this.x2 - this.x1) / meterPerPixelWidth);
        int mapPartHeight = (int)((this.y2 - this.y1) / meterPerPixelHeight);
        int imageWidth = this.width;
        int imageHeight = this.height;
        int borderLeft = 0;
        int borderTop = 0;
        int borderRight = 0;
        int borderBottom = 0;
        if (mapPartStartX < 0) {
            mapPartWidth -= Math.abs(mapPartStartX);
            borderLeft = (int)((double)Math.abs(mapPartStartX) * meterPerPixelWidth / ((this.x2 - this.x1) / (double)this.width));
            imageWidth -= borderLeft;
            mapPartStartX = 0;
        }
        if (mapPartStartY < 0) {
            mapPartHeight -= Math.abs(mapPartStartY);
            borderTop = (int)((double)Math.abs(mapPartStartY) * meterPerPixelHeight / ((this.y2 - this.y1) / (double)this.height));
            imageHeight -= borderTop;
            mapPartStartY = 0;
        }
        if ((double)(mapPartStartX + mapPartWidth) > origImageBounds.getWidth()) {
            borderRight = (int)(((double)(mapPartStartX + mapPartWidth) - origImageBounds.getWidth()) * meterPerPixelWidth / ((this.x2 - this.x1) / (double)this.width));
            mapPartWidth = (int)origImageBounds.getWidth() - mapPartStartX;
            imageWidth -= borderRight;
        }
        if ((double)(mapPartStartY + mapPartHeight) > origImageBounds.getHeight()) {
            borderBottom = (int)(((double)(mapPartStartY + mapPartHeight) - origImageBounds.getHeight()) * meterPerPixelHeight / ((this.y2 - this.y1) / (double)this.height));
            mapPartHeight = (int)origImageBounds.getHeight() - mapPartStartY;
            imageHeight -= borderBottom;
        }
        BufferedImage imagePart = null;
        if (mapPartWidth > 0 && mapPartHeight > 0) {
            BufferedImage i = ImageIO.read(this.imageFile);
            imagePart = i.getSubimage(mapPartStartX, mapPartStartY, mapPartWidth, mapPartHeight);
            i = null;
            System.gc();
        }
        if (this.youngerCall && this.isInterrupted()) {
            throw new InterruptedException();
        }
        BufferedImage rescaledImage = this.rescale(imageWidth, imageHeight, borderLeft, borderRight, borderTop, borderBottom, 2, imagePart);
        imagePart = null;
        System.gc();
        return rescaledImage;
    }

    private BufferedImage rescale(int width, int height, int borderLeft, int borderRight, int borderTop, int borderBottom, int type, BufferedImage image) {
        int totalWdth = width + borderLeft + borderRight;
        int totalHeight = height + borderTop + borderBottom;
        BufferedImage resized = new BufferedImage(totalWdth, totalHeight, type);
        if (image != null) {
            Graphics2D g = resized.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(image, borderLeft, borderTop, width + borderLeft, height + borderTop, 0, 0, image.getWidth(), image.getHeight(), null);
            g.dispose();
        }
        return resized;
    }

    private void handleInterruption() throws InterruptedException {
        if (this.youngerCall && this.isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private BufferedImage transform(AffineTransform transform, BufferedImage image) {
        BufferedImage transformedImage = new BufferedImage(this.width, this.height, 2);
        if (image != null) {
            Graphics2D g = transformedImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(image, transform, null);
        }
        return transformedImage;
    }

    private ImageFileMetaData getImageMetaData() throws Exception {
        if (this.mode != null) {
            switch (this.mode) {
                case WORLDFILE: {
                    return ImageFileUtils.getWorldFileMetaData(this.getImageFile(), this.getWorldFile());
                }
                case TIFF: {
                    return this.getTiffMetaData();
                }
                case GEO_REFERENCED: {
                    return this.getGeoReferencedMetaData();
                }
            }
        }
        return null;
    }

    private ImageFileMetaData getGeoReferencedMetaData() throws Exception {
        return RasterGeoReferencingBackend.getInstance().getHandler(this.imageFile).getMetaData();
    }

    private ImageFileMetaData getTiffMetaData() throws Exception {
        return ImageFileUtils.getTiffMetaData(this.imageFile);
    }

    private File getWorldFile() {
        return ImageFileUtils.getWorldFile(this.imageFile);
    }

    public Envelope getEnvelope() {
        block4: {
            try {
                if (this.metaData == null) {
                    ImageFileMetaData metaData = this.getImageMetaData();
                    if (metaData != null) {
                        return metaData.getImageEnvelope();
                    }
                    break block4;
                }
                return this.metaData.getImageEnvelope();
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot determine the envelope of the image.", (Throwable)e);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            GeoTiffReader r = new GeoTiffReader(new File("/home/therter/share/daten/uek250.tif"));
            System.out.println(r.getHumanReadableCoordinateSystem());
            r.getTIFFImage().getBounds();
            r.getTIFFImage().getHeight();
            r.getTIFFImage().getMinTileX();
            r.getTIFFImage().getNumXTiles();
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (GeoTiffException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + this.width;
        hash = 59 * hash + this.height;
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.x1) ^ Double.doubleToLongBits(this.x1) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.x2) ^ Double.doubleToLongBits(this.x2) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.y1) ^ Double.doubleToLongBits(this.y1) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.y2) ^ Double.doubleToLongBits(this.y2) >>> 32);
        hash = 59 * hash + (this.imageFile != null ? this.imageFile.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageFileRetrieval other = (ImageFileRetrieval)obj;
        if (this.width != other.width) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (Double.doubleToLongBits(this.x1) != Double.doubleToLongBits(other.x1)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x2) != Double.doubleToLongBits(other.x2)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y1) != Double.doubleToLongBits(other.y1)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y2) != Double.doubleToLongBits(other.y2)) {
            return false;
        }
        return this.imageFile == other.imageFile || this.imageFile != null && this.imageFile.equals(other.imageFile);
    }

    public void copyMetaData(ImageFileRetrieval other) {
        this.metaData = other.metaData;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getX1() {
        return this.x1;
    }

    public void setX1(double x1) {
        this.x1 = x1;
    }

    public double getX2() {
        return this.x2;
    }

    public void setX2(double x2) {
        this.x2 = x2;
    }

    public double getY1() {
        return this.y1;
    }

    public void setY1(double y1) {
        this.y1 = y1;
    }

    public double getY2() {
        return this.y2;
    }

    public void setY2(double y2) {
        this.y2 = y2;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(File imageFile) {
        this.imageFile = imageFile;
    }
}

