/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.ImageFileMetaData;
import de.cismet.cismap.commons.rasterservice.georeferencing.PointCoordinatePair;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImage;
import org.apache.log4j.Logger;
import org.deegree.io.geotiff.GeoTiffReader;

public class ImageFileUtils {
    private static final Logger LOG = Logger.getLogger(ImageFileUtils.class);
    private static final Map<String, String> WORLD_FILE_ENDINGS = new HashMap<String, String>();
    public static final String[] SUPPORTED_IMAGE_FORMATS;

    public static File getWorldFile(File imageFile) {
        File worldFile = ImageFileUtils.getWorldFileWithoutCheck(imageFile);
        if (worldFile != null && worldFile.exists()) {
            return worldFile;
        }
        return null;
    }

    public static File getWorldFileWithoutCheck(File imageFile) {
        String name = imageFile.getAbsolutePath();
        String ending = name.substring(name.lastIndexOf(".") + 1).toLowerCase();
        String wfEnding = WORLD_FILE_ENDINGS.get(ending);
        if (wfEnding != null) {
            String worldFileName = name.substring(0, name.lastIndexOf(".") + 1) + wfEnding;
            File worldFile = new File(worldFileName);
            return worldFile;
        }
        return null;
    }

    public static ImageFileMetaData getTiffMetaData(File imageFile) throws Exception {
        GeoTiffReader r = new GeoTiffReader(imageFile);
        org.deegree.model.spatialschema.Envelope e = r.getBoundingBox();
        Envelope en = new Envelope(e.getMin().getX(), e.getMax().getX(), e.getMin().getY(), e.getMax().getY());
        TIFFImage tiffImage = r.getTIFFImage();
        Rectangle rec = tiffImage.getBounds();
        r = null;
        System.gc();
        return new ImageFileMetaData(rec, en, null, null);
    }

    public static boolean isImageFileEnding(String fileName) {
        for (String ending : SUPPORTED_IMAGE_FORMATS) {
            if (!fileName.toLowerCase().endsWith(ending)) continue;
            return true;
        }
        return false;
    }

    public static Mode determineMode(File imageFile) {
        ImageFileMetaData md = null;
        File worldFile = ImageFileUtils.getWorldFile(imageFile);
        if (worldFile != null && (md = ImageFileUtils.getWorldFileMetaData(imageFile, worldFile)) != null) {
            return md.isRasterGeoRef() ? Mode.GEO_REFERENCED : Mode.WORLDFILE;
        }
        if (imageFile.getName().toLowerCase().endsWith("tif")) {
            try {
                return Mode.TIFF;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return md != null ? Mode.TIFF : Mode.GEO_REFERENCED;
    }

    public static boolean checkIfRasterGeoRef(File worldFile) {
        if (worldFile != null) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(worldFile));
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("#cidsgeoref;")) continue;
                    return true;
                }
                br.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot parse the world file", (Throwable)e);
            }
        }
        return false;
    }

    public static ImageFileMetaData getWorldFileMetaData(File imageFile, File worldFile) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(worldFile));
            double[] matrix = new double[6];
            ArrayList<PointCoordinatePair> pairs = new ArrayList<PointCoordinatePair>();
            boolean isRasterGeoReof = false;
            int index = 0;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#cidsgeoref;")) {
                    isRasterGeoReof = true;
                    continue;
                }
                if (isRasterGeoReof) {
                    String[] parts;
                    if (!line.startsWith("#") || (parts = line.substring(1).split(";|,")).length != 4) continue;
                    Point point = new Point(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
                    Coordinate coordinate = new Coordinate(Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
                    pairs.add(new PointCoordinatePair(point, coordinate));
                    continue;
                }
                if (line.trim().isEmpty() || line.startsWith("#")) continue;
                if (line.contains(",")) {
                    line = line.replaceAll(",", ".");
                }
                matrix[index++] = Double.parseDouble(line);
            }
            br.close();
            if (index == matrix.length) {
                AffineTransformation transform = new AffineTransformation(matrix[0], matrix[2], matrix[4], matrix[1], matrix[3], matrix[5]);
                Dimension imageDimension = ImageFileUtils.getImageDimension(imageFile);
                double imageWidth = imageDimension.getWidth();
                double imageHeight = imageDimension.getHeight();
                Rectangle imageBounds = new Rectangle(0, 0, (int)imageWidth, (int)imageHeight);
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
                LinearRing linear = factory.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(imageWidth, 0.0), new Coordinate(imageWidth, imageHeight), new Coordinate(0.0, imageHeight), new Coordinate(0.0, 0.0)});
                Envelope imageEnvelope = transform.transform((Geometry)factory.createPolygon(linear, null)).getEnvelopeInternal();
                ImageFileMetaData metaData = new ImageFileMetaData(imageBounds, imageEnvelope, transform, isRasterGeoReof ? pairs.toArray(new PointCoordinatePair[0]) : null);
                return metaData;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot parse the world file", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageDimension(File imgFile) throws IOException {
        int pos = imgFile.getName().lastIndexOf(".");
        if (pos == -1) {
            throw new IOException("The file " + imgFile.getAbsolutePath() + " has not extension, so no reader can be found.");
        }
        String fileSuffix = imgFile.getName().substring(pos + 1);
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(fileSuffix);
        if (iter.hasNext()) {
            ImageReader reader = iter.next();
            try {
                FileImageInputStream stream = new FileImageInputStream(imgFile);
                reader.setInput(stream);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Dimension dimension = new Dimension(width, height);
                return dimension;
            }
            catch (IOException e) {
                LOG.warn((Object)("Error reading: " + imgFile.getAbsolutePath()), (Throwable)e);
            }
            finally {
                reader.dispose();
            }
        }
        throw new IOException("No suitable reader found for file format: " + fileSuffix);
    }

    static {
        WORLD_FILE_ENDINGS.put("jpg", "jgw");
        WORLD_FILE_ENDINGS.put("jpeg", "jgw");
        WORLD_FILE_ENDINGS.put("png", "pgw");
        WORLD_FILE_ENDINGS.put("gif", "gfw");
        WORLD_FILE_ENDINGS.put("tif", "tfw");
        WORLD_FILE_ENDINGS.put("tiff", "tfw");
        SUPPORTED_IMAGE_FORMATS = new String[]{"png", "jpg", "jpeg", "tif", "tiff", "gif"};
    }

    public static enum Mode {
        WORLDFILE,
        TIFF,
        GEO_REFERENCED;

    }
}

