/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice;

import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import de.cismet.security.WebAccessManager;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;

public class ImageRetrieval
extends Thread {
    BufferedInputStream in = null;
    private final Logger log = Logger.getLogger(this.getClass());
    private String url;
    private RetrievalListener listener = null;
    private WMSCapabilities cap;
    private HttpClient preferredHttpClient;
    private volatile boolean youngerCall = false;
    private String payload;

    public ImageRetrieval(RetrievalListener listener) {
        super("ImageRetrieval");
        this.listener = listener;
    }

    public void youngerWMSCall() {
        this.youngerCall = true;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"interrupt()", (Throwable)new Exception("interrupt"));
        }
        if (this.in != null && this.log.isDebugEnabled()) {
            this.log.info((Object)"in!=null");
            try {
                this.in.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AccessHandler.ACCESS_METHODS method;
            String requestParameter;
            String urlBase;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("start of ImageRetrieval: " + this.url));
            }
            this.listener.retrievalStarted(new RetrievalEvent());
            if (this.cap != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Retrieve: " + this.url.toString() + " WMSCapability: " + this.cap.getLayer().getTitle()));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieve: " + this.url.toString()));
            }
            if (this.payload == null) {
                int indexOfCharacter = 0;
                indexOfCharacter = this.url.indexOf(63);
                if (indexOfCharacter != -1) {
                    urlBase = this.url.substring(0, indexOfCharacter);
                    requestParameter = indexOfCharacter + 1 < this.url.length() ? this.url.substring(indexOfCharacter + 1, this.url.length()) : "";
                } else {
                    urlBase = this.url;
                    requestParameter = "";
                }
                method = AccessHandler.ACCESS_METHODS.GET_REQUEST;
            } else {
                urlBase = this.url;
                requestParameter = this.payload;
                method = AccessHandler.ACCESS_METHODS.POST_REQUEST;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("POST payload: " + this.payload));
                }
            }
            InputStream is = WebAccessManager.getInstance().doRequest(new URL(urlBase), requestParameter, method);
            byte[] bs = IOUtils.toByteArray((InputStream)is);
            this.in = new BufferedInputStream(new ByteArrayInputStream(bs));
            RetrievalEvent e = new RetrievalEvent();
            if (!this.youngerCall && !this.isInterrupted()) {
                e.setRetrievedObject(ImageIO.read(this.in));
                if (e.getRetrievedObject() == null) {
                    e.setRetrievedObject(IOUtils.toString((InputStream)new ByteArrayInputStream(bs)));
                    e.setHasErrors(true);
                }
            }
            e.setIsComplete(true);
            if (!this.youngerCall && !this.isInterrupted()) {
                this.listener.retrievalComplete(e);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Retrieval complete of " + e.getRetrievalService()));
                }
            } else if (!this.youngerCall) {
                this.fireLoadingAborted();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error in ImageRetrieval", (Throwable)e);
            RetrievalEvent re = new RetrievalEvent();
            re.setIsComplete(false);
            if (e.getMessage() == null || e.getMessage().equals("null")) {
                try {
                    String cause = e.getCause().getMessage();
                    re.setRetrievedObject(cause);
                }
                catch (Exception exception) {}
            } else {
                re.setRetrievedObject(e.getMessage());
                re.setErrorType("CLIENTERROR");
            }
            this.listener.retrievalError(re);
            this.log.error((Object)"Error while loading the image", (Throwable)e);
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ex) {
                    this.log.warn((Object)ex, (Throwable)ex);
                }
            }
        }
    }

    public void fireLoadingAborted() {
        this.log.info((Object)"Retrieval interrupted");
        if (this.listener != null) {
            RetrievalEvent e = new RetrievalEvent();
            e.setIsComplete(false);
            this.listener.retrievalAborted(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setWMSCapabilities(WMSCapabilities cap) {
        this.cap = cap;
    }

    public HttpClient getPreferredHttpClient() {
        return this.preferredHttpClient;
    }

    public void setPreferredHttpClient(HttpClient preferredHttpClient) {
        this.preferredHttpClient = preferredHttpClient;
    }
}

