/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice.georeferencing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.geom.util.AffineTransformationBuilder;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RasterGeoRefFeature;
import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.rasterservice.ImageFileMetaData;
import de.cismet.cismap.commons.rasterservice.ImageFileUtils;
import de.cismet.cismap.commons.rasterservice.ImageRasterService;
import de.cismet.cismap.commons.rasterservice.georeferencing.PointCoordinatePair;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingHandler;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingHandlerListener;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingWizard;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RasterGeoReferencingBackend {
    private static final Logger LOG = Logger.getLogger(RasterGeoReferencingBackend.class);
    private final Map<File, RasterGeoReferencingHandler> metaDataMap = new HashMap<File, RasterGeoReferencingHandler>();
    private final ActiveLayerListenerHandler activeLayerListenerHandler = new ActiveLayerListenerHandler();

    private RasterGeoReferencingBackend() {
    }

    public static RasterGeoReferencingBackend getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public static MappingComponent getMainMap() {
        return CismapBroker.getInstance().getMappingComponent();
    }

    public RasterGeoReferencingHandler getHandler(File imageFile) {
        return this.getMetaDataMap().get(imageFile);
    }

    private static RasterGeoReferencingHandler createInitHandler(ImageRasterService service, File imageFile) throws Exception {
        Dimension imageDimension = ImageFileUtils.getImageDimension(imageFile);
        Rectangle imageBounds = new Rectangle(0, 0, (int)imageDimension.getWidth(), (int)imageDimension.getHeight());
        BoundingBox bb = RasterGeoReferencingBackend.getMainMap().getCurrentBoundingBoxFromCamera();
        double scale = bb.getWidth() / bb.getHeight() > imageBounds.getWidth() / imageBounds.getHeight() ? bb.getHeight() / imageBounds.getHeight() : bb.getWidth() / imageBounds.getWidth();
        Coordinate mapCenterCoordinate = new Coordinate(bb.getX1() + (bb.getX2() - bb.getX1()) / 2.0, bb.getY2() + (bb.getY1() - bb.getY2()) / 2.0);
        Envelope imageEnvelope = new Envelope(mapCenterCoordinate.x - imageBounds.getWidth() * scale / 2.0, mapCenterCoordinate.x + imageBounds.getWidth() * scale / 2.0, mapCenterCoordinate.y + imageBounds.getHeight() * scale / 2.0, mapCenterCoordinate.y - imageBounds.getHeight() * scale / 2.0);
        PointCoordinatePair[] pairs = new PointCoordinatePair[]{new PointCoordinatePair(new Point(0, 0), new Coordinate(imageEnvelope.getMinX(), imageEnvelope.getMaxY())), new PointCoordinatePair(new Point((int)imageBounds.getWidth(), 0), new Coordinate(imageEnvelope.getMaxX(), imageEnvelope.getMaxY())), new PointCoordinatePair(new Point((int)imageBounds.getWidth() / 2, (int)imageBounds.getHeight()), new Coordinate(imageEnvelope.getMaxX() - imageEnvelope.getWidth() / 2.0, imageEnvelope.getMinY()))};
        AffineTransformation transform = RasterGeoReferencingBackend.calculateAvgTransformation(pairs);
        ImageFileMetaData metaData = new ImageFileMetaData(imageBounds, imageEnvelope, transform, pairs);
        return new RasterGeoReferencingHandler(service, metaData);
    }

    public void save(RasterGeoReferencingHandler handler) throws Exception {
        File imageFile = handler.getService().getImageFile();
        File worldFile = ImageFileUtils.getWorldFileWithoutCheck(imageFile);
        PrintWriter pw = new PrintWriter(worldFile);
        AffineTransformation at = handler.getMetaData().getTransform();
        double[] matrix = at.getMatrixEntries();
        pw.append(Double.toString(matrix[0])).append("\n");
        pw.append(Double.toString(matrix[3])).append("\n");
        pw.append(Double.toString(matrix[1])).append("\n");
        pw.append(Double.toString(matrix[4])).append("\n");
        pw.append(Double.toString(matrix[2])).append("\n");
        pw.append(Double.toString(matrix[5])).append("\n");
        pw.append("#cidsgeoref;").append(Integer.toString(handler.getCompletePairs().length)).append(";").append(RasterGeoReferencingBackend.getMainMap().getMappingModel().getSrs().getShortname()).append("\n");
        for (PointCoordinatePair pair : handler.getCompletePairs()) {
            Point point = pair.getPoint();
            Coordinate coordinate = pair.getCoordinate();
            pw.append("#").append(Integer.toString((int)point.getX())).append(",").append(Integer.toString((int)point.getY())).append(";").append(Double.toString(coordinate.x)).append(",").append(Double.toString(coordinate.y)).append("\n");
        }
        pw.close();
    }

    public static RasterGeoReferencingWizard getWizard() {
        return RasterGeoReferencingWizard.getInstance();
    }

    public static AffineTransformation calculateAvgTransformation(PointCoordinatePair[] completePairs) {
        ArrayList<AffineTransformation> transforms = new ArrayList<AffineTransformation>();
        if (completePairs.length >= 3) {
            for (Object[] arr : RasterGeoReferencingHandler.getCombinations(completePairs, 3)) {
                PointCoordinatePair pair0 = (PointCoordinatePair)arr[0];
                PointCoordinatePair pair1 = (PointCoordinatePair)arr[1];
                PointCoordinatePair pair2 = (PointCoordinatePair)arr[2];
                AffineTransformationBuilder builder = new AffineTransformationBuilder(new Coordinate(pair0.getPoint().getX(), pair0.getPoint().getY()), new Coordinate(pair1.getPoint().getX(), pair1.getPoint().getY()), new Coordinate(pair2.getPoint().getX(), pair2.getPoint().getY()), pair0.getCoordinate(), pair1.getCoordinate(), pair2.getCoordinate());
                AffineTransformation transform = builder.getTransformation();
                if (transform == null) continue;
                transforms.add(transform);
            }
            AffineTransformation avgTransform = RasterGeoReferencingHandler.createAverageTransformation(transforms);
            return avgTransform;
        }
        return null;
    }

    public Map<File, RasterGeoReferencingHandler> getMetaDataMap() {
        return this.metaDataMap;
    }

    public ActiveLayerListenerHandler getActiveLayerListenerHandler() {
        return this.activeLayerListenerHandler;
    }

    private static final class LazyInitialiser {
        private static final RasterGeoReferencingBackend INSTANCE = new RasterGeoReferencingBackend();

        private LazyInitialiser() {
        }
    }

    private class ActiveLayerListenerHandler
    implements ActiveLayerListener {
        private ActiveLayerListenerHandler() {
        }

        @Override
        public void layerAdded(ActiveLayerEvent e) {
            block11: {
                Object layer = e.getLayer();
                if (!RasterGeoReferencingWizard.getInstance().getIgnoreLayerList().contains(layer)) {
                    try {
                        ImageRasterService irs;
                        if (!(layer instanceof ImageRasterService) || ImageFileUtils.Mode.GEO_REFERENCED != (irs = (ImageRasterService)layer).getMode()) break block11;
                        final File imagefile = irs.getImageFile();
                        if (!RasterGeoReferencingBackend.this.getMetaDataMap().containsKey(imagefile)) {
                            try {
                                RasterGeoReferencingHandler handler;
                                File worldFile = ImageFileUtils.getWorldFile(imagefile);
                                if (worldFile == null) {
                                    handler = RasterGeoReferencingBackend.createInitHandler(irs, imagefile);
                                } else {
                                    ImageFileMetaData metaData = ImageFileUtils.getWorldFileMetaData(imagefile, worldFile);
                                    handler = new RasterGeoReferencingHandler(irs, metaData);
                                    for (PointCoordinatePair pair : metaData.getPairs()) {
                                        handler.addPair(pair);
                                    }
                                }
                                RasterGeoReferencingBackend.this.getMetaDataMap().put(imagefile, handler);
                                handler.addListener(new RasterGeoReferencingHandlerListener(){

                                    @Override
                                    public void transformationChanged() {
                                        if (handler.isComplete() && imagefile.equals(irs.getImageFile())) {
                                            irs.retrieve(true);
                                        }
                                    }

                                    @Override
                                    public void positionAdded(int position) {
                                    }

                                    @Override
                                    public void positionRemoved(int position) {
                                    }

                                    @Override
                                    public void positionChanged(int position) {
                                    }
                                });
                                RasterGeoRefFeature feature = handler.getFeature();
                                FeatureCollection featureCollection = RasterGeoReferencingBackend.getMainMap().getFeatureCollection();
                                if (feature != null && featureCollection != null && !featureCollection.contains(feature)) {
                                    featureCollection.addFeature(feature);
                                }
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)ex, (Throwable)ex);
                            }
                        }
                        if (RasterGeoReferencingBackend.this.getMetaDataMap().size() == 1) {
                            RasterGeoReferencingBackend.getWizard().setHandler(RasterGeoReferencingBackend.this.getMetaDataMap().get(imagefile));
                        }
                    }
                    catch (Throwable t) {
                        LOG.fatal((Object)t, t);
                    }
                }
            }
        }

        @Override
        public void layerRemoved(ActiveLayerEvent e) {
            ImageRasterService irs;
            Object layer = e.getLayer();
            if (!RasterGeoReferencingWizard.getInstance().getIgnoreLayerList().contains(layer) && layer instanceof ImageRasterService && ImageFileUtils.Mode.GEO_REFERENCED == (irs = (ImageRasterService)layer).getMode()) {
                File imageFile = irs.getImageFile();
                if (RasterGeoReferencingBackend.this.getMetaDataMap().containsKey(imageFile)) {
                    RasterGeoRefFeature feature = RasterGeoReferencingBackend.this.getHandler(imageFile).getFeature();
                    RasterGeoReferencingBackend.getWizard().setHandler(null);
                    FeatureCollection featureCollection = RasterGeoReferencingBackend.getMainMap().getFeatureCollection();
                    if (feature != null && featureCollection != null && featureCollection.contains(feature)) {
                        featureCollection.removeFeature(feature);
                        RasterGeoReferencingBackend.getWizard().removeListener(feature);
                    }
                    RasterGeoReferencingBackend.this.getMetaDataMap().remove(imageFile);
                }
            }
        }

        @Override
        public void layerPositionChanged(ActiveLayerEvent e) {
        }

        @Override
        public void layerVisibilityChanged(ActiveLayerEvent e) {
        }

        @Override
        public void layerAvailabilityChanged(ActiveLayerEvent e) {
        }

        @Override
        public void layerInformationStatusChanged(ActiveLayerEvent e) {
        }

        @Override
        public void layerSelectionChanged(ActiveLayerEvent e) {
            RasterGeoReferencingHandler handler = null;
            Object layer = e.getLayer();
            if (!RasterGeoReferencingWizard.getInstance().getIgnoreLayerList().contains(layer)) {
                ImageRasterService irs;
                if (layer instanceof ImageRasterService && ImageFileUtils.Mode.GEO_REFERENCED == (irs = (ImageRasterService)layer).getMode()) {
                    File imagefile = irs.getImageFile();
                    if (RasterGeoReferencingBackend.this.getMetaDataMap().containsKey(imagefile)) {
                        handler = RasterGeoReferencingBackend.this.getMetaDataMap().get(imagefile);
                    }
                }
                RasterGeoReferencingBackend.getWizard().setHandler(handler);
            }
        }
    }
}

