/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice.georeferencing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RasterGeoRefFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.ImageFileMetaData;
import de.cismet.cismap.commons.rasterservice.ImageRasterService;
import de.cismet.cismap.commons.rasterservice.georeferencing.PointCoordinatePair;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingBackend;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingHandlerListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RasterGeoReferencingHandler {
    private final List<PointCoordinatePair> pairs = new ArrayList<PointCoordinatePair>();
    private final ListenerHandler listenerHandler = new ListenerHandler();
    private final Map<Integer, Boolean> positionStates = new HashMap<Integer, Boolean>();
    private final ImageFileMetaData metaData;
    private final RasterGeoRefFeature feature;
    private final ImageRasterService service;
    private final AffineTransformation initialTransform;

    public RasterGeoReferencingHandler(ImageRasterService service, ImageFileMetaData metaData) {
        this.service = service;
        this.metaData = metaData;
        this.feature = new RasterGeoRefFeature(this);
        this.initialTransform = metaData.getTransform();
    }

    public boolean isPositionEnabled(int position) throws ArrayIndexOutOfBoundsException {
        this.chec\u1e31Position(position);
        return Boolean.TRUE.equals(this.getPositionStates().get(position));
    }

    public void setPositionEnabled(int position, boolean enabled) throws ArrayIndexOutOfBoundsException {
        boolean changed;
        this.chec\u1e31Position(position);
        boolean bl = changed = !new Boolean(enabled).equals(this.getPositionStates().get(position));
        if (changed) {
            this.getPositionStates().put(position, enabled);
            this.updateTransformation();
            this.getListenerHandler().positionChanged(position);
        }
    }

    public boolean isComplete() {
        return this.getCompletePairs().length >= 3;
    }

    public boolean addListener(RasterGeoReferencingHandlerListener listener) {
        return this.getListenerHandler().add(listener);
    }

    public boolean removeListener(RasterGeoReferencingHandlerListener listener) {
        return this.getListenerHandler().remove(listener);
    }

    public int addPair() {
        return this.addPair(null, null);
    }

    public int addPair(Point point) {
        return this.addPair(point, null);
    }

    public int addPair(Coordinate coordinate) {
        return this.addPair(null, coordinate);
    }

    public int addPair(Point point, Coordinate coordinate) {
        PointCoordinatePair pair = new PointCoordinatePair(point, coordinate);
        return this.addPair(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPair(PointCoordinatePair pair) throws IllegalArgumentException {
        int position;
        if (pair == null) {
            throw new IllegalArgumentException("the given pair is null");
        }
        List<PointCoordinatePair> list = this.pairs;
        synchronized (list) {
            position = this.pairs.size();
            this.pairs.add(position, (PointCoordinatePair)pair.clone());
            this.getPositionStates().put(position, pair.getPoint() != null && pair.getCoordinate() != null);
        }
        this.getListenerHandler().positionAdded(position);
        this.updateTransformation();
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPair(PointCoordinatePair pair, int position) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (pair == null) {
            throw new IllegalArgumentException("the given pair is null");
        }
        List<PointCoordinatePair> list = this.pairs;
        synchronized (list) {
            this.chec\u1e31Position(position);
            this.pairs.set(position, (PointCoordinatePair)pair.clone());
            this.getListenerHandler().positionChanged(position);
            this.updateTransformation();
        }
    }

    public void removeAllPairs() {
        while (this.getNumOfPairs() > 0) {
            this.removePair(this.getNumOfPairs() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePair(int position) throws IndexOutOfBoundsException {
        List<PointCoordinatePair> list = this.pairs;
        synchronized (list) {
            boolean success;
            this.chec\u1e31Position(position);
            boolean bl = success = this.pairs.remove(position) != null;
            if (success) {
                this.getPositionStates().remove(position);
                this.getListenerHandler().positionRemoved(position);
                this.updateTransformation();
            }
            return success;
        }
    }

    public int getNumOfPairs() {
        return this.pairs.size();
    }

    public PointCoordinatePair[] getCompletePairs() {
        List<PointCoordinatePair> pairs = Arrays.asList(this.getPairs(Boolean.TRUE));
        ArrayList<PointCoordinatePair> completePairs = new ArrayList<PointCoordinatePair>(pairs.size());
        for (int position = 0; position < pairs.size(); ++position) {
            PointCoordinatePair pair = pairs.get(position);
            if (pair == null || pair.getPoint() == null || pair.getCoordinate() == null) continue;
            completePairs.add(pair);
        }
        return completePairs.toArray(new PointCoordinatePair[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointCoordinatePair getPair(int position) throws IndexOutOfBoundsException {
        List<PointCoordinatePair> list = this.pairs;
        synchronized (list) {
            this.chec\u1e31Position(position);
            return this.pairs.get(position);
        }
    }

    public Point getPoint(int position) throws IndexOutOfBoundsException {
        return this.getPair(position).getPoint();
    }

    public Coordinate getPointCoordinate(int position) throws IndexOutOfBoundsException {
        Point point = this.getPoint(position);
        if (point != null) {
            AffineTransformation transform = this.getMetaData().getTransform();
            if (transform != null) {
                return transform.transform(new Coordinate(point.getX(), point.getY()), new Coordinate());
            }
            return null;
        }
        return null;
    }

    public boolean setPoint(int position, Point point) throws IndexOutOfBoundsException {
        if (position == this.pairs.size()) {
            return this.addPair(point) >= 0;
        }
        PointCoordinatePair pair = this.getPair(position);
        if (pair != null) {
            pair.setPoint(point);
            this.getListenerHandler().positionChanged(position);
            return true;
        }
        return false;
    }

    public Coordinate getCoordinate(int position) throws IndexOutOfBoundsException {
        return this.getPair(position).getCoordinate();
    }

    public boolean setCoordinate(int position, Coordinate coordinate) throws IndexOutOfBoundsException {
        if (position == this.pairs.size()) {
            return this.addPair(coordinate) >= 0;
        }
        PointCoordinatePair pair = this.getPair(position);
        if (pair != null) {
            pair.setCoordinate(coordinate);
            this.getListenerHandler().positionChanged(position);
            this.updateTransformation();
            return true;
        }
        return false;
    }

    public void chec\u1e31Position(int position) throws IndexOutOfBoundsException {
        if (position < 0 || position >= this.pairs.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public PointCoordinatePair[] getPairs() {
        return this.getPairs(null);
    }

    public PointCoordinatePair[] getPairs(Boolean enabled) {
        ArrayList<PointCoordinatePair> pairs = new ArrayList<PointCoordinatePair>(this.pairs);
        PointCoordinatePair[] array = new PointCoordinatePair[pairs.size()];
        for (int position = 0; position < pairs.size(); ++position) {
            boolean include;
            boolean bl = include = enabled == null || enabled.equals(this.getPositionStates().get(position));
            if (!include) continue;
            PointCoordinatePair pair = (PointCoordinatePair)pairs.get(position);
            Point point = pair.getPoint();
            Coordinate coordinate = pair.getCoordinate();
            array[position] = new PointCoordinatePair(point, coordinate);
        }
        return array;
    }

    public void updateTransformation() {
        AffineTransformation transform;
        AffineTransformation oldTransformation = this.getMetaData().getTransform();
        Polygon imageBoundsGeometry = this.createPolygon(this.getMetaData().getImageBounds());
        AffineTransformation avgTransform = RasterGeoReferencingBackend.calculateAvgTransformation(this.getCompletePairs());
        AffineTransformation affineTransformation = transform = avgTransform != null ? avgTransform : this.getInitialTransform();
        if (!transform.equals((Object)oldTransformation)) {
            Envelope imageEnvelope = transform.transform((Geometry)imageBoundsGeometry).getEnvelopeInternal();
            this.getMetaData().setTransform(transform);
            this.getMetaData().setImageEnvelope(imageEnvelope);
            this.getListenerHandler().transformationChanged();
        }
    }

    private Polygon createPolygon(Rectangle bounds) {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
        LinearRing linear = factory.createLinearRing(new Coordinate[]{new Coordinate(bounds.getMinX(), bounds.getMinY()), new Coordinate(bounds.getMaxX(), bounds.getMinY()), new Coordinate(bounds.getMaxX(), bounds.getMaxY()), new Coordinate(bounds.getMinX(), bounds.getMaxY()), new Coordinate(bounds.getMinX(), bounds.getMinY())});
        return factory.createPolygon(linear);
    }

    public static AffineTransformation createAverageTransformation(List<AffineTransformation> transforms) {
        double[] avg = new double[6];
        for (AffineTransformation transform : transforms) {
            double[] matrix = transform.getMatrixEntries();
            for (int i = 0; i < avg.length; ++i) {
                int n = i;
                avg[n] = avg[n] + matrix[i] / (double)transforms.size();
            }
        }
        return new AffineTransformation(avg);
    }

    public double getError(int position) {
        PointCoordinatePair pair = this.pairs.get(position);
        if (this.getMetaData().getTransform() != null && pair != null && pair.getPoint() != null && pair.getCoordinate() != null) {
            Coordinate point = new Coordinate(pair.getPoint().getX(), pair.getPoint().getY());
            Coordinate transformedPoint = this.getMetaData().getTransform().transform(point, new Coordinate());
            return transformedPoint.distance(pair.getCoordinate());
        }
        return 0.0;
    }

    public static List<Object[]> getCombinations(Object[] input, int setSize) {
        ArrayList<Object[]> subsets = new ArrayList<Object[]>();
        int[] indices = new int[setSize];
        if (setSize <= input.length) {
            int index;
            for (index = 0; index < setSize; ++index) {
                indices[index] = index;
            }
            subsets.add(RasterGeoReferencingHandler.getSubset(input, indices));
            do {
                for (index = setSize - 1; index >= 0 && indices[index] == input.length - setSize + index; --index) {
                }
                if (index < 0) continue;
                int n = index++;
                indices[n] = indices[n] + 1;
                while (index < setSize) {
                    indices[index] = indices[index - 1] + 1;
                    ++index;
                }
                subsets.add(RasterGeoReferencingHandler.getSubset(input, indices));
            } while (index >= 0);
        }
        return subsets;
    }

    public static Object[] getSubset(Object[] input, int[] indices) {
        Object[] result = new Object[indices.length];
        for (int index = 0; index < indices.length; ++index) {
            result[index] = input[indices[index]];
        }
        return result;
    }

    private ListenerHandler getListenerHandler() {
        return this.listenerHandler;
    }

    private Map<Integer, Boolean> getPositionStates() {
        return this.positionStates;
    }

    public ImageFileMetaData getMetaData() {
        return this.metaData;
    }

    public RasterGeoRefFeature getFeature() {
        return this.feature;
    }

    public ImageRasterService getService() {
        return this.service;
    }

    private AffineTransformation getInitialTransform() {
        return this.initialTransform;
    }

    private class ListenerHandler
    implements RasterGeoReferencingHandlerListener {
        private final Collection<RasterGeoReferencingHandlerListener> listeners = new ArrayList<RasterGeoReferencingHandlerListener>();

        private ListenerHandler() {
        }

        public boolean add(RasterGeoReferencingHandlerListener listener) {
            return this.listeners.add(listener);
        }

        public boolean remove(RasterGeoReferencingHandlerListener listener) {
            return this.listeners.remove(listener);
        }

        @Override
        public void positionAdded(int position) {
            for (RasterGeoReferencingHandlerListener listener : this.listeners) {
                listener.positionAdded(position);
            }
        }

        @Override
        public void positionRemoved(int position) {
            for (RasterGeoReferencingHandlerListener listener : this.listeners) {
                listener.positionRemoved(position);
            }
        }

        @Override
        public void positionChanged(int position) {
            for (RasterGeoReferencingHandlerListener listener : this.listeners) {
                listener.positionChanged(position);
            }
        }

        @Override
        public void transformationChanged() {
            for (RasterGeoReferencingHandlerListener listener : this.listeners) {
                listener.transformationChanged();
            }
        }
    }
}

