/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice.georeferencing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.geom.util.AffineTransformationBuilder;
import de.cismet.cismap.commons.rasterservice.georeferencing.PointCoordinatePair;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingHandler;
import java.awt.Point;
import java.util.ArrayList;

public class TestTransformation {
    public static void main(String[] args) {
        long a = System.currentTimeMillis();
        ArrayList<Object> pairs = new ArrayList<Object>();
        for (int i = 0; i < 5; ++i) {
            PointCoordinatePair pair = new PointCoordinatePair(new Point(i, i), new Coordinate((double)(i + 5), (double)(i + 5)));
            pairs.add(pair);
        }
        ArrayList<AffineTransformation> transforms = new ArrayList<AffineTransformation>();
        for (Object[] arr : RasterGeoReferencingHandler.getCombinations(pairs.toArray(), 3)) {
            PointCoordinatePair pair0 = (PointCoordinatePair)arr[0];
            PointCoordinatePair pointCoordinatePair = (PointCoordinatePair)arr[1];
            PointCoordinatePair pair2 = (PointCoordinatePair)arr[2];
            AffineTransformationBuilder builder = new AffineTransformationBuilder(new Coordinate(pair0.getPoint().getX(), pair0.getPoint().getY()), new Coordinate(pointCoordinatePair.getPoint().getX(), pointCoordinatePair.getPoint().getY()), new Coordinate(pair2.getPoint().getX(), pair2.getPoint().getY()), pair0.getCoordinate(), pointCoordinatePair.getCoordinate(), pair2.getCoordinate());
            AffineTransformation transform = builder.getTransformation();
            if (transform == null) continue;
            transforms.add(transform);
        }
        AffineTransformation transform = RasterGeoReferencingHandler.createAverageTransformation(transforms);
        System.out.println(transform);
        int r = 0;
        for (PointCoordinatePair pointCoordinatePair : pairs) {
            Coordinate src = new Coordinate(pointCoordinatePair.getPoint().getX(), pointCoordinatePair.getPoint().getY());
            Coordinate dst = transform.transform(src, new Coordinate());
            System.out.println(r++ + ": " + dst.distance(src));
        }
        long b = System.currentTimeMillis();
        System.out.println(transforms.size() + ": " + (b - a));
    }
}

