/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice.java_iio;

import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.stream.ImageInputStream;
import org.apache.log4j.Logger;

public class ImageRetrieval
extends Thread
implements IIOReadProgressListener {
    Image image = null;
    ImageReader ir = null;
    private final Logger log = Logger.getLogger(this.getClass());
    private String url;
    private RetrievalListener listener = null;
    private boolean youngerCall = false;

    public ImageRetrieval(RetrievalListener listener) {
        super("ImageRetrieval");
        this.listener = listener;
    }

    public void youngerWMSCall() {
        this.youngerCall = true;
        if (this.ir != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"ir.abort();");
            }
            this.ir.abort();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void run() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"IR Thread started");
        }
        this.image = null;
        ImageInputStream iis = null;
        try {
            URL u = new URL(this.url.toString());
            URLConnection uc = u.openConnection();
            String mimeType = uc.getContentType();
            uc.connect();
            InputStream is = uc.getInputStream();
            iis = ImageIO.createImageInputStream(is);
            Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mimeType);
            if (it.hasNext()) {
                this.ir = it.next();
                this.ir.setInput(iis, true);
                this.ir.addIIOReadProgressListener(this);
                this.image = this.ir.read(0);
                if (!this.youngerCall) {
                    RetrievalEvent e = new RetrievalEvent();
                    e.setIsComplete(true);
                    e.setRetrievedObject(this.image);
                    this.listener.retrievalComplete(e);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"RetrievalComplete");
                    }
                }
            } else {
                int c;
                BufferedInputStream in = new BufferedInputStream(is);
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                while ((c = in.read()) != -1) {
                    byteArrayOut.write(c);
                    if (!this.youngerCall) continue;
                    return;
                }
                RetrievalEvent e = new RetrievalEvent();
                e.setHasErrors(true);
                String error = new String(byteArrayOut.toByteArray());
                e.setRetrievedObject(error);
                this.listener.retrievalError(e);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while loading the image.", (Throwable)e);
        }
    }

    @Override
    public void imageComplete(ImageReader source) {
    }

    @Override
    public void imageProgress(ImageReader source, float percentageDone) {
        if (!this.youngerCall) {
            RetrievalEvent e = new RetrievalEvent();
            e.setPercentageDone((int)percentageDone);
            this.listener.retrievalProgress(e);
        }
    }

    @Override
    public void imageStarted(ImageReader source, int imageIndex) {
    }

    @Override
    public void readAborted(ImageReader source) {
    }

    @Override
    public void sequenceComplete(ImageReader source) {
    }

    @Override
    public void sequenceStarted(ImageReader source, int minIndex) {
    }

    @Override
    public void thumbnailComplete(ImageReader source) {
    }

    @Override
    public void thumbnailProgress(ImageReader source, float percentageDone) {
    }

    @Override
    public void thumbnailStarted(ImageReader source, int imageIndex, int thumbnailIndex) {
    }
}

