/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.retrieval;

import de.cismet.cismap.commons.retrieval.AbstractRetrievalService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.tools.CismetThreadPool;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

@Deprecated
public class UniversalRetrieval
extends AbstractRetrievalService
implements RetrievalListener {
    String url = null;

    public UniversalRetrieval(String url) {
        this.url = url;
    }

    public static void main(String[] args) {
        UniversalRetrieval ur = new UniversalRetrieval("http://www.google.de/intl/de_de/images/logo.gif");
        ur.retrieve(false);
    }

    @Override
    public void retrieve(boolean forced) {
        RetrievalThread rt = new RetrievalThread();
        CismetThreadPool.execute((Runnable)rt);
    }

    @Override
    public void retrievalStarted(RetrievalEvent e) {
        this.fireRetrievalStarted(e);
    }

    @Override
    public void retrievalProgress(RetrievalEvent e) {
        this.fireRetrievalProgress(e);
    }

    @Override
    public void retrievalError(RetrievalEvent e) {
        this.fireRetrievalProgress(e);
    }

    @Override
    public void retrievalComplete(RetrievalEvent e) {
        this.fireRetrievalComplete(e);
    }

    @Override
    public void retrievalAborted(RetrievalEvent e) {
        this.fireRetrievalAborted(e);
    }

    @Override
    public Object clone() {
        UniversalRetrieval u = new UniversalRetrieval(this.url);
        u.listeners = new Vector(this.listeners);
        return u;
    }

    class RetrievalThread
    extends Thread {
        private final Logger log;
        private ImageObserverInterceptor observer;
        private RetrievalListener listener;
        private ByteArrayOutputStream byteArrayOut;
        private URLConnection uc;
        private InputStream is;
        private Image image;
        private boolean youngerCall;
        private String contentType;

        public RetrievalThread() {
            super("RetrievalThread");
            this.log = Logger.getLogger(this.getClass());
            this.listener = null;
            this.byteArrayOut = null;
            this.uc = null;
            this.is = null;
            this.image = null;
            this.youngerCall = false;
            this.contentType = "";
            this.listener = UniversalRetrieval.this;
        }

        public void youngerCall() {
            this.youngerCall = true;
        }

        @Override
        public void run() {
            block20: {
                try {
                    int c;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"start of ImageRetrieval");
                    }
                    this.listener.retrievalStarted(new RetrievalEvent());
                    URL u = new URL(UniversalRetrieval.this.url.toString());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Retrieve: " + UniversalRetrieval.this.url.toString()));
                    }
                    this.uc = u.openConnection();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("contenttype: " + this.uc.getContentType()));
                    }
                    this.contentType = this.uc.getContentType();
                    this.uc.connect();
                    this.is = this.uc.getInputStream();
                    BufferedInputStream in = new BufferedInputStream(this.is);
                    this.byteArrayOut = new ByteArrayOutputStream();
                    while ((c = in.read()) != -1) {
                        this.byteArrayOut.write(c);
                        if (!this.youngerCall) continue;
                        this.fireLoadingAborted();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"interrupt during retrieval");
                        }
                        return;
                    }
                    if (this.uc.getContentType().indexOf("image") != -1) {
                        block19: {
                            this.observer = new ImageObserverInterceptor();
                            this.image = Toolkit.getDefaultToolkit().createImage(this.byteArrayOut.toByteArray());
                            this.observer.prepareImage(this.image, this.observer);
                            do {
                                if ((this.observer.checkImage(this.image, this.observer) & 0x20) == 32) break block19;
                                Thread.sleep(10L);
                            } while (!this.youngerCall);
                            this.fireLoadingAborted();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"interrupt during assembling");
                            }
                            return;
                        }
                        RetrievalEvent e = new RetrievalEvent();
                        e.setIsComplete(true);
                        e.setContentType(this.contentType);
                        e.setRetrievedObject(this.image);
                        if (!this.youngerCall) {
                            this.listener.retrievalComplete(e);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Retrieval complete");
                            }
                        } else {
                            this.fireLoadingAborted();
                        }
                        break block20;
                    }
                    if (this.uc.getContentType().indexOf("text") != -1) {
                        RetrievalEvent e = new RetrievalEvent();
                        e.setContentType(this.contentType);
                        e.setIsComplete(true);
                        e.setRetrievedObject(this.byteArrayOut.toString());
                        this.listener.retrievalComplete(e);
                    } else {
                        RetrievalEvent e = new RetrievalEvent();
                        e.setIsComplete(true);
                        e.setContentType(this.contentType);
                        e.setRetrievedObject(this.byteArrayOut);
                        this.listener.retrievalComplete(e);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)this.byteArrayOut);
                    RetrievalEvent re = new RetrievalEvent();
                    re.setIsComplete(false);
                    re.setContentType(this.contentType);
                    if (e.getMessage() == null || e.getMessage().equals("null")) {
                        try {
                            String cause = e.getCause().getMessage();
                            re.setRetrievedObject(cause);
                        }
                        catch (Exception exception) {}
                    } else {
                        re.setRetrievedObject(e.getMessage());
                    }
                    this.listener.retrievalError(re);
                    this.log.error((Object)"Fehler beim Laden des Bildes ", (Throwable)e);
                }
            }
        }

        public void fireLoadingAborted() {
            this.log.info((Object)"Retrieval interrupted");
            this.image = null;
            this.observer = null;
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException ioe) {
                    this.log.warn((Object)"Exception during premature closing of the inputstream", (Throwable)ioe);
                }
            }
            System.gc();
        }

        private class ImageObserverInterceptor
        extends JComponent {
            private ImageObserverInterceptor() {
            }

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                boolean ret = super.imageUpdate(img, infoflags, x, y, width, height);
                if ((infoflags & 8) != 0) {
                    RetrievalEvent e = new RetrievalEvent();
                    e.setPercentageDone((int)((double)y / ((double)img.getHeight(this) - 1.0) * 100.0));
                    RetrievalThread.this.listener.retrievalProgress(e);
                } else if ((infoflags & 0x80) == 0 && (infoflags & 0x40) != 0) {
                    RetrievalEvent e = new RetrievalEvent();
                    e.setHasErrors(true);
                    String error = new String(RetrievalThread.this.byteArrayOut.toByteArray());
                    e.setRetrievedObject(error);
                    RetrievalThread.this.listener.retrievalError(e);
                }
                return ret;
            }
        }
    }
}

