/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.PersistentFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToLayerWorker;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.FilePersistenceManager;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class ExportDownload
extends AbstractCancellableDownload {
    private static int currentId = 0;
    protected FeatureServiceFeature[] features;
    protected AbstractFeatureService service;
    protected List<String[]> aliasAttributeList;
    protected String extension;
    protected String query;
    private boolean absoluteFileName;
    private final int id = ExportDownload.getId();

    private static synchronized int getId() {
        return ++currentId;
    }

    public void init(String filename, String extension, FeatureServiceFeature[] features, AbstractFeatureService service, List<String[]> aliasAttributeList, String query) {
        this.features = features;
        this.service = service;
        this.query = query;
        this.aliasAttributeList = aliasAttributeList;
        this.title = "Export " + (features != null ? Integer.valueOf(features.length) : "") + " Features";
        this.extension = extension;
        if (aliasAttributeList == null && features != null && features.length > 0) {
            this.aliasAttributeList = this.getAttributeNames(features[0]);
        }
        this.status = Download.State.WAITING;
        String filenameWithoutExt = filename;
        if (filename.contains(".") && filename.charAt(filename.length() - 4) == '.') {
            filenameWithoutExt = filename.substring(0, filename.length() - 4);
        }
        if (this.absoluteFileName || new File(filename).isAbsolute()) {
            File dir;
            this.fileToSaveTo = new File(filename + extension);
            int index = filename.lastIndexOf("/");
            if (index == -1) {
                index = filename.lastIndexOf("\\");
            }
            if (!(dir = new File(filename.substring(0, index))).exists()) {
                dir.mkdirs();
            }
        } else {
            this.determineDestinationFile(filenameWithoutExt, extension);
        }
    }

    protected void loadFeaturesIfRequired() throws Exception {
        if (this.features == null) {
            this.service.initAndWait();
            int pageSize = this.service.getMaxFeaturesPerPage() * 2;
            if (pageSize < 0 || this.service.getFeatureServiceAttributes() == null || this.service.getFeatureServiceAttributes().get("id") == null) {
                List featureList = this.service.getFeatureFactory().createFeatures(this.query != null ? this.query : this.service.getQuery(), null, null, 0, 0, null);
                this.features = featureList.toArray(new FeatureServiceFeature[featureList.size()]);
            } else {
                XBoundingBox bb;
                ArrayList<PersistentFeature> tmpFeatureList = new ArrayList<PersistentFeature>();
                Geometry g = ZoomToLayerWorker.getServiceBounds(this.service);
                FeatureServiceAttribute[] idAttr = new FeatureServiceAttribute[]{this.service.getFeatureServiceAttributes().get("id")};
                if (g != null) {
                    bb = new XBoundingBox(g);
                    try {
                        CrsTransformer transformer = new CrsTransformer(CismapBroker.getInstance().getSrs().getCode());
                        bb = transformer.transformBoundingBox(bb);
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                } else {
                    bb = null;
                }
                int count = this.service.getFeatureCount(this.query != null ? this.query : this.service.getQuery(), bb);
                int index = 0;
                FilePersistenceManager pm = new FilePersistenceManager(this.fileToSaveTo.getParentFile());
                do {
                    if (Thread.interrupted()) {
                        this.features = null;
                        pm.close();
                        return;
                    }
                    List featureList = this.service.getFeatureFactory().createFeatures(this.query != null ? this.query : this.service.getQuery(), null, null, index, pageSize, idAttr);
                    index += featureList.size();
                    for (FeatureServiceFeature f : featureList) {
                        tmpFeatureList.add(new PersistentFeature(f, pm));
                    }
                } while (index < count);
                this.features = tmpFeatureList.toArray(new FeatureServiceFeature[tmpFeatureList.size()]);
            }
            if (this.aliasAttributeList == null && this.features != null && this.features.length > 0) {
                this.aliasAttributeList = this.getAttributeNames(this.features[0]);
            }
        }
        if (this.service != null && this.service.getLayerProperties() != null && this.service.getLayerProperties().getAttributeTableRuleSet() != null) {
            AttributeTableRuleSet atr = this.service.getLayerProperties().getAttributeTableRuleSet();
            this.features = atr.prepareFeaturesForExport(this.features);
        }
    }

    public void setAbsoluteFileName(boolean absoluteFileName) {
        this.absoluteFileName = absoluteFileName;
    }

    public abstract String getDefaultExtension();

    private List<String[]> getAttributeNames(FeatureServiceFeature f) {
        ArrayList<String[]> attrNames = new ArrayList<String[]>();
        HashMap hm = f.getProperties();
        for (String attrName : hm.keySet()) {
            String[] aliasName = new String[2];
            aliasName[0] = aliasName[1] = attrName;
            attrNames.add(aliasName);
        }
        return attrNames;
    }

    protected List<String> toAliasList(List<String[]> aliasAttributeList) {
        return this.toAliasOrAttributeList(aliasAttributeList, true);
    }

    protected List<String> toAttributeList(List<String[]> aliasAttributeList) {
        return this.toAliasOrAttributeList(aliasAttributeList, false);
    }

    private List<String> toAliasOrAttributeList(List<String[]> aliasAttributeList, boolean aliasList) {
        ArrayList<String> attrList = new ArrayList<String>(aliasAttributeList.size());
        for (String[] aliasAttr : aliasAttributeList) {
            attrList.add(aliasList ? aliasAttr[0] : aliasAttr[1]);
        }
        return attrList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExportDownload) {
            return ((ExportDownload)((Object)obj)).id == this.id && obj.getClass().getName().equals(((Object)((Object)this)).getClass().getName());
        }
        return super.equals(obj);
    }
}

