/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.PersistentFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.tools.ExportDownload;
import de.cismet.cismap.commons.tools.ExportShapeDownload;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.deegree.model.spatialschema.Geometry;
import org.deegree.model.spatialschema.GeometryException;
import org.deegree.model.spatialschema.JTSAdapter;
import org.openide.util.NbBundle;

public class ExportTxtDownload
extends ExportDownload {
    protected String separator = "\t";
    protected boolean writeHeader = true;
    protected String nullValue = "";
    protected String quotes = null;

    public ExportTxtDownload() {
    }

    public ExportTxtDownload(String filename, String extension, FeatureServiceFeature[] features, AbstractFeatureService service, List<String[]> attributeNames) {
        this.init(filename, extension, features, service, attributeNames, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        try {
            this.status = Download.State.RUNNING;
            this.stateChanged();
            try {
                this.loadFeaturesIfRequired();
            }
            catch (Exception e) {
                log.error((Object)"Error while retrieving features", (Throwable)e);
                this.error(e);
                this.features = null;
                this.service = null;
                return;
            }
            if (this.features == null) {
                this.features = new FeatureServiceFeature[0];
            }
            List<String> attributeList = this.toAttributeList(this.aliasAttributeList);
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(this.fileToSaveTo));
                if (this.aliasAttributeList != null && this.writeHeader) {
                    bw.write(this.toString(this.toAliasList(this.aliasAttributeList), true));
                    bw.newLine();
                }
                for (FeatureServiceFeature feature : this.features) {
                    if (Thread.interrupted()) {
                        bw.close();
                        this.fileToSaveTo.delete();
                        bw = null;
                        break;
                    }
                    bw.write(this.toString(attributeList, feature));
                    bw.newLine();
                }
            }
            catch (Exception ex) {
                this.error(ex);
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while closing file", (Throwable)e);
                    }
                }
            }
            if (this.features.length > 0 && this.features[0] instanceof PersistentFeature) {
                ((PersistentFeature)this.features[0]).getPersistenceManager().close();
            }
            if (this.status == Download.State.RUNNING) {
                this.status = Download.State.COMPLETED;
                this.stateChanged();
            }
        }
        finally {
            this.features = null;
            this.service = null;
        }
    }

    private String toString(List<String> attributeNames, FeatureServiceFeature f) {
        HashMap hm = f.getProperties();
        ArrayList vals = new ArrayList();
        for (String attrName : attributeNames) {
            Object o = hm.get(attrName);
            vals.add(o);
        }
        return this.toString(vals, false);
    }

    /*
     * WARNING - void declaration
     */
    private String toString(List<? extends Object> vals, boolean withoutQuotes) {
        StringBuffer result = null;
        for (Object object : vals) {
            void var5_5;
            void var5_8;
            if (object == null) {
                String string = this.nullValue;
            }
            if (var5_8 instanceof Geometry) {
                Geometry geom = (Geometry)var5_8;
                String string = "Geometry";
                try {
                    com.vividsolutions.jts.geom.Geometry geometry = JTSAdapter.export((Geometry)geom);
                }
                catch (GeometryException e) {
                    log.error((Object)"Error while transforming deegree geometry to jts geometry.", (Throwable)e);
                }
            }
            if (result == null) {
                result = new StringBuffer();
            } else {
                result.append(this.separator);
            }
            if (!withoutQuotes && this.quotes != null && (var5_5 instanceof String || var5_5 instanceof com.vividsolutions.jts.geom.Geometry)) {
                result.append(this.quotes).append(String.valueOf(var5_5)).append(this.quotes);
                continue;
            }
            if (var5_5 instanceof Float || var5_5 instanceof Double) {
                result.append(FeatureTools.FORMATTER.format(var5_5));
                continue;
            }
            result.append(String.valueOf(var5_5));
        }
        return result.toString();
    }

    @Override
    public String getDefaultExtension() {
        return ".txt";
    }

    public String toString() {
        return NbBundle.getMessage(ExportShapeDownload.class, (String)"ExportTxtDownload.toString");
    }
}

