/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jdesktop.swingx.image.ColorTintFilter;

public final class IconUtils {
    private static Font font = new Font("Courier", 0, 11);
    public static final int SPACING_X = 5;
    private static final Graphics SAMPLE = new BufferedImage(1, 1, 1).getGraphics();

    private IconUtils() {
    }

    public static Image mergeStringsToIcon(Image img, Collection<String> strings, Color color) {
        if (img != null && strings != null && strings.size() > 0) {
            FontMetrics fm = SAMPLE.getFontMetrics(font);
            double maxX = 0.0;
            double sumY = 0.0;
            for (String str : strings) {
                Rectangle2D rec = fm.getStringBounds(str, SAMPLE);
                if (rec.getWidth() > maxX) {
                    maxX = rec.getWidth();
                }
                sumY += rec.getHeight() * 0.8;
            }
            float offset = (float)sumY / (float)strings.size();
            int imageX = new Double((double)(img.getWidth(null) + 5) + maxX).intValue() + 1;
            int imageY = Math.max(img.getHeight(null), new Double(sumY - (double)offset * 0.2).intValue() + 1);
            BufferedImage bi = new BufferedImage(imageX, imageY, 6);
            Graphics2D g2d = (Graphics2D)bi.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.drawImage(img, 0, 0, null);
            g2d.setColor(color);
            FontRenderContext frc = g2d.getFontRenderContext();
            int xPos = img.getWidth(null) + 5;
            float yPos = offset * 0.8f;
            for (String str : strings) {
                TextLayout tl = new TextLayout(str, font, frc);
                tl.draw(g2d, xPos, yPos);
                yPos += offset;
            }
            return bi;
        }
        return img;
    }

    public static Image mergeNumbersToIcon(Image img, Collection<Integer> numbers, Color color) {
        if (img != null && numbers != null && numbers.size() > 0) {
            ArrayList<Integer> sort = new ArrayList<Integer>(numbers);
            Collections.sort(sort);
            ArrayList<String> str = new ArrayList<String>(sort.size());
            for (Integer i : sort) {
                str.add(String.valueOf(i));
            }
            return IconUtils.mergeStringsToIcon(img, str, color);
        }
        return img;
    }

    public static Image changeImageColor(Image img, Color color, float tint) {
        if (img != null && color != null) {
            BufferedImage src = new BufferedImage(img.getWidth(null), img.getHeight(null), 6);
            BufferedImage dst = new BufferedImage(img.getWidth(null), img.getHeight(null), 6);
            Graphics2D g2d = (Graphics2D)src.getGraphics();
            g2d.drawImage(img, 0, 0, null);
            ColorTintFilter ctf = new ColorTintFilter(color, tint);
            ctf.filter(src, dst);
            return dst;
        }
        return img;
    }

    public static double calcNewSweepSpotX(double oldSweepX, Image plain, Image merged) {
        int oldW = plain.getWidth(null);
        int newW = merged.getWidth(null);
        if (newW > oldW && newW != 0) {
            return oldSweepX * (double)oldW / (double)newW;
        }
        if (oldW > newW && oldW != 0) {
            return oldSweepX * (double)newW / (double)oldW;
        }
        return oldSweepX;
    }

    public static double calcNewSweepSpotY(double oldSweepY, Image plain, Image merged) {
        int oldH = plain.getHeight(null);
        int newH = merged.getHeight(null);
        if (newH > oldH && newH != 0) {
            return oldSweepY * (double)oldH / (double)newH;
        }
        if (newH < oldH && oldH != 0) {
            return oldSweepY * (double)newH / (double)oldH;
        }
        return oldSweepY;
    }

    public static Font getFont() {
        return font;
    }

    public static void setFont(Font font) {
        IconUtils.font = font;
    }
}

