/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class MapImageDownload
extends AbstractCancellableDownload {
    private static final Logger LOG = Logger.getLogger(MapImageDownload.class);
    String extension;
    MappingComponent map;

    public MapImageDownload(String filename, String extension, File fileToSaveTo, MappingComponent map) {
        this.extension = extension;
        this.map = map;
        this.title = NbBundle.getMessage(MapImageDownload.class, (String)"MapImageDownload.title");
        this.status = Download.State.WAITING;
        this.fileToSaveTo = fileToSaveTo;
    }

    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        Image image = this.map.getImage();
        if (image != null && !Thread.interrupted()) {
            try {
                ImageIO.write((RenderedImage)this.removeTransparency(image), this.extension, this.fileToSaveTo);
            }
            catch (IOException ex) {
                LOG.error((Object)"Error while saving the image", (Throwable)ex);
                this.status = Download.State.COMPLETED_WITH_ERROR;
                this.stateChanged();
                this.deleteFile();
                return;
            }
        } else {
            this.status = Download.State.COMPLETED_WITH_ERROR;
            this.stateChanged();
            this.deleteFile();
            return;
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage removeTransparency(Image transparentImage) {
        BufferedImage whiteBackgroundImage = new BufferedImage(transparentImage.getWidth(null), transparentImage.getHeight(null), 1);
        Graphics2D g2 = null;
        try {
            g2 = whiteBackgroundImage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, whiteBackgroundImage.getWidth(), whiteBackgroundImage.getHeight());
            g2.drawImage(transparentImage, 0, 0, whiteBackgroundImage.getWidth(), whiteBackgroundImage.getHeight(), null);
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
        return whiteBackgroundImage;
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.fileToSaveTo.getAbsolutePath() != null ? this.fileToSaveTo.getAbsolutePath().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

