/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import Sirius.util.collections.MultiMap;
import com.vividsolutions.jts.algorithm.CentroidPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.ParentNodeIsAPFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedLineFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public class PFeatureTools {
    private static final Logger LOG = Logger.getLogger(PFeatureTools.class);

    public static PNode getFirstValidObjectUnderPointer2(PInputEvent pInputEvent, Class[] validClasses) {
        return PFeatureTools.getFirstValidObjectUnderPointer2(pInputEvent, validClasses, 0.0);
    }

    public static PNode getFirstValidObjectUnderPointer2(PInputEvent pInputEvent, Class[] validClasses, double halo) {
        List<PNode> allValids = PFeatureTools.getFirstObjectsUnderPointer(pInputEvent, validClasses, halo);
        if (allValids.isEmpty()) {
            return null;
        }
        return allValids.get(0);
    }

    public static List<PNode> getFirstObjectsUnderPointer(PInputEvent pInputEvent, Class[] validClasses, double halo) {
        return PFeatureTools.getValidObjectsUnderPointer(pInputEvent, validClasses, halo, true);
    }

    public static List<PNode> getValidObjectsUnderPointer(PInputEvent pInputEvent, Class[] validClasses, double halo) {
        return PFeatureTools.getValidObjectsUnderPointer(pInputEvent, validClasses, halo, false);
    }

    public static List<PNode> getValidObjectsUnderPointer(PInputEvent pInputEvent, Class[] validClasses, double halo, boolean stopAfterFirstValid) {
        MappingComponent mc = (MappingComponent)pInputEvent.getComponent();
        WorldToScreenTransform wtst = mc.getWtst();
        double x1 = wtst.getWorldX(pInputEvent.getPosition().getX());
        double y1 = wtst.getWorldY(pInputEvent.getPosition().getY());
        return PFeatureTools.getValidObjectsUnderPointer(pInputEvent, x1, y1, validClasses, halo, stopAfterFirstValid);
    }

    public static List<PNode> getValidObjectsUnderPointer(PInputEvent pInputEvent, double xCoor, double yCoord, Class[] validClasses, double halo, boolean stopAfterFirstValid) {
        MappingComponent mc = (MappingComponent)pInputEvent.getComponent();
        int srs = CrsTransformer.extractSridFromCrs(mc.getMappingModel().getSrs().getCode());
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srs);
        Object point = halo > 0.0 ? gf.createPoint(new Coordinate(xCoor, yCoord)).buffer(halo * mc.getScaleDenominator()) : gf.createPoint(new Coordinate(xCoor, yCoord));
        ArrayList<PFeature> pNodes = new ArrayList<PFeature>(PFeatureTools.findIntersectingPFeatures((PNode)mc.getFeatureLayer(), (Geometry)point));
        for (int i = 0; i < mc.getMapServiceLayer().getChildrenCount(); ++i) {
            PNode pNode = mc.getMapServiceLayer().getChild(i);
            if (!(pNode instanceof PLayer)) continue;
            pNodes.addAll(PFeatureTools.findIntersectingPFeatures(pNode, (Geometry)point));
        }
        LinkedList<PNode> allValidPNodes = new LinkedList<PNode>();
        block1: for (PNode pNode : pNodes) {
            for (int i = 0; i < validClasses.length; ++i) {
                if (pNode == null || !validClasses[i].isAssignableFrom(pNode.getClass()) || pNode.getParent() == null || !pNode.getParent().getVisible() || !pNode.getVisible()) continue;
                allValidPNodes.add(pNode);
                if (stopAfterFirstValid) continue block1;
            }
        }
        return allValidPNodes;
    }

    public static PFeature[] getPFeaturesInArea(MappingComponent mc, PBounds bounds) {
        WorldToScreenTransform wtst = mc.getWtst();
        Geometry bBox = PFeatureTools.getGeometryFromPBounds(bounds, wtst, mc.getMappingModel().getSrs().getCode());
        return PFeatureTools.getPFeaturesInArea(mc, bBox);
    }

    public static PFeature[] getPFeaturesInArea(MappingComponent mc, Geometry geom) {
        List<PFeature> pFeatures = PFeatureTools.findIntersectingPFeatures((PNode)mc.getFeatureLayer(), geom);
        for (int i = 0; i < mc.getMapServiceLayer().getChildrenCount(); ++i) {
            PNode p = mc.getMapServiceLayer().getChild(i);
            if (!(p instanceof PLayer)) continue;
            pFeatures.addAll(PFeatureTools.findIntersectingPFeatures(mc.getMapServiceLayer().getChild(i), geom));
        }
        ArrayList<PFeature> vRet = new ArrayList<PFeature>(pFeatures.size());
        for (PFeature pf : pFeatures) {
            if (!pf.isSnappable()) continue;
            vRet.add(pf);
        }
        return vRet.toArray(new PFeature[0]);
    }

    public static Geometry getGeometryFromPBounds(PBounds bounds, WorldToScreenTransform wtst, String crs) {
        int srs = CrsTransformer.extractSridFromCrs(crs);
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srs);
        double x1 = wtst.getWorldX(bounds.x);
        double x2 = wtst.getWorldX(bounds.x + bounds.width);
        double y1 = wtst.getWorldY(bounds.y);
        double y2 = wtst.getWorldY(bounds.y + bounds.height);
        Coordinate[] polyCords = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x1, y2), new Coordinate(x2, y2), new Coordinate(x2, y1), new Coordinate(x1, y1)};
        return gf.createPolygon(gf.createLinearRing(polyCords), null);
    }

    public static List<PFeature> findIntersectingPFeatures(PNode node, Geometry geometry) {
        ArrayList<PFeature> pFeatures = new ArrayList<PFeature>();
        String srs = CrsTransformer.createCrsFromSrid(geometry.getSRID());
        for (int index = 0; index < node.getChildrenCount(); ++index) {
            PNode pNode = node.getChild(index);
            if (pNode instanceof PFeature) {
                PFeature pFeature = (PFeature)pNode;
                Geometry featureGeometry = pFeature.getFeature().getGeometry();
                if (featureGeometry.getSRID() != geometry.getSRID()) {
                    featureGeometry = CrsTransformer.transformToGivenCrs(featureGeometry, srs);
                }
                if (!PFeatureTools.intersects(featureGeometry, geometry)) continue;
                pFeatures.add(pFeature);
                continue;
            }
            pFeatures.addAll(PFeatureTools.findIntersectingPFeatures(pNode, geometry));
        }
        return pFeatures;
    }

    private static boolean intersects(Geometry g1, Geometry g2) {
        if (g2 instanceof GeometryCollection) {
            Geometry tmp = g1;
            g1 = g2;
            g2 = tmp;
        }
        if (g1 instanceof GeometryCollection && g2 instanceof GeometryCollection) {
            GeometryCollection gc1 = (GeometryCollection)g1;
            GeometryCollection gc2 = (GeometryCollection)g2;
            for (int i = 0; i < gc1.getNumGeometries(); ++i) {
                for (int n = 0; n < gc2.getNumGeometries(); ++n) {
                    Geometry geomEntry2;
                    Geometry geomEntry1 = gc1.getGeometryN(i);
                    if (!PFeatureTools.intersects(geomEntry1, geomEntry2 = gc2.getGeometryN(n))) continue;
                    return true;
                }
            }
            return false;
        }
        if (g1 instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g1;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                Geometry geomEntry = gc.getGeometryN(i);
                if (!PFeatureTools.intersects(geomEntry, g2)) continue;
                return true;
            }
            return false;
        }
        return g1.intersects(g2);
    }

    public static Point2D[] getPointsInArea(MappingComponent mc, PBounds bounds, PFeature vetoPFeature, MultiMap glueFeatureCoordinates) {
        PFeature[] features = PFeatureTools.getPFeaturesInArea(mc, bounds);
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        if (features == null) {
            return null;
        }
        for (PFeature pfeature : features) {
            if (pfeature.equals(vetoPFeature)) continue;
            Collection glueCoordinates = glueFeatureCoordinates != null ? (Collection)glueFeatureCoordinates.get((Object)pfeature) : null;
            for (int entityIndex = 0; entityIndex < pfeature.getNumOfEntities(); ++entityIndex) {
                for (int ringIndex = 0; ringIndex < pfeature.getNumOfRings(entityIndex); ++ringIndex) {
                    float[] xp = pfeature.getXp(entityIndex, ringIndex);
                    float[] yp = pfeature.getYp(entityIndex, ringIndex);
                    for (int position = 0; position < xp.length; ++position) {
                        if (glueCoordinates != null && glueCoordinates.contains(position) || !bounds.contains((double)xp[position], (double)yp[position])) continue;
                        points.add(new Point2D.Float(xp[position], yp[position]));
                    }
                }
            }
        }
        return points.toArray(new Point2D[0]);
    }

    private static Point2D getNearestPointInArea(MappingComponent mc, PBounds bounds, Point2D myPosition, PFeature vetoPFeature, MultiMap glueCoordinates) {
        Point2D[] points = PFeatureTools.getPointsInArea(mc, bounds, vetoPFeature, glueCoordinates);
        double distance = -1.0;
        Point2D nearestPoint = null;
        for (int i = 0; i < points.length; ++i) {
            double distanceCheck = myPosition.distanceSq(points[i]);
            if (!(distance < 0.0) && !(distanceCheck < distance)) continue;
            nearestPoint = points[i];
            distance = distanceCheck;
        }
        return nearestPoint;
    }

    public static Point2D getNearestPointInArea(MappingComponent mc, Point2D canvasPosition) {
        return PFeatureTools.getNearestPointInArea(mc, canvasPosition, null, null);
    }

    public static SnappedPoint getNearestPointInArea(MappingComponent mc, Point2D canvasPosition, boolean considerVetoObjects, MultiMap glueCoordinates) {
        if (mc.isSnappingEnabled()) {
            Point2D nearestPointOnLine;
            PFeature vetoFeature = considerVetoObjects ? CismapBroker.getInstance().getSnappingVetoFeature() : null;
            Point2D nearestPointOnPoint = MappingComponent.SnappingMode.POINT.equals((Object)mc.getSnappingMode()) || MappingComponent.SnappingMode.BOTH.equals((Object)mc.getSnappingMode()) ? PFeatureTools.getNearestPointInArea(mc, canvasPosition, vetoFeature, glueCoordinates) : null;
            Point2D point2D = nearestPointOnLine = nearestPointOnPoint == null && (MappingComponent.SnappingMode.LINE.equals((Object)mc.getSnappingMode()) || MappingComponent.SnappingMode.BOTH.equals((Object)mc.getSnappingMode())) ? PFeatureTools.getNearestPointInAreaNoVertexRequired(mc, canvasPosition, vetoFeature, glueCoordinates) : null;
            if (mc.getSnappingMode() != null) {
                switch (mc.getSnappingMode()) {
                    case POINT: {
                        if (nearestPointOnPoint == null) break;
                        return new SnappedPoint(nearestPointOnPoint, SnappedPoint.SnappedOn.POINT);
                    }
                    case LINE: {
                        if (nearestPointOnLine == null) break;
                        return new SnappedPoint(nearestPointOnLine, SnappedPoint.SnappedOn.LINE);
                    }
                    case BOTH: {
                        if (nearestPointOnPoint != null) {
                            return new SnappedPoint(nearestPointOnPoint, SnappedPoint.SnappedOn.POINT);
                        }
                        if (nearestPointOnLine == null) break;
                        return new SnappedPoint(nearestPointOnLine, SnappedPoint.SnappedOn.LINE);
                    }
                }
            }
        }
        return new SnappedPoint(mc.getCamera().localToView(canvasPosition), SnappedPoint.SnappedOn.NOTHING);
    }

    public static Point2D getNearestPointInAreaNoVertexRequired(MappingComponent mc, Point2D canvasPosition, PFeature vetoFeature, MultiMap glueCoordinates) {
        Rectangle2D area = PFeatureTools.getSnappingRectangle(mc, canvasPosition);
        Rectangle2D d2d = mc.getCamera().localToView((Rectangle2D)new PBounds(area));
        Point2D myPosition = mc.getCamera().localToView((Point2D)canvasPosition.clone());
        PBounds bounds = new PBounds(d2d);
        Point2D[] points = PFeatureTools.getPointsInAreaNoVertexRequired(mc, bounds, myPosition, vetoFeature, glueCoordinates);
        double distance = -1.0;
        Point2D nearestPoint = null;
        for (int i = 0; i < points.length; ++i) {
            double distanceCheck = myPosition.distanceSq(points[i]);
            if (!(distance < 0.0) && !(distanceCheck < distance)) continue;
            nearestPoint = points[i];
            distance = distanceCheck;
        }
        return nearestPoint;
    }

    public static Point2D[] getPointsInAreaNoVertexRequired(MappingComponent mc, PBounds bounds, Point2D currentPosition, PFeature vetoFeature, MultiMap glueFeatureCoordinates) {
        PFeature[] features = PFeatureTools.getPFeaturesInArea(mc, bounds);
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        if (features == null) {
            return null;
        }
        Coordinate c = new Coordinate(currentPosition.getX(), currentPosition.getY());
        for (PFeature pfeature : features) {
            Geometry geometry;
            Collection glueCoordinates;
            Collection collection = glueCoordinates = glueFeatureCoordinates != null ? (Collection)glueFeatureCoordinates.get((Object)pfeature) : null;
            if (pfeature.equals(vetoFeature)) continue;
            LineSegment segment = null;
            double dist = Double.POSITIVE_INFINITY;
            if (pfeature != null && ((geometry = pfeature.getFeature().getGeometry()) instanceof Polygon || geometry instanceof LineString || geometry instanceof MultiPolygon)) {
                for (int entityIndex = 0; entityIndex < pfeature.getNumOfEntities(); ++entityIndex) {
                    for (int ringIndex = 0; ringIndex < pfeature.getNumOfRings(entityIndex); ++ringIndex) {
                        float[] xp = pfeature.getXp(entityIndex, ringIndex);
                        float[] yp = pfeature.getYp(entityIndex, ringIndex);
                        for (int coordIndex = xp.length - 1; coordIndex > 0; --coordIndex) {
                            LineSegment tmpSegment;
                            double tmpDist;
                            if (glueCoordinates != null && (glueCoordinates.contains(coordIndex) || glueCoordinates.contains(coordIndex - 1)) || !((tmpDist = (tmpSegment = new LineSegment((double)xp[coordIndex - 1], (double)yp[coordIndex - 1], (double)xp[coordIndex], (double)yp[coordIndex])).distance(c)) < dist)) continue;
                            dist = tmpDist;
                            segment = tmpSegment;
                        }
                    }
                }
            }
            if (segment == null) continue;
            Coordinate point = segment.closestPoint(c);
            if (!bounds.contains(point.x, point.y)) continue;
            points.add(new Point2D.Float((float)point.x, (float)point.y));
        }
        return points.toArray(new Point2D[0]);
    }

    public static LineSegment getNearestSegment(Coordinate trigger, PFeature pfeature) {
        Geometry geometry;
        LineSegment segment = null;
        double dist = Double.POSITIVE_INFINITY;
        if (pfeature != null && ((geometry = pfeature.getFeature().getGeometry()) instanceof Polygon || geometry instanceof LineString || geometry instanceof MultiPolygon)) {
            for (int entityIndex = 0; entityIndex < pfeature.getNumOfEntities(); ++entityIndex) {
                for (int ringIndex = 0; ringIndex < pfeature.getNumOfRings(entityIndex); ++ringIndex) {
                    float[] xp = pfeature.getXp(entityIndex, ringIndex);
                    float[] yp = pfeature.getYp(entityIndex, ringIndex);
                    for (int coordIndex = xp.length - 1; coordIndex > 0; --coordIndex) {
                        LineSegment tmpSegment = new LineSegment((double)xp[coordIndex - 1], (double)yp[coordIndex - 1], (double)xp[coordIndex], (double)yp[coordIndex]);
                        double tmpDist = tmpSegment.distance(trigger);
                        if (!(tmpDist < dist)) continue;
                        dist = tmpDist;
                        segment = tmpSegment;
                    }
                }
            }
        }
        return segment;
    }

    public static Point2D getNearestPointInArea(MappingComponent mc, Point2D canvasPosition, PFeature vetoPFeature, MultiMap glueCoordinates) {
        Rectangle2D area = PFeatureTools.getSnappingRectangle(mc, canvasPosition);
        Rectangle2D d2d = mc.getCamera().localToView((Rectangle2D)new PBounds(area));
        Point2D myPosition = mc.getCamera().localToView((Point2D)canvasPosition.clone());
        return PFeatureTools.getNearestPointInArea(mc, new PBounds(d2d), myPosition, vetoPFeature, glueCoordinates);
    }

    private static Rectangle2D getSnappingRectangle(MappingComponent mc, Point2D canvasPosition) {
        return new Rectangle((int)canvasPosition.getX() - mc.getSnappingRectSize() / 2, (int)canvasPosition.getY() - mc.getSnappingRectSize() / 2, mc.getSnappingRectSize(), mc.getSnappingRectSize());
    }

    public static PNode getFirstValidObjectUnderPointer(PInputEvent pInputEvent, Class[] validClasses) {
        double halo = CismapBroker.getInstance().getSrs().isMetric() ? 1.0 : 1.0E-4;
        return PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, validClasses, halo);
    }

    public static PNode getFirstValidObjectUnderPointer(PInputEvent pInputEvent, Class[] validClasses, boolean deepPick) {
        double halo = CismapBroker.getInstance().getSrs().isMetric() ? 1.0 : 1.0E-4;
        return PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, validClasses, halo, deepPick);
    }

    public static Coordinate getNearestCoordinateInArea(MappingComponent mc, Point2D canvasPosition, boolean considerVetoObjects, MultiMap glueCoordinates) {
        PFeature vetoPFeature = considerVetoObjects ? CismapBroker.getInstance().getSnappingVetoFeature() : null;
        return PFeatureTools.getNearestCoordinateInArea(mc, canvasPosition, vetoPFeature, glueCoordinates);
    }

    public static Coordinate getNearestCoordinateInArea(MappingComponent mc, Point2D canvasPosition, PFeature vetoPFeature, MultiMap glueCoordinates) {
        Rectangle2D area = PFeatureTools.getSnappingRectangle(mc, canvasPosition);
        Rectangle2D d2d = mc.getCamera().localToView((Rectangle2D)new PBounds(area));
        Point2D myPosition = mc.getCamera().localToView((Point2D)canvasPosition.clone());
        return PFeatureTools.getNearestCoordinateInArea(mc, new PBounds(d2d), myPosition, vetoPFeature, glueCoordinates);
    }

    private static Coordinate getNearestCoordinateInArea(MappingComponent mc, PBounds bounds, Point2D myPosition, PFeature vetoPFeature, MultiMap glueFeatureCoordinates) {
        PFeature[] features = PFeatureTools.getPFeaturesInArea(mc, bounds);
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        ArrayList<Point2D.Float> p = new ArrayList<Point2D.Float>();
        if (features == null) {
            return null;
        }
        for (PFeature pfeature : features) {
            if (pfeature != null && (pfeature.getFeature() instanceof LinearReferencedPointFeature || pfeature.getFeature() instanceof LinearReferencedLineFeature) || pfeature.equals(vetoPFeature)) continue;
            Collection glueCoordinates = glueFeatureCoordinates != null ? (Collection)glueFeatureCoordinates.get((Object)pfeature) : null;
            for (int entityIndex = 0; entityIndex < pfeature.getNumOfEntities(); ++entityIndex) {
                for (int ringIndex = 0; ringIndex < pfeature.getNumOfRings(entityIndex); ++ringIndex) {
                    float[] xp = pfeature.getXp(entityIndex, ringIndex);
                    float[] yp = pfeature.getYp(entityIndex, ringIndex);
                    for (int position = 0; position < xp.length; ++position) {
                        if (glueCoordinates != null && glueCoordinates.contains(position) || !bounds.contains((double)xp[position], (double)yp[position])) continue;
                        p.add(new Point2D.Float(xp[position], yp[position]));
                        coordinates.add(pfeature.getCoordinate(entityIndex, ringIndex, position));
                    }
                }
            }
        }
        Point2D[] points = p.toArray(new Point2D[0]);
        double distance = -1.0;
        Coordinate nearestCoordinate = null;
        for (int i = 0; i < points.length; ++i) {
            double distanceCheck = myPosition.distanceSq(points[i]);
            if (!(distance < 0.0) && !(distanceCheck < distance)) continue;
            nearestCoordinate = (Coordinate)coordinates.get(i);
            distance = distanceCheck;
        }
        return nearestCoordinate;
    }

    public static PNode getFirstValidObjectUnderPointer(PInputEvent pInputEvent, Class[] validClasses, double halo) {
        return PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, validClasses, halo, false);
    }

    public static PNode getFirstValidObjectUnderPointer(PInputEvent pInputEvent, Class[] validClasses, double halo, boolean deepSeek) {
        PNode pNode = null;
        double xPos = pInputEvent.getPosition().getX();
        double yPos = pInputEvent.getPosition().getY();
        PPickPath pp = ((MappingComponent)pInputEvent.getComponent()).getCamera().pick(pInputEvent.getCanvasPosition().getX(), pInputEvent.getCanvasPosition().getY(), halo);
        pp.pushNode(pInputEvent.getPickedNode());
        if (deepSeek) {
            boolean first = true;
            do {
                if (first) {
                    pNode = pp.getPickedNode();
                    first = false;
                    continue;
                }
                pNode = pp.nextPickedNode();
            } while (pNode != null && (pNode = PFeatureTools.getRightPNodeOrNull(pNode, validClasses, xPos, yPos)) == null);
            return pNode;
        }
        int getIndex = pp.getNodeStackReference().size() - 1;
        if (pp.getNodeStackReference().size() > 0) {
            do {
                pNode = (PNode)pp.getNodeStackReference().get(getIndex);
                pNode = PFeatureTools.getRightPNodeOrNull(pNode, validClasses, xPos, yPos);
            } while (--getIndex >= 0 && pNode == null);
        }
        return pNode;
    }

    private static PNode getRightPNodeOrNull(PNode pNode, Class[] validClasses, double xPos, double yPos) {
        for (int i = 0; i < validClasses.length; ++i) {
            PFeature parentPNode;
            if (pNode != null && validClasses[i].isAssignableFrom(pNode.getClass()) && pNode.getParent() != null && pNode.getParent().getVisible() && pNode.getVisible()) {
                if (!(pNode instanceof PPath) || PFeatureTools.isPolygon((PPath)pNode) && !((PPath)pNode).getPathReference().contains(xPos, yPos)) continue;
                return pNode;
            }
            if (validClasses[i] != PFeature.class || pNode == null || !ParentNodeIsAPFeature.class.isAssignableFrom(pNode.getClass()) || pNode.getParent() == null || !pNode.getParent().getVisible() || !pNode.getVisible() || (parentPNode = PFeatureTools.getPFeatureByChild((ParentNodeIsAPFeature)pNode)) == null) continue;
            return parentPNode;
        }
        return null;
    }

    private static boolean isPolygon(PPath o) {
        if (o instanceof PFeature && ((PFeature)o).getFeature() != null) {
            PFeature feature = (PFeature)o;
            return feature.getFeature().getGeometry() instanceof Polygon || feature.getFeature().getGeometry() instanceof MultiPolygon;
        }
        return false;
    }

    public static List<PNode> getAllValidObjectsUnderPointer(PInputEvent pInputEvent, Class[] validClasses) {
        return PFeatureTools.getValidObjectsUnderPointer(pInputEvent, validClasses, 0.003, false);
    }

    public static PFeature getPFeatureByChild(ParentNodeIsAPFeature child) {
        PNode parent = ((PNode)child).getParent();
        if (parent instanceof PFeature) {
            return (PFeature)parent;
        }
        if (parent instanceof ParentNodeIsAPFeature) {
            return PFeatureTools.getPFeatureByChild((ParentNodeIsAPFeature)parent);
        }
        throw new IllegalArgumentException("ParentNodeIsAPFeature " + child + " has no ParentNode that is a PFeature");
    }

    public static Point2D centroid(PFeature pfeature) {
        double cx = 0.0;
        double cy = 0.0;
        for (int entityIndex = 0; entityIndex < pfeature.getNumOfEntities(); ++entityIndex) {
            for (int ringIndex = 0; ringIndex < pfeature.getNumOfRings(entityIndex); ++ringIndex) {
                float[] xp = pfeature.getXp(entityIndex, ringIndex);
                float[] yp = pfeature.getYp(entityIndex, ringIndex);
                int n = xp.length;
                for (int i = 0; i < n; ++i) {
                    int j = (i + 1) % n;
                    double factor = xp[i] * yp[j] - xp[j] * yp[i];
                    cx += (double)(xp[i] + xp[j]) * factor;
                    cy += (double)(yp[i] + yp[j]) * factor;
                }
                double factor = 1.0 / (6.0 * PFeatureTools.area(pfeature));
                cx *= factor;
                cy *= factor;
            }
        }
        return new Point2D.Double(cx, cy);
    }

    public static double area(PFeature pfeature) {
        double areaTotal = 0.0;
        for (int entityIndex = 0; entityIndex < pfeature.getNumOfEntities(); ++entityIndex) {
            for (int ringIndex = 0; ringIndex < pfeature.getNumOfRings(entityIndex); ++ringIndex) {
                float[] xp = pfeature.getXp(entityIndex, ringIndex);
                float[] yp = pfeature.getYp(entityIndex, ringIndex);
                int n = xp.length;
                double area = 0.0;
                for (int i = 0; i < n; ++i) {
                    int j = (i + 1) % n;
                    area += (double)(xp[i] * yp[j]);
                    area -= (double)(xp[j] * yp[i]);
                }
                area /= 2.0;
                if (ringIndex == 0) {
                    areaTotal += area;
                    continue;
                }
                areaTotal -= area;
            }
        }
        return areaTotal;
    }

    public static List<PFeatureCoordinateInformation> identifyMergeableCoordinates(Collection<PFeature> pFeatures, double thresholdInMeters) {
        ArrayList<PFeatureCoordinateInformation> groupedInfos = new ArrayList<PFeatureCoordinateInformation>();
        ArrayList<PFeatureCoordinateInformation> infos = new ArrayList<PFeatureCoordinateInformation>();
        for (PFeature pFeature : pFeatures) {
            Geometry geom = pFeature.getFeature().getGeometry();
            for (int entityPosition = 0; entityPosition < pFeature.getNumOfEntities(); ++entityPosition) {
                for (int ringPosition = 0; ringPosition < pFeature.getNumOfRings(entityPosition); ++ringPosition) {
                    int numOfCoordinates = geom instanceof Polygon || geom instanceof MultiPolygon ? pFeature.getNumOfCoordinates(entityPosition, ringPosition) - 1 : pFeature.getNumOfCoordinates(entityPosition, ringPosition);
                    for (int coordPosition = 0; coordPosition < numOfCoordinates; ++coordPosition) {
                        PFeatureCoordinateInformation info = new PFeatureCoordinateInformation(pFeature, entityPosition, ringPosition, coordPosition);
                        if (info.getCoordinate() == null) continue;
                        infos.add(info);
                    }
                }
            }
        }
        for (int i = 0; i < infos.size(); ++i) {
            PFeatureCoordinateInformation infoA = (PFeatureCoordinateInformation)infos.get(i);
            Coordinate coordA = infoA.getCoordinate();
            for (int j = i + 1; j < infos.size(); ++j) {
                PFeatureCoordinateInformation infoB = (PFeatureCoordinateInformation)infos.get(j);
                Coordinate coordB = infoB.getCoordinate();
                if (!(coordA.distance(coordB) < thresholdInMeters)) continue;
                infoA.getNeighbourInfos().add(infoB);
                infoB.getNeighbourInfos().add(infoA);
            }
        }
        for (PFeatureCoordinateInformation info : new ArrayList(infos)) {
            boolean onlyZeroDistance = true;
            Coordinate coordinate = info.getCoordinate();
            PFeature pFeature = info.getPFeature();
            for (PFeatureCoordinateInformation neighbourInfo : info.getNeighbourInfos()) {
                PFeature neighbourPFeature = neighbourInfo.getPFeature();
                Coordinate neighbourCoordinate = neighbourInfo.getCoordinate();
                if (neighbourPFeature.equals(pFeature)) {
                    onlyZeroDistance = false;
                    break;
                }
                double distance = neighbourCoordinate.distance(coordinate);
                if (!(distance > 0.0)) continue;
                onlyZeroDistance = false;
                break;
            }
            if (!onlyZeroDistance) continue;
            infos.remove(info);
        }
        while (!infos.isEmpty()) {
            Collections.sort(infos);
            PFeatureCoordinateInformation firstInfo = (PFeatureCoordinateInformation)infos.get(0);
            if (!firstInfo.getNeighbourInfos().isEmpty()) {
                groupedInfos.add(firstInfo);
                for (PFeatureCoordinateInformation neighbourInfo : firstInfo.getNeighbourInfos()) {
                    neighbourInfo.getNeighbourInfos().remove(firstInfo);
                }
            }
            infos.remove(firstInfo);
        }
        return groupedInfos;
    }

    public static List<PFeatureCoordinateInformation> automergeCoordinates(Collection<PFeature> pFeatures, double thresholdInMeters) {
        return PFeatureTools.automergeCoordinates(PFeatureTools.identifyMergeableCoordinates(pFeatures, thresholdInMeters));
    }

    public static List<PFeatureCoordinateInformation> automergeCoordinates(List<PFeatureCoordinateInformation> groupedInfos) {
        ArrayList<PFeatureCoordinateInformation> unmergedInfos = new ArrayList<PFeatureCoordinateInformation>();
        MultiMap coordinateRemoveMap = new MultiMap();
        HashSet<PFeature> pFeatureToSync = new HashSet<PFeature>();
        for (PFeatureCoordinateInformation info : groupedInfos) {
            PFeature pFeature = info.getPFeature();
            Coordinate coordinate = info.getCoordinate();
            int entityPosition = info.getEntityPosition();
            int ringPosition = info.getRingPosition();
            int coordinatePosition = info.getCoordinatePosition();
            CentroidPoint centroidPoint = new CentroidPoint();
            try {
                centroidPoint.add(coordinate);
                for (PFeatureCoordinateInformation pFeatureCoordinateInformation : info.getNeighbourInfos()) {
                    Coordinate neighbourCoordinate = pFeatureCoordinateInformation.getCoordinate();
                    centroidPoint.add(neighbourCoordinate);
                }
                Coordinate centroid = centroidPoint.getCentroid();
                LOG.info((Object)("setting centroid to group parent. before: " + coordinate + " after:" + centroid));
                if (pFeature.moveCoordinate(entityPosition, ringPosition, coordinatePosition, centroid, false)) {
                    for (PFeatureCoordinateInformation neighbourInfo2 : info.getNeighbourInfos()) {
                        PFeature neighbourPFeature = neighbourInfo2.getPFeature();
                        int neighbourEntityPosition = neighbourInfo2.getEntityPosition();
                        int neighbourRingPosition = neighbourInfo2.getRingPosition();
                        int neighbourCoordinatePosition = neighbourInfo2.getCoordinatePosition();
                        Coordinate neighbourCoordinate = neighbourInfo2.getCoordinate();
                        if (neighbourPFeature.equals(pFeature) && neighbourEntityPosition == entityPosition && neighbourRingPosition == ringPosition) {
                            LOG.info((Object)"it's on the same ring of the same pfeature, the coordinate can be removed");
                            coordinateRemoveMap.put((Object)neighbourPFeature, (Object)neighbourInfo2);
                            continue;
                        }
                        LOG.info((Object)("setting centroid to group neighbour. before: " + neighbourCoordinate + " after:" + centroid));
                        if (neighbourPFeature.moveCoordinate(neighbourEntityPosition, neighbourRingPosition, neighbourCoordinatePosition, centroid, true)) {
                            pFeatureToSync.add(neighbourPFeature);
                            continue;
                        }
                        LOG.warn((Object)("cant move coordinate of  " + neighbourPFeature + ". It would result in an invalid geometry. coordinate: " + centroid));
                        unmergedInfos.add(neighbourInfo2);
                    }
                    pFeatureToSync.add(pFeature);
                    continue;
                }
                LOG.warn((Object)("cant move coordinate of  " + pFeature + ". It would result in an invalid geometry. coordinate: " + centroid));
                unmergedInfos.add(info);
            }
            catch (Exception ex) {
                LOG.warn((Object)"could not update all coordinates", (Throwable)ex);
            }
        }
        for (PFeature pFeature : coordinateRemoveMap.keySet()) {
            HashSet coordinateRemoveSet = new HashSet((Collection)coordinateRemoveMap.get((Object)pFeature));
            ArrayList coordinateRemoveInfos = new ArrayList(coordinateRemoveSet);
            Collections.sort(coordinateRemoveInfos, new Comparator<PFeatureCoordinateInformation>(){

                @Override
                public int compare(PFeatureCoordinateInformation o1, PFeatureCoordinateInformation o2) {
                    if (o1.getEntityPosition() != o2.getEntityPosition()) {
                        return -Integer.compare(o1.getEntityPosition(), o2.getEntityPosition());
                    }
                    if (o1.getRingPosition() != o2.getRingPosition()) {
                        return -Integer.compare(o1.getRingPosition(), o2.getRingPosition());
                    }
                    if (o1.getCoordinatePosition() != o2.getCoordinatePosition()) {
                        return -Integer.compare(o1.getCoordinatePosition(), o2.getCoordinatePosition());
                    }
                    return 0;
                }
            });
            for (PFeatureCoordinateInformation info : coordinateRemoveInfos) {
                int entityPosition = info.getEntityPosition();
                int ringPosition = info.getRingPosition();
                int coordinatePosition = info.getCoordinatePosition();
                Geometry geometry = pFeature.getFeature().getGeometry();
                int minCoordinates = geometry instanceof Polygon || geometry instanceof MultiPolygon ? 3 : (geometry instanceof LineString || geometry instanceof MultiLineString ? 2 : 0);
                int numOfCoords = pFeature.getNumOfCoordinates(entityPosition, ringPosition);
                if (numOfCoords > minCoordinates && pFeature.removeCoordinate(entityPosition, ringPosition, coordinatePosition, false)) {
                    pFeatureToSync.add(pFeature);
                    continue;
                }
                LOG.warn((Object)("cant remove coordinate from  " + pFeature + ". It would result in an invalid geometry."));
                unmergedInfos.add(info);
            }
        }
        for (PFeature pFeature : pFeatureToSync) {
            pFeature.updatePath();
            pFeature.syncGeometry();
        }
        return unmergedInfos;
    }

    public static class SnappedPoint {
        private final Point2D point;
        private final SnappedOn snappedOn;

        public SnappedPoint(Point2D point, SnappedOn snappedOn) {
            this.point = point;
            this.snappedOn = snappedOn;
        }

        public Point2D getPoint() {
            return this.point;
        }

        public SnappedOn getSnappedOn() {
            return this.snappedOn;
        }

        public static enum SnappedOn {
            NOTHING,
            POINT,
            LINE;

        }
    }

    public static class PFeatureCoordinateInformation
    implements Comparable<PFeatureCoordinateInformation> {
        private final Collection<PFeatureCoordinateInformation> neighbourInfos = new ArrayList<PFeatureCoordinateInformation>();
        private final PFeature pFeature;
        private final int entityPosition;
        private final int ringPosition;
        private final int coordinatePosition;

        public Coordinate getCoordinate() {
            return this.pFeature.getCoordinate(this.entityPosition, this.ringPosition, this.coordinatePosition);
        }

        @Override
        public int compareTo(PFeatureCoordinateInformation o) {
            return Integer.compare(this.getNeighbourInfos().size(), o.getNeighbourInfos().size());
        }

        public int hashCode() {
            int hash = 7;
            hash = 13 * hash + Objects.hashCode(this.pFeature);
            hash = 13 * hash + this.entityPosition;
            hash = 13 * hash + this.ringPosition;
            hash = 13 * hash + this.coordinatePosition;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PFeatureCoordinateInformation other = (PFeatureCoordinateInformation)obj;
            if (this.entityPosition != other.entityPosition) {
                return false;
            }
            if (this.ringPosition != other.ringPosition) {
                return false;
            }
            if (this.coordinatePosition != other.coordinatePosition) {
                return false;
            }
            return Objects.equals(this.pFeature, other.pFeature);
        }

        public Collection<PFeatureCoordinateInformation> getNeighbourInfos() {
            return this.neighbourInfos;
        }

        public PFeature getPFeature() {
            return this.pFeature;
        }

        public int getEntityPosition() {
            return this.entityPosition;
        }

        public int getRingPosition() {
            return this.ringPosition;
        }

        public int getCoordinatePosition() {
            return this.coordinatePosition;
        }

        public PFeatureCoordinateInformation(PFeature pFeature, int entityPosition, int ringPosition, int coordinatePosition) {
            this.pFeature = pFeature;
            this.entityPosition = entityPosition;
            this.ringPosition = ringPosition;
            this.coordinatePosition = coordinatePosition;
        }
    }
}

