/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.factory.H2FeatureServiceFactory;
import de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget;
import de.cismet.cismap.commons.gui.options.CapabilityWidgetOptionsPanel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openide.util.NbBundle;

public class PointReferencingDialog
extends JDialog {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(PointReferencingDialog.class);
    private static Object lastFromProperty = null;
    private static Object lastTillProperty = null;
    private static Double MIN_X = null;
    private static Double MAX_X = null;
    private static Double MIN_Y = null;
    private static Double MAX_Y = null;
    private H2FeatureService service;
    private boolean geometry = false;
    private JButton butApply;
    private JButton butCancel;
    private JComboBox cbFrom;
    private JComboBox cbTill;
    private JLabel lblFrom;
    private JLabel lblTill;
    private JLabel lblTitle;

    public PointReferencingDialog(Frame parent, boolean modal, H2FeatureService service) {
        super(parent, modal);
        this.service = service;
        this.initComponents();
        this.lblTitle.setVisible(false);
        List<String> fields = this.getAllFieldNames(Number.class);
        this.cbFrom.setModel(new DefaultComboBoxModel<Object>(fields.toArray()));
        this.cbTill.setModel(new DefaultComboBoxModel<Object>(fields.toArray()));
        if (lastFromProperty != null) {
            this.cbFrom.setSelectedItem(lastFromProperty);
        }
        if (lastTillProperty != null) {
            this.cbTill.setSelectedItem(lastTillProperty);
        }
    }

    public static Double getMIN_X() {
        return MIN_X;
    }

    public static void setMIN_X(Double aMIN_X) {
        MIN_X = aMIN_X;
    }

    public static Double getMAX_X() {
        return MAX_X;
    }

    public static void setMAX_X(Double aMAX_X) {
        MAX_X = aMAX_X;
    }

    public static Double getMIN_Y() {
        return MIN_Y;
    }

    public static void setMIN_Y(Double aMIN_Y) {
        MIN_Y = aMIN_Y;
    }

    public static Double getMAX_Y() {
        return MAX_Y;
    }

    public static void setMAX_Y(Double aMAX_Y) {
        MAX_Y = aMAX_Y;
    }

    private List<String> getAllFieldNames(Class<?> cl) {
        Map<String, FeatureServiceAttribute> attributeMap = this.service.getFeatureServiceAttributes();
        List<String> names = this.service.getOrderedFeatureServiceAttributes();
        ArrayList<String> resultList = new ArrayList<String>();
        if (attributeMap == null || names == null) {
            try {
                this.service.initAndWait();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while initializing the feature service.", (Throwable)e);
            }
            attributeMap = this.service.getFeatureServiceAttributes();
            names = this.service.getOrderedFeatureServiceAttributes();
        }
        for (String name : names) {
            FeatureServiceAttribute attr = attributeMap.get(name);
            if (attr == null) continue;
            if (cl.isAssignableFrom(FeatureTools.getClass(attr))) {
                resultList.add(name);
            }
            if (!attr.isGeometry()) continue;
            this.geometry = true;
        }
        return resultList;
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.cbFrom = new JComboBox();
        this.cbTill = new JComboBox();
        this.lblFrom = new JLabel();
        this.lblTill = new JLabel();
        this.butApply = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Ubuntu", 1, 18));
        this.lblTitle.setText(NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.lblTitle.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 0);
        this.getContentPane().add((Component)this.lblTitle, gridBagConstraints);
        this.cbFrom.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbFrom.setMinimumSize(new Dimension(80, 27));
        this.cbFrom.setPreferredSize(new Dimension(180, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 10, 5);
        this.getContentPane().add((Component)this.cbFrom, gridBagConstraints);
        this.cbTill.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbTill.setMinimumSize(new Dimension(80, 27));
        this.cbTill.setPreferredSize(new Dimension(180, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 10, 5);
        this.getContentPane().add((Component)this.cbTill, gridBagConstraints);
        this.lblFrom.setFont(new Font("Ubuntu", 1, 15));
        this.lblFrom.setText(NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.lblFrom.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.lblFrom, gridBagConstraints);
        this.lblTill.setFont(new Font("Ubuntu", 1, 15));
        this.lblTill.setText(NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.lblTill.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.lblTill, gridBagConstraints);
        this.butApply.setText(NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApply.text", (Object[])new Object[0]));
        this.butApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointReferencingDialog.this.butApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.butApply, gridBagConstraints);
        this.butCancel.setText(NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointReferencingDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.butCancel, gridBagConstraints);
        this.pack();
    }

    private void butApplyActionPerformed(ActionEvent evt) {
        String tillField;
        final String fromField = String.valueOf(this.cbFrom.getSelectedItem());
        if (fromField.equals(tillField = String.valueOf(this.cbTill.getSelectedItem()))) {
            JOptionPane.showConfirmDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.xEqualsY"), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.xEqualsY.title"), -1, 0);
            return;
        }
        final String tableName = JOptionPane.showInputDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.tableName"), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.tableName.title"), 3);
        if (tableName == null || tableName.equals("")) {
            return;
        }
        if (H2FeatureService.tableAlreadyExists(tableName)) {
            JOptionPane.showConfirmDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.tableAlreadyExists"), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.tableAlreadyExists.title"), -1, 0);
            return;
        }
        WaitingDialogThread<ServiceWithHint> wdt = new WaitingDialogThread<ServiceWithHint>(StaticSwingTools.getParentFrame((Component)this.getParent()), true, NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed().text"), null, 200){

            protected ServiceWithHint doInBackground() throws Exception {
                PointReferencingDialog.this.service.initAndWait();
                HashMap<String, FeatureServiceAttribute> attributes = new HashMap<String, FeatureServiceAttribute>(PointReferencingDialog.this.service.getFeatureServiceAttributes());
                String geometryField = null;
                ArrayList<String> attributeOrder = new ArrayList<String>(PointReferencingDialog.this.service.getOrderedFeatureServiceAttributes());
                for (Object key : attributes.keySet()) {
                    FeatureServiceAttribute attr = (FeatureServiceAttribute)attributes.get(key);
                    if (!attr.isGeometry()) continue;
                    geometryField = key;
                    break;
                }
                if (geometryField != null) {
                    attributes.remove(geometryField);
                    attributeOrder.remove(geometryField);
                }
                attributes.put("geom", new FeatureServiceAttribute("geom", String.valueOf(10012), true));
                attributeOrder.add(0, "geom");
                ArrayList<FeatureServiceAttribute> featureServiceAttributes = new ArrayList<FeatureServiceAttribute>();
                for (String key : attributeOrder) {
                    FeatureServiceAttribute attr = (FeatureServiceAttribute)attributes.get(key);
                    featureServiceAttributes.add(attr);
                }
                ArrayList<FeatureServiceFeature> featureList = new ArrayList<FeatureServiceFeature>();
                GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getDefaultCrs()));
                DefaultLayerProperties layerProperties = new DefaultLayerProperties();
                layerProperties.setFeatureService(new H2FeatureService("dummy", "dummy", null, featureServiceAttributes));
                List features = PointReferencingDialog.this.service.getFeatureFactory().createFeatures(PointReferencingDialog.this.service.getQuery(), null, null, 0, 0, null);
                ArrayList newFeatures = new ArrayList();
                int invalidCount = 0;
                for (FeatureServiceFeature tmp : features) {
                    Double y;
                    Double x;
                    HashMap<String, Object> properties;
                    block18: {
                        block17: {
                            properties = new HashMap<String, Object>(featureServiceAttributes.size());
                            try {
                                if (tmp.getProperty(fromField) != null) {
                                    x = Double.parseDouble(tmp.getProperty(fromField).toString());
                                    break block17;
                                }
                                ++invalidCount;
                            }
                            catch (NumberFormatException e) {
                                ++invalidCount;
                            }
                            continue;
                        }
                        try {
                            if (tmp.getProperty(tillField) != null) {
                                y = Double.parseDouble(tmp.getProperty(tillField).toString());
                                break block18;
                            }
                            ++invalidCount;
                        }
                        catch (NumberFormatException e) {
                            ++invalidCount;
                        }
                        continue;
                    }
                    if (MIN_X != null && x < MIN_X || MAX_X != null && x > MAX_X || MIN_Y != null && y < MIN_Y || MAX_Y != null && y > MAX_Y) {
                        ++invalidCount;
                        continue;
                    }
                    Point g = geomFactory.createPoint(new Coordinate(x.doubleValue(), y.doubleValue()));
                    for (String propName : attributeOrder) {
                        if (propName.equals("geom")) {
                            properties.put(propName, g);
                            continue;
                        }
                        properties.put(propName, tmp.getProperty(propName));
                    }
                    DefaultFeatureServiceFeature lastFeature = new DefaultFeatureServiceFeature(tmp.getId(), (Geometry)g, layerProperties);
                    lastFeature.setProperties(properties);
                    featureList.add(lastFeature);
                }
                H2FeatureService internalService = null;
                String hint = null;
                if (featureList.size() > 0) {
                    internalService = new H2FeatureService(tableName, "~/cismap/internalH2", tableName, featureServiceAttributes, featureList);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"create the new data source");
                    }
                    internalService.initAndWait();
                } else {
                    hint = NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.themeNotCreated");
                }
                if (hint == null && invalidCount > 0) {
                    hint = NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.themePartiallyCreated", (Object)featureList.size(), (Object)(featureList.size() + invalidCount));
                }
                return new ServiceWithHint(hint, internalService);
            }

            protected void done() {
                try {
                    CapabilityWidget cap;
                    H2FeatureService service;
                    ServiceWithHint serviceWithHint = (ServiceWithHint)this.get();
                    String hint = serviceWithHint.getHint();
                    if (hint != null) {
                        JOptionPane.showMessageDialog(PointReferencingDialog.this, hint, NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.title"), 2);
                    }
                    if ((service = serviceWithHint.getService()) != null && (cap = CapabilityWidgetOptionsPanel.getCapabilityWidget()) != null) {
                        cap.refreshJdbcTrees();
                    }
                    lastFromProperty = PointReferencingDialog.this.cbFrom.getSelectedItem();
                    lastTillProperty = PointReferencingDialog.this.cbTill.getSelectedItem();
                }
                catch (H2FeatureServiceFactory.NegativeValueException ex) {
                    if (ex.isBoth()) {
                        JOptionPane.showConfirmDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.negativeValuesInBothAttributes"), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.negativeValuesInBothAttributes.title"), 2, 0);
                    } else {
                        JOptionPane.showConfirmDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.negativeValuesInAttribute", (Object)ex.getAttributeName()), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.negativeValuesInAttribute.title"), 2, 0);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while adding point references", (Throwable)e);
                }
            }
        };
        this.setVisible(false);
        wdt.start();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PointReferencingDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PointReferencingDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PointReferencingDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PointReferencingDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static class ServiceWithHint {
        private final String hint;
        private final H2FeatureService service;

        public ServiceWithHint(String hint, H2FeatureService service) {
            this.hint = hint;
            this.service = service;
        }

        public String getHint() {
            return this.hint;
        }

        public H2FeatureService getService() {
            return this.service;
        }
    }
}

