/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.util;

import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.WKTCrs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CrsDeterminer {
    private static final Logger LOG = Logger.getLogger(CrsDeterminer.class);

    public static boolean isCrsEqual(String authority, WKTCrs crs, WKTCrs otherCrs) {
        if (crs == null || otherCrs == null) {
            return false;
        }
        return otherCrs.getIdentifier() != null && authority != null && otherCrs.getIdentifier().equalsIgnoreCase(authority) || otherCrs.equals(crs);
    }

    public static Map<Crs, WKTCrs> getKnownCrsMappings() {
        HashMap<Crs, WKTCrs> prjMap = new HashMap<Crs, WKTCrs>();
        List<Crs> crsList = CismapBroker.getInstance().getMappingComponent().getCrsList();
        if (crsList != null) {
            for (Crs crs : crsList) {
                if (!crs.hasEsriDefinition()) continue;
                try {
                    prjMap.put(crs, new WKTCrs(crs.getEsriDefinition()));
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot parse the crs definition for " + crs.getCode() + ":\n" + crs.getEsriDefinition()), (Throwable)e);
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No crs definition found");
        }
        return prjMap;
    }

    public static String getEpsgCode(String crsDefinition) {
        Map<Crs, WKTCrs> prjMapping = CrsDeterminer.getKnownCrsMappings();
        if (prjMapping != null && !prjMapping.isEmpty()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("prj file with definition: " + crsDefinition + " found"));
                }
                crsDefinition = CrsDeterminer.crsDefinitionAdjustments(crsDefinition);
                WKTCrs crsFromShape = new WKTCrs(crsDefinition);
                for (Crs key : prjMapping.keySet()) {
                    if (!CrsDeterminer.isCrsEqual(key.getCode(), prjMapping.get(key), crsFromShape)) continue;
                    return key.getCode();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while parsing crs " + crsDefinition), (Throwable)e);
            }
        }
        return null;
    }

    public static String crsDefinitionAdjustments(String definition) {
        String firstPart;
        String invalidProjection = "projection[\"mercator_auxiliary_sphere\"]";
        String invalidParameter = "parameter[\"auxiliary_sphere_type\"";
        String tmp = definition;
        if (tmp.toLowerCase().contains("projection[\"mercator_auxiliary_sphere\"]")) {
            firstPart = tmp.substring(0, tmp.toLowerCase().indexOf("projection[\"mercator_auxiliary_sphere\"]"));
            String secondPart = tmp.substring(tmp.toLowerCase().indexOf("projection[\"mercator_auxiliary_sphere\"]") + "projection[\"mercator_auxiliary_sphere\"]".length(), tmp.length());
            tmp = firstPart + "PROJECTION[\"Mercator_2SP\"]" + secondPart;
        }
        if (tmp.toLowerCase().contains("parameter[\"auxiliary_sphere_type\"")) {
            firstPart = tmp.substring(0, tmp.toLowerCase().indexOf("parameter[\"auxiliary_sphere_type\""));
            String withoutParameterStart = tmp.substring(tmp.toLowerCase().indexOf("parameter[\"auxiliary_sphere_type\"") + "parameter[\"auxiliary_sphere_type\"".length(), tmp.length());
            withoutParameterStart = withoutParameterStart.substring(withoutParameterStart.indexOf("]") + 1, withoutParameterStart.length());
            String secondPart = withoutParameterStart.substring(withoutParameterStart.indexOf(",") + 1, withoutParameterStart.length());
            tmp = firstPart + secondPart;
        }
        return tmp;
    }
}

