/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.TransferHandler;

public class DnDUtils {
    public static DataFlavor URI_LIST_FLAVOR;

    public static List textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return list;
    }

    public static final boolean isFilesOrUriList(DropTargetDropEvent dtde) {
        return DnDUtils.isFilesOrUriList(new TransferSupportWrapper(dtde));
    }

    public static final boolean isFilesOrUriList(TransferSupportWrapper tsw) {
        if (tsw == null) {
            return false;
        }
        return tsw.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || tsw.isDataFlavorSupported(URI_LIST_FLAVOR);
    }

    public static List<File> getFilesFrom(DropTargetDropEvent dtde) throws UnsupportedFlavorException, IOException {
        return DnDUtils.getFilesFrom(new TransferSupportWrapper(dtde));
    }

    public static List<File> getFilesFrom(TransferSupportWrapper tsw) throws UnsupportedFlavorException, IOException {
        if (tsw == null) {
            return null;
        }
        List data = null;
        Transferable transferable = tsw.getTransferable();
        if (tsw.isDataFlavorSupported(URI_LIST_FLAVOR)) {
            try {
                data = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (Exception ex) {
                if (data == null) {
                    data = DnDUtils.textURIListToFileList((String)transferable.getTransferData(URI_LIST_FLAVOR));
                }
            }
        } else {
            data = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        }
        return data;
    }

    static {
        try {
            URI_LIST_FLAVOR = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static class TransferSupportWrapper {
        private DropTargetDropEvent event;
        private TransferHandler.TransferSupport transfer;

        public TransferSupportWrapper(DropTargetDropEvent event) {
            this.event = event;
        }

        public TransferSupportWrapper(TransferHandler.TransferSupport transfer) {
            this.transfer = transfer;
        }

        public boolean isDataFlavorSupported(DataFlavor df) {
            if (this.event != null) {
                return this.event.isDataFlavorSupported(df);
            }
            return this.transfer.isDataFlavorSupported(df);
        }

        public void acceptDrop(int action) {
            if (this.event != null) {
                this.event.acceptDrop(action);
            }
        }

        public void dropComplete(boolean success) {
            if (this.event != null) {
                this.event.dropComplete(success);
            }
        }

        public Transferable getTransferable() {
            if (this.event != null) {
                return this.event.getTransferable();
            }
            return this.transfer.getTransferable();
        }

        public List<DataFlavor> getCurrentDataFlavorsAsList() {
            if (this.event != null) {
                return this.event.getCurrentDataFlavorsAsList();
            }
            return Arrays.asList(this.transfer.getDataFlavors());
        }

        public DataFlavor[] getCurrentDataFlavors() {
            if (this.event != null) {
                return this.event.getCurrentDataFlavors();
            }
            return this.transfer.getDataFlavors();
        }
    }
}

