/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FilePersistenceManager {
    private static final Logger LOG = Logger.getLogger(FilePersistenceManager.class);
    private Map<Long, Integer> idLengthMap = new HashMap<Long, Integer>();
    private RandomAccessFile raFile;
    private File file;
    private long fileIndex = 0L;
    private long lastId = -1L;
    private Object lastObject = null;

    public FilePersistenceManager(File folder) {
        String fileNameBase = "tmp";
        int index = 0;
        do {
            this.file = new File(folder, "tmp" + ++index);
        } while (this.file.exists());
        try {
            this.raFile = new RandomAccessFile(this.file, "rw");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long save(Object o) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bos);
            oout.writeObject(o);
            oout.close();
            byte[] b = bos.toByteArray();
            long position = this.fileIndex;
            this.raFile.seek(this.fileIndex);
            this.raFile.write(b);
            this.fileIndex += (long)b.length;
            this.idLengthMap.put(position, b.length);
            return position;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while saving object.", (Throwable)e);
            return -1L;
        }
    }

    public Object load(long id) {
        try {
            if (id == this.lastId) {
                return this.lastObject;
            }
            int length = this.idLengthMap.get(id);
            byte[] b = new byte[length];
            this.raFile.seek(id);
            this.raFile.read(b, 0, length);
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            ObjectInputStream oin = new ObjectInputStream(bis);
            Object o = oin.readObject();
            oin.close();
            this.lastId = id;
            this.lastObject = o;
            return o;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading object.", (Throwable)e);
            return null;
        }
    }

    public void close() {
        try {
            this.idLengthMap = new HashMap<Long, Integer>();
            this.raFile.close();
            this.file.delete();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while closing FilePersistenceManager.", (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

