/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class WKTCrs {
    private final String wkt;
    private String proj;
    private String geogcs;
    private String datum;
    private String speroid;
    private String primem;
    private String unit;
    private String projection;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private String unit2;
    private String authority;

    public WKTCrs(String wkt) {
        this.wkt = wkt;
        wkt = wkt.replace("PROJCS[", "");
        wkt = wkt.substring(0, wkt.length());
        if (wkt.contains(",")) {
            this.proj = wkt.substring(0, wkt.indexOf(","));
            this.proj = this.proj.replace("\"", "");
            wkt = wkt.substring(wkt.indexOf(",") + 1);
            if ((wkt = wkt.replace("GEOGCS[", "")).contains(",")) {
                this.geogcs = wkt.substring(0, wkt.indexOf(","));
                this.geogcs = this.geogcs.replace("\"", "");
                wkt = wkt.substring(wkt.indexOf(",") + 1);
                if ((wkt = wkt.replace("DATUM[", "")).contains(",")) {
                    this.datum = wkt.substring(0, wkt.indexOf(","));
                    this.datum = this.geogcs.replace("\"", "");
                    wkt = wkt.substring(wkt.indexOf(",") + 1);
                    if ((wkt = wkt.replace("SPHEROID[", "")).contains("]")) {
                        this.speroid = wkt.substring(0, wkt.indexOf("]"));
                        wkt = wkt.substring(wkt.indexOf("]") + 3);
                        if ((wkt = wkt.replace("PRIMEM[", "")).contains("]")) {
                            this.primem = wkt.substring(0, wkt.indexOf("]"));
                            wkt = wkt.substring(wkt.indexOf("]") + 2);
                            if ((wkt = wkt.replace("UNIT[", "")).contains("]")) {
                                this.unit = wkt.substring(0, wkt.indexOf("]"));
                                wkt = wkt.substring(wkt.indexOf("]") + 3);
                                if ((wkt = wkt.replace("PROJECTION[", "")).contains("]")) {
                                    this.projection = wkt.substring(0, wkt.indexOf("]"));
                                    this.projection = this.projection.replace("\"", "");
                                    wkt = wkt.substring(wkt.indexOf("]") + 2);
                                    while (wkt.trim().startsWith("PARAMETER")) {
                                        String par = (wkt = wkt.substring(wkt.indexOf("PARAMETER[") + "PARAMETER[".length())).substring(0, wkt.indexOf("]"));
                                        if (par.contains(",")) {
                                            String key = par.substring(0, par.indexOf(","));
                                            String value = par.substring(par.indexOf(",") + 1);
                                            key = key.replace("\"", "");
                                            this.parameters.put(key, value);
                                        }
                                        wkt = wkt.substring(wkt.indexOf("]") + 2);
                                    }
                                    if (wkt.trim().startsWith("UNIT") && wkt.contains("]")) {
                                        wkt = wkt.replace("UNIT[", "");
                                        this.unit2 = wkt.substring(0, wkt.indexOf("]"));
                                        wkt = wkt.substring(wkt.indexOf("]") + 2);
                                    }
                                    if (wkt.trim().contains("AUTHORITY") && wkt.contains("]")) {
                                        wkt = wkt.substring(wkt.indexOf("\"AUTHORITY[\"") + "AUTHORITY[".length());
                                        this.authority = wkt.substring(0, wkt.indexOf("]"));
                                        if (this.authority.contains(",")) {
                                            this.authority = this.authority.substring(this.authority.indexOf(",") + 1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        return String.valueOf(this.wkt);
    }

    public boolean equals(Object obj) {
        if (obj instanceof WKTCrs) {
            WKTCrs other = (WKTCrs)obj;
            if (other.authority != null && this.authority != null) {
                return other.authority.equalsIgnoreCase(this.authority);
            }
            if (other.proj != null && this.proj != null) {
                return other.proj.equalsIgnoreCase(this.proj);
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.wkt);
        return hash;
    }

    public String getIdentifier() {
        return this.authority;
    }
}

