/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfs.capabilities;

import de.cismet.cismap.commons.capabilities.AbstractVersionNegotiator;
import de.cismet.cismap.commons.exceptions.ParserException;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import de.cismet.cismap.commons.wfs.capabilities.deegree.DeegreeWFSCapabilities;
import de.cismet.tools.CalculationCache;
import de.cismet.tools.Calculator;
import java.io.ByteArrayInputStream;
import org.apache.log4j.Logger;

public class WFSCapabilitiesFactory {
    private static final Logger logger = Logger.getLogger(WFSCapabilitiesFactory.class);
    private static final CalculationCache<String, WFSCapabilities> cache = new CalculationCache((Calculator)new InternalWFSCapabilitiesFactory());

    public WFSCapabilities createCapabilities(String link) throws Exception {
        return (WFSCapabilities)cache.calcValue((Object)link);
    }

    private static class InternalWFSCapabilitiesFactory
    extends AbstractVersionNegotiator
    implements Calculator<String, WFSCapabilities> {
        private InternalWFSCapabilitiesFactory() {
        }

        public WFSCapabilities calculate(String link) throws Exception {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("create capabilities from link: " + link));
            }
            String document = this.getCapabilitiesDocument(link);
            document = document.replace("xlink:href=\"\"", "xlink:href=\"http://test.de\"");
            ByteArrayInputStream docStream = new ByteArrayInputStream(document.getBytes());
            DeegreeWFSCapabilities result = null;
            String errorMsg = "";
            do {
                try {
                    result = new DeegreeWFSCapabilities(docStream, link);
                }
                catch (Throwable th) {
                    logger.warn((Object)"cannot parse the Getcapabilities document try to use an other version.", th);
                    errorMsg = th.getMessage();
                    docStream.close();
                    document = this.getOlderCapabilitiesDocument(link);
                    if (document == null) continue;
                    docStream = new ByteArrayInputStream(document.getBytes());
                }
            } while (result == null && this.currentVersion != null && document != null);
            if (result == null) {
                logger.error((Object)("cannot parse the GetCapabilities document of the wfs" + link));
                throw new ParserException(errorMsg);
            }
            docStream.close();
            return result;
        }

        protected void initVersion() {
            this.supportedVersions = new String[2];
            this.supportedVersions[0] = "1.0.0";
            this.supportedVersions[1] = "1.1.0";
            this.serviceName = "WFS";
        }
    }
}

