/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfs.capabilities.deegree;

import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.factory.WFSFeatureFactory;
import de.cismet.cismap.commons.wfs.FeatureTypeDescription;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.cismap.commons.wfs.capabilities.OperationType;
import de.cismet.cismap.commons.wfs.capabilities.OutputFormatType;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import de.cismet.cismap.commons.wfs.capabilities.deegree.DeegreeOperation;
import de.cismet.cismap.commons.wfs.capabilities.deegree.DeegreeOutputFormatType;
import de.cismet.commons.wms.capabilities.CoordinateSystem;
import de.cismet.commons.wms.capabilities.deegree.DeegreeCoordinateSystem;
import de.cismet.commons.wms.capabilities.deegree.DeegreeEnvelope;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.deegree.model.crs.CRSFactory;
import org.deegree.model.metadata.iso19115.Keywords;
import org.deegree.model.spatialschema.Envelope;
import org.deegree.ogcwebservices.wfs.capabilities.FormatType;
import org.deegree.ogcwebservices.wfs.capabilities.Operation;
import org.deegree.ogcwebservices.wfs.capabilities.WFSFeatureType;
import org.jdom.Element;

public class DeegreeFeatureType
implements FeatureType {
    private static final Logger LOG = Logger.getLogger(DeegreeFeatureType.class);
    private final WFSFeatureType feature;
    private final WFSCapabilities caps;
    private final String capabilitiesUrl;
    private Element query;
    private Vector<FeatureServiceAttribute> attributes;
    private String geometryName;

    public DeegreeFeatureType(WFSFeatureType feature, WFSCapabilities caps, String capabilitiesUrl) throws IOException, Exception {
        this.capabilitiesUrl = capabilitiesUrl;
        this.feature = feature;
        this.caps = caps;
        this.analyseStructure();
    }

    public String getCapabilitiesUrl() {
        return this.capabilitiesUrl;
    }

    @Override
    public QName getName() {
        String nameSpace = this.feature.getName().getNamespace() != null ? this.feature.getName().getNamespace().toString() : null;
        String prefix = this.feature.getName().getPrefix() == null ? "" : this.feature.getName().getPrefix();
        return new QName(nameSpace, this.feature.getName().getLocalName(), prefix);
    }

    @Override
    public String getAbstract() {
        return this.feature.getAbstract();
    }

    @Override
    public String getDefaultSRS() {
        return this.feature.getDefaultSRS().toString();
    }

    @Override
    public String getTitle() {
        return this.feature.getTitle();
    }

    @Override
    public String[] getKeywords() {
        Keywords[] words = this.feature.getKeywords();
        ArrayList<String> keywords = new ArrayList<String>();
        if (words != null) {
            for (Keywords tmp : words) {
                if (tmp == null) continue;
                for (String s : tmp.getKeywords()) {
                    keywords.add(s);
                }
            }
        }
        return keywords.toArray(new String[keywords.size()]);
    }

    @Override
    public String[] getSupportedSRS() {
        URI[] uris = this.feature.getOtherSrs();
        if (uris == null) {
            uris = new URI[]{};
        }
        String[] srs = new String[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            srs[i] = uris[i].toString();
        }
        return srs;
    }

    @Override
    public OperationType[] getOperations() {
        Operation[] operationsOrig = this.feature.getOperations();
        OperationType[] operations = new OperationType[operationsOrig.length];
        for (int i = 0; i < operationsOrig.length; ++i) {
            operations[i] = new DeegreeOperation(operationsOrig[i]);
        }
        return operations;
    }

    @Override
    public OutputFormatType[] getOutputFormats() {
        FormatType[] formatsOrig = this.feature.getOutputFormats();
        OutputFormatType[] formats = new OutputFormatType[formatsOrig.length];
        for (int i = 0; i < formatsOrig.length; ++i) {
            formats[i] = new DeegreeOutputFormatType(formatsOrig[i]);
        }
        return formats;
    }

    @Override
    public OutputFormatType getOutputFormat(String name) {
        return new DeegreeOutputFormatType(this.feature.getOutputFormat(name));
    }

    @Override
    public Element getWFSQuery() {
        return this.query;
    }

    @Override
    public void setWFSQuery(Element query) {
        this.query = query;
    }

    @Override
    public Vector<FeatureServiceAttribute> getFeatureAttributes() {
        return this.attributes;
    }

    @Override
    public String getNameOfGeometryAtrtibute() {
        return this.geometryName;
    }

    @Override
    public WFSCapabilities getWFSCapabilities() {
        return this.caps;
    }

    private void analyseStructure() throws IOException, Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("analyseStructure " + this.getName().toString()));
        }
        FeatureTypeDescription featTypeDesc = this.caps.getServiceFacade().describeFeatureType(this);
        this.attributes = featTypeDesc.getAllFeatureAttributes(this.caps);
        this.geometryName = featTypeDesc.getFirstGeometryName();
        this.query = this.caps.getServiceFacade().getGetFeatureQuery(this);
    }

    @Override
    public String getPrefixedNameString() {
        QName qname = this.getName();
        String name = WFSFeatureFactory.convertFeatureQnameToName(qname);
        return name;
    }

    @Override
    public de.cismet.commons.wms.capabilities.Envelope[] getWgs84BoundingBoxes() {
        Envelope[] envelopeOrig = this.feature.getWgs84BoundingBoxes();
        de.cismet.commons.wms.capabilities.Envelope[] envelopes = new de.cismet.commons.wms.capabilities.Envelope[envelopeOrig.length];
        for (int i = 0; i < envelopeOrig.length; ++i) {
            envelopes[i] = new DeegreeEnvelope(envelopeOrig[i]);
            if (envelopes[i].getCoordinateSystem() != null) continue;
            try {
                org.deegree.model.crs.CoordinateSystem cs = CRSFactory.create((String)"EPSG:4326");
                DeegreeCoordinateSystem dcs = new DeegreeCoordinateSystem(cs);
                ((DeegreeEnvelope)envelopes[i]).setCoordinateSystem((CoordinateSystem)dcs);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"CRS EPSG:4326 not found.", (Throwable)e);
            }
        }
        return envelopes;
    }
}

