/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfs.deegree;

import de.cismet.cismap.commons.exceptions.ParserException;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.wfs.FeatureTypeDescription;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.deegree.datatypes.QualifiedName;
import org.deegree.framework.xml.XMLFragment;
import org.deegree.framework.xml.schema.ComplexTypeDeclaration;
import org.deegree.framework.xml.schema.ElementDeclaration;
import org.deegree.framework.xml.schema.XMLSchema;
import org.deegree.framework.xml.schema.XSDocument;
import org.w3c.dom.Element;

public class DeegreeFeatureTypeDescription
implements FeatureTypeDescription {
    private static final Logger logger = Logger.getLogger(DeegreeFeatureTypeDescription.class);
    private org.deegree.ogcwebservices.wfs.operation.FeatureTypeDescription desc;
    private FeatureType feature;

    public DeegreeFeatureTypeDescription(String featureTypeDescription, FeatureType feature) throws ParserException {
        this.feature = feature;
        try {
            XMLFragment frag = new XMLFragment();
            frag.load((InputStream)new ByteArrayInputStream(featureTypeDescription.getBytes()), "http:/fake.de");
            this.desc = new org.deegree.ogcwebservices.wfs.operation.FeatureTypeDescription(frag);
        }
        catch (Exception e) {
            throw new ParserException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public Element getSchemaRootElement() {
        return this.desc.getFeatureTypeSchema().getRootElement();
    }

    public String toString() {
        return this.desc.toString();
    }

    @Override
    public Vector<FeatureServiceAttribute> getAllFeatureAttributes(WFSCapabilities caps) {
        try {
            XMLFragment xmlFrag;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("get complextypes for " + this.feature.getName().toString()));
            }
            if ((xmlFrag = this.desc.getFeatureTypeSchema()).hasSchema()) {
                XSDocument xsDoc = new XSDocument();
                xsDoc.setRootElement(xmlFrag.getRootElement());
                XMLSchema xmlSchema = xsDoc.parseXMLSchema();
                ElementDeclaration requestedElement = this.feature.getName().getPrefix() == null || this.feature.getName().getPrefix().equals("") ? xmlSchema.getElementDeclaration(this.feature.getName().getLocalPart()) : xmlSchema.getElementDeclaration(new QualifiedName(this.feature.getName()));
                if (requestedElement == null) {
                    logger.fatal((Object)("Error requestedElement == null " + this.feature.getName() + " " + caps.getURL().toString() + "\n\n" + this.desc.toString()));
                }
                if (requestedElement != null && requestedElement.getName().getNamespace() != null) {
                    ElementDeclaration[] elementDeclaration;
                    QualifiedName typeName = requestedElement.getType().getName();
                    ComplexTypeDeclaration compTypeDec = xmlSchema.getComplexTypeDeclaration(typeName);
                    if (compTypeDec == null) {
                        typeName = requestedElement.getName();
                        if (xmlSchema.getElementDeclaration(typeName).getType().getTypeDeclaration() instanceof ComplexTypeDeclaration) {
                            ComplexTypeDeclaration type = (ComplexTypeDeclaration)xmlSchema.getElementDeclaration(typeName).getType().getTypeDeclaration();
                            elementDeclaration = type.getElements();
                        } else {
                            elementDeclaration = new ElementDeclaration[]{};
                        }
                    } else {
                        elementDeclaration = compTypeDec.getElements();
                    }
                    if (this.getFirstGeometryName(elementDeclaration) != null) {
                        Vector<FeatureServiceAttribute> fsaVector = new Vector<FeatureServiceAttribute>(elementDeclaration.length);
                        for (ElementDeclaration e : elementDeclaration) {
                            String elementName = e.getName().getPrefix() == null || e.getName().getPrefix().equals("") ? e.getName().getLocalName() : e.getName().getPrefix() + ":" + e.getName().getLocalName();
                            fsaVector.add(new FeatureServiceAttribute(elementName, e.getType().getName().getPrefixedName(), true));
                        }
                        return fsaVector;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("complextypes found: " + elementDeclaration));
                    }
                }
            }
        }
        catch (Throwable ex) {
            logger.fatal((Object)"Error in getElementDeclarations", ex);
        }
        return null;
    }

    @Override
    public String getFirstGeometryName() {
        try {
            XMLFragment xmlFrag;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("get first geometry name for " + this.feature.getName().toString()));
            }
            if ((xmlFrag = this.desc.getFeatureTypeSchema()).hasSchema()) {
                XSDocument xsDoc = new XSDocument();
                xsDoc.setRootElement(xmlFrag.getRootElement());
                XMLSchema xmlSchema = xsDoc.parseXMLSchema();
                ElementDeclaration requestedElement = this.feature.getName().getPrefix() == null || this.feature.getName().getPrefix().equals("") ? xmlSchema.getElementDeclaration(this.feature.getName().getLocalPart()) : xmlSchema.getElementDeclaration(new QualifiedName(this.feature.getName()));
                if (requestedElement != null && requestedElement.getName().getNamespace() != null) {
                    QualifiedName typeName = requestedElement.getType().getName();
                    ComplexTypeDeclaration compTypeDec = xmlSchema.getComplexTypeDeclaration(typeName);
                    if (compTypeDec == null) {
                        if (requestedElement.getType().getTypeDeclaration() instanceof ComplexTypeDeclaration) {
                            ComplexTypeDeclaration type = (ComplexTypeDeclaration)requestedElement.getType().getTypeDeclaration();
                            return this.getFirstGeometryName(type.getElements());
                        }
                        return this.getFirstGeometryName(new ElementDeclaration[0]);
                    }
                    return this.getFirstGeometryName(compTypeDec.getElements());
                }
            }
        }
        catch (Throwable ex) {
            logger.fatal((Object)"Error in getFirstGeometryName", ex);
        }
        return null;
    }

    public String getFirstGeometryName(ElementDeclaration[] elements) {
        for (ElementDeclaration e : elements) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getFirstGeometryName e: " + e.getType().getName().getLocalName()));
            }
            if (!FeatureServiceUtilities.isElementOfGeometryType(e.getType().getName().getLocalName())) continue;
            if (e.getName().getPrefix() == null || e.getName().getPrefix().equals("")) {
                return e.getName().getLocalName();
            }
            return e.getName().getPrefix() + ":" + e.getName().getLocalName();
        }
        return null;
    }
}

