/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfsforms;

import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.wfsforms.AbstractWFSForm;
import de.cismet.cismap.commons.wfsforms.WFSFormFeature;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.net.URI;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.deegree.datatypes.QualifiedName;
import org.deegree.model.feature.DefaultFeature;
import org.deegree.model.feature.FeatureProperty;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class WFSFormBPlanSearch
extends AbstractWFSForm
implements ActionListener {
    private final Logger log = Logger.getLogger(this.getClass());
    private WFSFormFeature strasse = null;
    private WFSFormFeature hit = null;
    private JComboBox cboHits;
    private JCheckBox chkLockScale;
    private JCheckBox chkVisualize;
    private JButton cmdOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblBehind;
    private JPanel panFill;
    private JProgressBar prbHits;
    private JTextField txtSearch;

    public WFSFormBPlanSearch() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"new WFSFormBPlanSearch");
        }
        try {
            this.initComponents();
            this.listComponents.put("cboHits", this.cboHits);
            this.listComponents.put("cboHitsProgress", this.prbHits);
            StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboHits);
            this.prbHits.setPreferredSize(new Dimension(1, 5));
            this.cboHits.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DefaultListCellRenderer dlcr = new DefaultListCellRenderer();
                    JLabel lbl = (JLabel)dlcr.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    String additionalInfo = "";
                    try {
                        FeatureProperty[] fpa = ((WFSFormFeature)value).getRawFeatureArray("app", "alternativeGeographicIdentifier", "http://www.deegree.org/app");
                        if (fpa != null) {
                            for (int i = 0; i < fpa.length; ++i) {
                                if (i > 0) {
                                    additionalInfo = additionalInfo + ", ";
                                }
                                additionalInfo = additionalInfo + ((DefaultFeature)fpa[i].getValue()).getProperties(new QualifiedName("app", "alternativeGeographicIdentifier", new URI("http://www.deegree.org/app")))[0].getValue().toString();
                            }
                        }
                    }
                    catch (Exception ex) {
                        WFSFormBPlanSearch.this.log.error((Object)ex, (Throwable)ex);
                    }
                    if (additionalInfo != null) {
                        lbl.setToolTipText(additionalInfo);
                    }
                    return lbl;
                }
            });
            this.pMark.setVisible(false);
            this.txtSearch.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    WFSFormBPlanSearch.this.doSearch();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    WFSFormBPlanSearch.this.doSearch();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    WFSFormBPlanSearch.this.doSearch();
                }
            });
            this.lblBehind.setMinimumSize(new Dimension(94, 16));
            this.lblBehind.setMaximumSize(new Dimension(94, 16));
            this.lblBehind.setPreferredSize(new Dimension(94, 16));
            super.addActionListener(this);
        }
        catch (Exception e) {
            this.log.error((Object)"Could not Create WFForm", (Throwable)e);
        }
    }

    @Override
    public void garbageDuringAutoCompletion(JComboBox box) {
    }

    private void doSearch() {
        if (this.txtSearch.getText().length() >= 2) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"doSearch");
            }
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("@@search_text@@", this.txtSearch.getText());
            this.requestRefresh("cboHits", hm);
        } else {
            this.lblBehind.setText(NbBundle.getMessage(WFSFormBPlanSearch.class, (String)"WFSFormBPlanSearch.lblBehind.text"));
        }
    }

    private void initComponents() {
        this.cmdOk = new JButton();
        this.chkVisualize = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.chkLockScale = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.txtSearch = new JTextField();
        this.lblBehind = new JLabel();
        this.panFill = new JPanel();
        this.cboHits = new JComboBox();
        this.prbHits = new JProgressBar();
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setMinimumSize(new Dimension(373, 1));
        this.setLayout(new GridBagLayout());
        this.cmdOk.setMnemonic('P');
        this.cmdOk.setText(NbBundle.getMessage(WFSFormBPlanSearch.class, (String)"WFSFormBPlanSearch.cmdOk.text"));
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormBPlanSearch.this.cmdOkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.cmdOk, gridBagConstraints);
        this.chkVisualize.setSelected(true);
        this.chkVisualize.setToolTipText(NbBundle.getMessage(WFSFormBPlanSearch.class, (String)"WFSFormBPlanSearch.chkVisualize.toolTipText"));
        this.chkVisualize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkVisualize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormBPlanSearch.this.chkVisualizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 0, 0);
        this.add((Component)this.chkVisualize, gridBagConstraints);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/markPoint.png")));
        this.jLabel1.setToolTipText(NbBundle.getMessage(WFSFormBPlanSearch.class, (String)"WFSFormBPlanSearch.jLabel1.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 7, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.chkLockScale.setSelected(true);
        this.chkLockScale.setToolTipText(NbBundle.getMessage(WFSFormBPlanSearch.class, (String)"WFSFormBPlanSearch.chkLockScale.toolTipText"));
        this.chkLockScale.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 14, 0, 0);
        this.add((Component)this.chkLockScale, gridBagConstraints);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapScale.png")));
        this.jLabel2.setToolTipText(NbBundle.getMessage(WFSFormBPlanSearch.class, (String)"WFSFormBPlanSearch.jLabel2.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 7, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.txtSearch.setMaximumSize(new Dimension(100, 19));
        this.txtSearch.setMinimumSize(new Dimension(100, 19));
        this.txtSearch.setPreferredSize(new Dimension(100, 19));
        this.txtSearch.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                WFSFormBPlanSearch.this.txtSearchInputMethodTextChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.txtSearch, gridBagConstraints);
        this.lblBehind.setText(NbBundle.getMessage(WFSFormBPlanSearch.class, (String)"WFSFormBPlanSearch.lblBehind.text"));
        this.lblBehind.setMaximumSize(new Dimension(120, 14));
        this.lblBehind.setMinimumSize(new Dimension(120, 14));
        this.lblBehind.setPreferredSize(new Dimension(120, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 5, 0, 0);
        this.add((Component)this.lblBehind, gridBagConstraints);
        this.panFill.setMinimumSize(new Dimension(1, 1));
        this.panFill.setPreferredSize(new Dimension(1, 1));
        GroupLayout panFillLayout = new GroupLayout((Container)this.panFill);
        this.panFill.setLayout((LayoutManager)panFillLayout);
        panFillLayout.setHorizontalGroup((GroupLayout.Group)panFillLayout.createParallelGroup(1).add(0, 131, Short.MAX_VALUE));
        panFillLayout.setVerticalGroup((GroupLayout.Group)panFillLayout.createParallelGroup(1).add(0, 30, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panFill, gridBagConstraints);
        this.cboHits.setEnabled(false);
        this.cboHits.setMaximumSize(new Dimension(100, 19));
        this.cboHits.setMinimumSize(new Dimension(100, 19));
        this.cboHits.setPreferredSize(new Dimension(100, 19));
        this.cboHits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormBPlanSearch.this.cboHitsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 3, 0, 0);
        this.add((Component)this.cboHits, gridBagConstraints);
        this.prbHits.setBorderPainted(false);
        this.prbHits.setMaximumSize(new Dimension(100, 5));
        this.prbHits.setMinimumSize(new Dimension(100, 5));
        this.prbHits.setPreferredSize(new Dimension(100, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 10);
        this.add((Component)this.prbHits, gridBagConstraints);
    }

    private void txtSearchInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void chkVisualizeActionPerformed(ActionEvent evt) {
        MappingComponent mc = this.getMappingComponent();
        if (mc == null) {
            mc = CismapBroker.getInstance().getMappingComponent();
        }
        if (this.hit != null) {
            this.visualizePosition(this.hit, this.chkVisualize.isSelected());
        }
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        boolean history = true;
        MappingComponent mc = this.getMappingComponent();
        if (mc == null) {
            mc = CismapBroker.getInstance().getMappingComponent();
        }
        boolean scaling = !mc.isFixedMapScale() && !this.chkLockScale.isSelected();
        XBoundingBox bb = null;
        int animation = mc.getAnimationDuration();
        if (this.hit == null) {
            return;
        }
        bb = new XBoundingBox(this.hit.getJTSGeometry());
        mc.gotoBoundingBox(bb, true, scaling, animation);
        this.chkVisualizeActionPerformed(null);
        mc.rescaleStickyNodes();
    }

    private void cboHitsActionPerformed(ActionEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"cboHitssActionPerformed()");
        }
        if (this.cboHits.getSelectedItem() instanceof WFSFormFeature) {
            this.hit = (WFSFormFeature)this.cboHits.getSelectedItem();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.lblBehind.setText(NbBundle.getMessage(WFSFormBPlanSearch.class, (String)"WFSFormBPlanSearch.lblBehind.text2", (Object[])new Object[]{this.cboHits.getItemCount()}));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("cboPois.getItemAt(0):" + this.cboHits.getItemAt(0)));
        }
        if (this.cboHits.getItemCount() == 1) {
            this.cboHits.setEditable(false);
            this.cboHits.setSelectedItem(this.cboHits.getItemAt(0));
            this.cboHits.setEditable(true);
        }
    }
}

