/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfsforms;

import de.cismet.cismap.commons.wfsforms.WFSFormFeature;
import de.cismet.cismap.commons.wfsforms.WFSFormQuery;
import de.cismet.commons.security.AccessHandler;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.StaticHtmlTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.deegree.model.feature.FeatureCollection;
import org.deegree.model.feature.FeatureProgressListener;
import org.deegree.model.feature.GMLFeatureCollectionDocument;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.openide.util.NbBundle;

public class WFSFormsListAndComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
FeatureProgressListener {
    private static final int MAX_RETRY = 3;
    private final Logger log = Logger.getLogger(this.getClass());
    private final String loadingMessage = NbBundle.getMessage(WFSFormsListAndComboBoxModel.class, (String)"WFSFormsListAndComboBoxModel.loadingMessage");
    private final String errorMessage = NbBundle.getMessage(WFSFormsListAndComboBoxModel.class, (String)"WFSFormsListAndComboBoxModel.errorMessage");
    private final Vector<WFSFormFeature> features = new Vector();
    private final Vector<ActionListener> actionListener = new Vector();
    private FeatureCollection fc = null;
    private int estimatedFeatureCount = -1;
    private Object selectedValue;
    private boolean started = false;
    private boolean finished = false;
    private boolean error = false;
    private final WFSFormQuery query;
    private final JProgressBar progressBar;
    private final JComponent comp;
    private int max = 0;
    private HashMap latestReplacingValues = null;
    private int retryCounter = 0;

    public WFSFormsListAndComboBoxModel(WFSFormQuery query, JComponent comp, JProgressBar progressBar) throws Exception {
        this(query, null, comp, progressBar);
    }

    public WFSFormsListAndComboBoxModel(WFSFormQuery query, final HashMap replacingValues, JComponent comp, JProgressBar progressBar) throws Exception {
        this.progressBar = progressBar;
        this.comp = comp;
        this.query = query;
        Thread t = new Thread("WFSFormsListAndComboBoxModel()"){

            @Override
            public void run() {
                WFSFormsListAndComboBoxModel.this.refresh(replacingValues);
            }
        };
        CismetThreadPool.execute((Runnable)t);
    }

    public void refresh(HashMap replacingValues) {
        this.latestReplacingValues = replacingValues;
        GMLFeatureCollectionDocument gmlDocument = new GMLFeatureCollectionDocument();
        try {
            if (!this.started) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WFSFormsListAndComboBoxModel.this.comp.setEnabled(false);
                    }
                });
                if (this.progressBar != null) {
                    Color visible = this.progressBar.getForeground();
                    final Color visibleCopy = visible = new Color(visible.getRed(), visible.getGreen(), visible.getBlue(), 255);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WFSFormsListAndComboBoxModel.this.comp.setToolTipText("Empfangen...");
                            WFSFormsListAndComboBoxModel.this.progressBar.setValue(0);
                            WFSFormsListAndComboBoxModel.this.progressBar.setForeground(visibleCopy);
                            WFSFormsListAndComboBoxModel.this.progressBar.setVisible(true);
                            WFSFormsListAndComboBoxModel.this.progressBar.setIndeterminate(true);
                        }
                    });
                }
                this.started = false;
                this.finished = false;
                this.error = false;
                String postString = this.query.getWfsQueryString();
                if (replacingValues != null) {
                    Set keys = replacingValues.keySet();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("replacingValues.keySet()" + replacingValues.keySet()));
                    }
                    for (Object key : keys) {
                        postString = postString.replaceAll((String)key, (String)replacingValues.get(key));
                    }
                }
                this.log.info((Object)("WFS Query:\n" + StaticHtmlTools.stringToHTMLString((String)postString)));
                String modifiedString = this.getRightEncodedString(postString);
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("in EDT:" + EventQueue.isDispatchThread()));
                    }
                    InputStream resp = WebAccessManager.getInstance().doRequest(new URL(this.query.getServerUrl()), modifiedString, AccessHandler.ACCESS_METHODS.POST_REQUEST);
                    if (this.progressBar != null) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WFSFormsListAndComboBoxModel.this.progressBar.setIndeterminate(true);
                            }
                        });
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Start parsing of " + this.query.getId()));
                    }
                    this.started = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WFSFormsListAndComboBoxModel.this.fireContentsChanged(WFSFormsListAndComboBoxModel.this, 0, 0);
                        }
                    });
                    long start = System.currentTimeMillis();
                    gmlDocument.load((Reader)new InputStreamReader(resp, Charset.forName("UTF-8")), "http://dummyURL");
                    gmlDocument.addFeatureProgressListener((FeatureProgressListener)this);
                    this.max = gmlDocument.getFeatureCount();
                    if (this.progressBar != null) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WFSFormsListAndComboBoxModel.this.progressBar.setIndeterminate(false);
                                WFSFormsListAndComboBoxModel.this.progressBar.setMaximum(WFSFormsListAndComboBoxModel.this.max);
                                if (WFSFormsListAndComboBoxModel.this.log.isDebugEnabled()) {
                                    WFSFormsListAndComboBoxModel.this.log.debug((Object)("Feature count: " + WFSFormsListAndComboBoxModel.this.max));
                                }
                            }
                        });
                    }
                    this.fc = gmlDocument.parse();
                    this.log.info((Object)("WFS Result:\n" + StaticHtmlTools.stringToHTMLString((String)gmlDocument.getAsPrettyString())));
                    gmlDocument.removeFeatureProgressListener((FeatureProgressListener)this);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Featurecollection " + this.fc));
                    }
                    for (int i = 0; i < this.fc.size(); ++i) {
                        this.features.add(new WFSFormFeature(this.fc.getFeature(i), this.query));
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)(i + ":" + this.features.get(i)));
                    }
                    long stop = System.currentTimeMillis();
                    if (this.log.isEnabledFor(Priority.INFO)) {
                        this.log.info((Object)((double)(stop - start) / 1000.0 + " Sekunden dauerte das Parsen"));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Ended parsing of " + this.query.getId()));
                    }
                    this.finished = true;
                    this.error = false;
                    this.selectedValue = null;
                    this.fireContentsChanged(this, 0, this.fc.size() - 1);
                    this.fireActionPerformed(null);
                    if (this.progressBar != null) {
                        Color invisible = this.progressBar.getForeground();
                        final Color invisibleCopy = invisible = new Color(invisible.getRed(), invisible.getGreen(), invisible.getBlue(), 0);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WFSFormsListAndComboBoxModel.this.progressBar.setForeground(invisibleCopy);
                            }
                        });
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WFSFormsListAndComboBoxModel.this.comp.setEnabled(true);
                        }
                    });
                    this.comp.setToolTipText("");
                }
                catch (Throwable t) {
                    this.log.error((Object)"Error occured as sending a POST request", t);
                    this.error = true;
                    gmlDocument.removeFeatureProgressListener((FeatureProgressListener)this);
                    this.reportRetrievalError(t);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while loading the features.", (Throwable)e);
            gmlDocument.removeFeatureProgressListener((FeatureProgressListener)this);
            this.reportRetrievalError(e);
        }
    }

    private void reportRetrievalError(final Throwable cause) {
        this.started = false;
        if (this.retryCounter < 3) {
            ++this.retryCounter;
            this.log.info((Object)("Retry " + this.retryCounter + " of " + 3));
            this.refresh(this.latestReplacingValues);
        } else {
            this.error = true;
            this.retryCounter = 0;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final Color oldForeground = WFSFormsListAndComboBoxModel.this.progressBar.getForeground();
                    WFSFormsListAndComboBoxModel.this.progressBar.setIndeterminate(false);
                    WFSFormsListAndComboBoxModel.this.progressBar.setForeground(Color.red);
                    WFSFormsListAndComboBoxModel.this.progressBar.setValue(WFSFormsListAndComboBoxModel.this.progressBar.getMaximum());
                    MouseAdapter retryListener = new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() > 1) {
                                WFSFormsListAndComboBoxModel.this.comp.removeMouseListener(this);
                                WFSFormsListAndComboBoxModel.this.progressBar.setForeground(oldForeground);
                                Thread t = new Thread("WFSFormsListAndComboBoxModel reportRetrievalError()"){

                                    @Override
                                    public void run() {
                                        WFSFormsListAndComboBoxModel.this.refresh(WFSFormsListAndComboBoxModel.this.latestReplacingValues);
                                    }
                                };
                                CismetThreadPool.execute((Runnable)t);
                            }
                        }
                    };
                    if (WFSFormsListAndComboBoxModel.this.comp instanceof JComboBox) {
                        Component c = ((JComboBox)WFSFormsListAndComboBoxModel.this.comp).getEditor().getEditorComponent();
                        if (c != null) {
                            c.addMouseListener(retryListener);
                        }
                    } else {
                        WFSFormsListAndComboBoxModel.this.comp.addMouseListener(retryListener);
                    }
                    if (cause != null && cause.getMessage() != null) {
                        WFSFormsListAndComboBoxModel.this.comp.setToolTipText(cause.getMessage());
                    }
                    WFSFormsListAndComboBoxModel.this.fireContentsChanged(this, 0, 0);
                }
            });
        }
    }

    @Override
    public Object getElementAt(int index) {
        if (!this.finished) {
            return this.loadingMessage;
        }
        if (index > -1 && index < this.features.size()) {
            return this.features.get(index);
        }
        return "Kein Ergebnis";
    }

    @Override
    public int getSize() {
        if (!this.finished) {
            return 0;
        }
        return this.features.size();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setSelectedItem:" + (anItem != null ? anItem.getClass() : "null") + "::" + anItem));
        }
        this.selectedValue = anItem;
    }

    @Override
    public Object getSelectedItem() {
        if (this.error) {
            return this.errorMessage;
        }
        if (!this.finished) {
            return NbBundle.getMessage(WFSFormsListAndComboBoxModel.class, (String)"WFSFormListAndComboBoxModel.getSelectedItem().return");
        }
        if (this.getSize() == 0) {
            return "";
        }
        return this.selectedValue;
    }

    private int countFeatures(String s) {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build((Reader)new StringReader(s));
            Element rootObject = doc.getRootElement();
            return rootObject.getChildren("featureMember", Namespace.getNamespace((String)"http://www.opengis.net/gml")).size();
        }
        catch (Exception jex) {
            this.log.warn((Object)"error during featurecounting", (Throwable)jex);
            return -1;
        }
    }

    public int getEstimatedFeatureCount() {
        return this.estimatedFeatureCount;
    }

    public void setEstimatedFeatureCount(int estimatedFeatureCount) {
        this.estimatedFeatureCount = estimatedFeatureCount;
    }

    public void featureProgress(int progress) {
        if (this.progressBar != null) {
            this.progressBar.setValue(progress);
        } else {
            this.log.warn((Object)"No Progressbar in WFSGui", (Throwable)new CurrentStackTrace());
        }
    }

    public void featureLoadingFinished() {
    }

    public void featureProgress() {
    }

    public void addActionListener(ActionListener a) {
        this.actionListener.add(a);
    }

    public void removeActionListener(ActionListener a) {
        this.actionListener.remove(a);
    }

    public void fireActionPerformed(ActionEvent e) {
        for (ActionListener a : this.actionListener) {
            a.actionPerformed(e);
        }
    }

    private String getRightEncodedString(String s) {
        String ret = s;
        ret = ret.replaceAll("\u00e4", "&#228;");
        ret = ret.replaceAll("\u00c4", "&#196;");
        ret = ret.replaceAll("\u00f6", "&#246;");
        ret = ret.replaceAll("\u00d6", "&#214;");
        ret = ret.replaceAll("\u00fc", "&#252;");
        ret = ret.replaceAll("\u00dc", "&#220;");
        ret = ret.replaceAll("\u00df", "&#223;");
        return ret;
    }
}

