/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing.tools;

import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget;
import de.cismet.cismap.commons.gui.options.CapabilityWidgetOptionsPanel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.cismap.commons.tools.PointReferencingDialog;
import de.cismet.cismap.linearreferencing.tools.LinearReferencedGeomProvider;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LinearReferencingDialog
extends JDialog {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(LinearReferencingDialog.class);
    private static final String station = NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearRefeerencingDialog.station");
    private static final String stationLine = NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearRefeerencingDialog.stationLine");
    private static List<AbstractFeatureService> ROUTE_CLASSES;
    private static Collection<? extends LinearReferencedGeomProvider> linRefGeomProvider;
    private static Object lastKindProperty;
    private static Object lastRouteProperty;
    private static Object lastRouteFieldProperty;
    private static Object lastRouteTargetFieldProperty;
    private static Object lastFromProperty;
    private static Object lastTillProperty;
    private final H2FeatureService service;
    private boolean geometry = false;
    private JButton butApply;
    private JButton butCancel;
    private JComboBox cbFrom;
    private JComboBox cbKind;
    private JComboBox cbRoute;
    private JComboBox cbRouteField;
    private JComboBox cbRouteTargetField;
    private JComboBox cbTill;
    private JLabel lblFrom;
    private JLabel lblKind;
    private JLabel lblRoute;
    private JLabel lblRouteField;
    private JLabel lblRouteTargetField;
    private JLabel lblTill;
    private JLabel lblTitle;

    public LinearReferencingDialog(Frame parent, boolean modal, H2FeatureService service) {
        super(parent, modal);
        this.service = service;
        this.initComponents();
        this.lblTitle.setVisible(false);
        this.cbKind.setModel(new DefaultComboBoxModel<Object>(new Object[]{station, stationLine}));
        List<String> fields = this.getAllFieldNames(Number.class);
        this.cbFrom.setModel(new DefaultComboBoxModel<Object>(fields.toArray()));
        this.cbTill.setModel(new DefaultComboBoxModel<Object>(fields.toArray()));
        this.cbRouteField.setModel(new DefaultComboBoxModel<Object>(this.getAllFieldNames(null).toArray()));
        if (ROUTE_CLASSES == null) {
            linRefGeomProvider = Lookup.getDefault().lookupAll(LinearReferencedGeomProvider.class);
            ROUTE_CLASSES = new ArrayList<AbstractFeatureService>();
            for (LinearReferencedGeomProvider linearReferencedGeomProvider : linRefGeomProvider) {
                List<AbstractFeatureService> services = linearReferencedGeomProvider.getLinearReferencedGeomServices();
                if (services == null) continue;
                ROUTE_CLASSES.addAll(services);
                break;
            }
        }
        this.cbRoute.setModel(new DefaultComboBoxModel<Object>(ROUTE_CLASSES.toArray()));
        this.cbTill.setEnabled(this.cbKind.getSelectedItem().equals(stationLine));
        this.lblTill.setEnabled(this.cbKind.getSelectedItem().equals(stationLine));
        this.cbRouteItemStateChanged(null);
        if (lastKindProperty != null) {
            this.cbKind.setSelectedItem(lastKindProperty);
        }
        if (lastRouteProperty != null) {
            this.cbRoute.setSelectedItem(lastRouteProperty);
        }
        if (lastRouteFieldProperty != null) {
            this.cbRouteField.setSelectedItem(lastRouteFieldProperty);
        }
        if (lastRouteTargetFieldProperty != null) {
            this.cbRouteTargetField.setSelectedItem(lastRouteTargetFieldProperty);
        }
        if (lastFromProperty != null) {
            this.cbFrom.setSelectedItem(lastFromProperty);
        }
        if (lastTillProperty != null) {
            this.cbTill.setSelectedItem(lastTillProperty);
        }
    }

    private List<String> getAllFieldNames(Class<?> cl) {
        Map<String, FeatureServiceAttribute> attributeMap = this.service.getFeatureServiceAttributes();
        List<String> names = this.service.getOrderedFeatureServiceAttributes();
        ArrayList<String> resultList = new ArrayList<String>();
        if (attributeMap == null || names == null) {
            try {
                this.service.initAndWait();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while initializing the feature service.", (Throwable)e);
            }
            attributeMap = this.service.getFeatureServiceAttributes();
            names = this.service.getOrderedFeatureServiceAttributes();
        }
        for (String name : names) {
            FeatureServiceAttribute attr = attributeMap.get(name);
            if (attr == null) continue;
            if (cl == null || cl.isAssignableFrom(FeatureTools.getClass(attr))) {
                resultList.add(name);
            }
            if (!attr.isGeometry()) continue;
            this.geometry = true;
        }
        return resultList;
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.cbKind = new JComboBox();
        this.cbRoute = new JComboBox();
        this.cbFrom = new JComboBox();
        this.cbTill = new JComboBox();
        this.lblKind = new JLabel();
        this.lblFrom = new JLabel();
        this.lblTill = new JLabel();
        this.lblRoute = new JLabel();
        this.butApply = new JButton();
        this.butCancel = new JButton();
        this.lblRouteField = new JLabel();
        this.cbRouteField = new JComboBox();
        this.lblRouteTargetField = new JLabel();
        this.cbRouteTargetField = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearReferencingDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Ubuntu", 1, 18));
        this.lblTitle.setText(NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearReferencingDialog.lblTitle.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 0);
        this.getContentPane().add((Component)this.lblTitle, gridBagConstraints);
        this.cbKind.setMinimumSize(new Dimension(80, 27));
        this.cbKind.setPreferredSize(new Dimension(180, 27));
        this.cbKind.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LinearReferencingDialog.this.cbKindItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.cbKind, gridBagConstraints);
        this.cbRoute.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbRoute.setMinimumSize(new Dimension(80, 27));
        this.cbRoute.setPreferredSize(new Dimension(180, 27));
        this.cbRoute.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LinearReferencingDialog.this.cbRouteItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.cbRoute, gridBagConstraints);
        this.cbFrom.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbFrom.setMinimumSize(new Dimension(80, 27));
        this.cbFrom.setPreferredSize(new Dimension(180, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.cbFrom, gridBagConstraints);
        this.cbTill.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbTill.setMinimumSize(new Dimension(80, 27));
        this.cbTill.setPreferredSize(new Dimension(180, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.cbTill, gridBagConstraints);
        this.lblKind.setFont(new Font("Ubuntu", 1, 15));
        this.lblKind.setText(NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearReferencingDialog.lblKind.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.lblKind, gridBagConstraints);
        this.lblFrom.setFont(new Font("Ubuntu", 1, 15));
        this.lblFrom.setText(NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearReferencingDialog.lblFrom.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.lblFrom, gridBagConstraints);
        this.lblTill.setFont(new Font("Ubuntu", 1, 15));
        this.lblTill.setText(NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearReferencingDialog.lblTill.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.lblTill, gridBagConstraints);
        this.lblRoute.setFont(new Font("Ubuntu", 1, 15));
        this.lblRoute.setText(NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearReferencingDialog.lblRoute.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.lblRoute, gridBagConstraints);
        this.butApply.setText(NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearReferencingDialog.butApply.text", (Object[])new Object[0]));
        this.butApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencingDialog.this.butApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.butApply, gridBagConstraints);
        this.butCancel.setText(NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearReferencingDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencingDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.butCancel, gridBagConstraints);
        this.lblRouteField.setFont(new Font("Ubuntu", 1, 15));
        this.lblRouteField.setText(NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearReferencingDialog.lblRouteField.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.lblRouteField, gridBagConstraints);
        this.cbRouteField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbRouteField.setMinimumSize(new Dimension(80, 27));
        this.cbRouteField.setPreferredSize(new Dimension(210, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.cbRouteField, gridBagConstraints);
        this.lblRouteTargetField.setFont(new Font("Ubuntu", 1, 15));
        this.lblRouteTargetField.setText(NbBundle.getMessage(LinearReferencingDialog.class, (String)"LinearReferencingDialog.lblRouteTargetField.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.lblRouteTargetField, gridBagConstraints);
        this.cbRouteTargetField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbRouteTargetField.setMinimumSize(new Dimension(80, 27));
        this.cbRouteTargetField.setPreferredSize(new Dimension(180, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 5);
        this.getContentPane().add((Component)this.cbRouteTargetField, gridBagConstraints);
        this.pack();
    }

    private void cbKindItemStateChanged(ItemEvent evt) {
        this.cbTill.setEnabled(evt.getItem().equals(stationLine));
        this.lblTill.setEnabled(evt.getItem().equals(stationLine));
    }

    private void cbRouteItemStateChanged(ItemEvent evt) {
        AbstractFeatureService routeService = (AbstractFeatureService)this.cbRoute.getSelectedItem();
        ArrayList<String> allFields = new ArrayList<String>();
        try {
            routeService.initAndWait();
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while initializing the route service", (Throwable)ex);
        }
        for (String attrName : routeService.getOrderedFeatureServiceAttributes()) {
            allFields.add(String.valueOf(attrName));
        }
        this.cbRouteTargetField.setModel(new DefaultComboBoxModel<Object>(allFields.toArray()));
    }

    private void butApplyActionPerformed(ActionEvent evt) {
        final String fromField = String.valueOf(this.cbFrom.getSelectedItem());
        final String tillField = this.cbTill.isEnabled() ? String.valueOf(this.cbTill.getSelectedItem()) : null;
        final String routeField = String.valueOf(this.cbRouteField.getSelectedItem());
        final String routeJoinField = String.valueOf(this.cbRouteTargetField.getSelectedItem());
        final AbstractFeatureService routeService = (AbstractFeatureService)this.cbRoute.getSelectedItem();
        String tmpName = null;
        String tmpDomain = null;
        for (LinearReferencedGeomProvider linearReferencedGeomProvider : linRefGeomProvider) {
            tmpName = linearReferencedGeomProvider.getInternalServiceName(routeService);
            tmpDomain = linearReferencedGeomProvider.getServiceDomain(routeService);
            if (tmpName == null || tmpDomain == null) continue;
            break;
        }
        final String name = tmpName;
        final String string = tmpDomain;
        final String tableName = JOptionPane.showInputDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.tableName"), NbBundle.getMessage(PointReferencingDialog.class, (String)"PointReferencingDialog.butApplyActionPerformed.tableName.title"), 3);
        if (tableName == null || tableName.equals("")) {
            return;
        }
        if (H2FeatureService.tableAlreadyExists(tableName)) {
            JOptionPane.showConfirmDialog((Component)((Object)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PointReferencingDialog.class, (String)"LinearReferencingDialog.butApplyActionPerformed.tableAlreadyExists"), NbBundle.getMessage(PointReferencingDialog.class, (String)"LinearReferencingDialog.butApplyActionPerformed.tableAlreadyExists.title"), -1, 0);
            return;
        }
        WaitingDialogThread<H2FeatureService> wdt = new WaitingDialogThread<H2FeatureService>(StaticSwingTools.getParentFrame((Component)this.getParent()), true, routeService.getName(), null, 200){

            protected H2FeatureService doInBackground() throws Exception {
                return LinearReferencingDialog.this.service.createLinearReferencingLayer(fromField, tillField, routeField, routeJoinField, routeService, name, string, tableName);
            }

            protected void done() {
                try {
                    this.get();
                    CapabilityWidget cap = CapabilityWidgetOptionsPanel.getCapabilityWidget();
                    if (cap != null) {
                        cap.refreshJdbcTrees();
                    }
                    lastKindProperty = LinearReferencingDialog.this.cbKind.getSelectedItem();
                    lastRouteProperty = LinearReferencingDialog.this.cbRoute.getSelectedItem();
                    lastRouteFieldProperty = LinearReferencingDialog.this.cbRouteField.getSelectedItem();
                    lastRouteTargetFieldProperty = LinearReferencingDialog.this.cbRouteTargetField.getSelectedItem();
                    lastFromProperty = LinearReferencingDialog.this.cbFrom.getSelectedItem();
                    lastTillProperty = LinearReferencingDialog.this.cbTill.getSelectedItem();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while adding point references", (Throwable)e);
                }
            }
        };
        this.setVisible(false);
        wdt.start();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(LinearReferencingDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(LinearReferencingDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(LinearReferencingDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(LinearReferencingDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        lastKindProperty = null;
        lastRouteProperty = null;
        lastRouteFieldProperty = null;
        lastRouteTargetFieldProperty = null;
        lastFromProperty = null;
        lastTillProperty = null;
    }
}

