/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import de.cismet.commons.cismap.io.converters.AbstractRatingConverter;
import de.cismet.commons.cismap.io.converters.GeomFromWkbConverter;
import de.cismet.commons.cismap.io.converters.TextToGeometryConverter;
import de.cismet.commons.converter.ConversionException;
import org.openide.util.NbBundle;

public final class GeomFromWkbAsHexTextConverter
extends AbstractRatingConverter<String, Geometry>
implements TextToGeometryConverter {
    private final transient GeomFromWkbConverter wkbConverter = new GeomFromWkbConverter();

    @Override
    public Geometry convertForward(String from, String ... params) throws ConversionException {
        byte[] wkb;
        if (from == null || from.isEmpty()) {
            throw new IllegalArgumentException("'from' must not be null or empty");
        }
        try {
            wkb = WKBReader.hexToBytes((String)from);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("cannot convert hex string to bytes", (Throwable)e);
        }
        return this.wkbConverter.convertForward(wkb, params);
    }

    @Override
    public String convertBackward(Geometry to, String ... params) throws ConversionException {
        if (to == null) {
            throw new IllegalArgumentException("'to' must not be null");
        }
        byte[] wkb = this.wkbConverter.convertBackward(to, params);
        return WKBWriter.toHex((byte[])wkb);
    }

    public String getFormatName() {
        return "GeomFromWkbAsTextConverter";
    }

    public String getFormatDisplayName() {
        return NbBundle.getMessage(GeomFromWkbAsHexTextConverter.class, (String)"GeomFromWkbAsHexTextConverter.getFormatDisplayName().returnValue");
    }

    public String getFormatHtmlName() {
        return null;
    }

    public String getFormatDescription() {
        return NbBundle.getMessage(GeomFromWkbAsHexTextConverter.class, (String)"GeomFromWkbAsHexTextConverter.getFormatDescription().returnValue");
    }

    public String getFormatHtmlDescription() {
        return NbBundle.getMessage(GeomFromWkbAsHexTextConverter.class, (String)"GeomFromWkbAsHexTextConverter.getFormatHtmlDescription().returnValue");
    }

    public Object getFormatExample() {
        return NbBundle.getMessage(GeomFromWkbAsHexTextConverter.class, (String)"GeomFromWkbAsHexTextConverter.getFormatExample().returnValue");
    }
}

