/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import de.cismet.commons.cismap.io.converters.AbstractGeometryFromTextConverter;
import de.cismet.commons.cismap.io.converters.MultiGeometriesProvider;
import de.cismet.commons.cismap.io.converters.PointFromTextConverter;
import de.cismet.commons.converter.ConversionException;
import java.util.ArrayList;
import org.openide.util.NbBundle;

public final class PointsFromTextConverter
extends AbstractGeometryFromTextConverter
implements MultiGeometriesProvider {
    @Override
    protected Geometry createGeometry(Coordinate[] coordinates, GeometryFactory geomFactory) throws ConversionException {
        if (coordinates.length < 1) {
            throw new ConversionException("cannot create point from empty coordinate array");
        }
        ArrayList<Point> geomList = new ArrayList<Point>();
        for (Coordinate coord : coordinates) {
            geomList.add(geomFactory.createPoint(coord));
        }
        Geometry[] geomArray = geomList.toArray(new Geometry[geomList.size()]);
        return new GeometryCollection(geomArray, geomFactory);
    }

    public String getFormatName() {
        return "PointsFromTextConverter";
    }

    public String getFormatDisplayName() {
        return NbBundle.getMessage(PointFromTextConverter.class, (String)"PointsFromTextConverter.getFormatDisplayName().returnValue");
    }

    public String getFormatHtmlName() {
        return null;
    }

    @Override
    public String getFormatDescription() {
        String desc = NbBundle.getMessage(PointsFromTextConverter.class, (String)"PointsFromTextConverter.getFormatDescription().returnValue");
        String superDesc = super.getFormatDescription();
        return desc + "\n" + superDesc;
    }

    @Override
    public String getFormatHtmlDescription() {
        String desc = NbBundle.getMessage(PointsFromTextConverter.class, (String)"PointsFromTextConverter.getFormatHtmlDescription().returnValue").replaceAll("<[/]?html>", "");
        String superDesc = super.getFormatHtmlDescription().replaceAll("<[/]?html>", "");
        return "<html>" + desc + "<br/>" + superDesc + "</html>";
    }

    public Object getFormatExample() {
        return NbBundle.getMessage(PointsFromTextConverter.class, (String)"PointsFromTextConverter.getFormatExample().returnValue", (Object)Character.valueOf(this.getDecimalSeparator()));
    }

    @Override
    public int rate(String from, String ... params) {
        int superRating = super.rate(from, params);
        if (superRating == 0) {
            return 0;
        }
        String[] tokens = from.split(this.getTokenRegex());
        if (tokens.length < 2) {
            return 0;
        }
        if (tokens.length % 2 == 0) {
            return 100;
        }
        return 50;
    }
}

