/*
 * Decompiled with CFR 0.152.
 */
package pswing;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.apache.log4j.Logger;
import pswing.PSwingCanvas;

public class PSwing
extends PNode
implements Serializable,
PropertyChangeListener {
    public static final String VISUAL_COMPONENT_KEY = "ZSwing";
    private static final AffineTransform IDENTITY = new AffineTransform();
    private static PBounds TEMP_REPAINT_BOUNDS2 = new PBounds();
    protected double renderCutoff = 0.3;
    protected JComponent component = null;
    protected double minFontSize = Double.MAX_VALUE;
    protected transient Stroke defaultStroke = new BasicStroke();
    protected Font defaultFont = new Font("Serif", 0, 12);
    private final transient Logger log = Logger.getLogger(this.getClass());
    private BufferedImage buffer;
    private PSwingCanvas PSwingCanvas;

    public PSwing(PSwingCanvas zbc, JComponent component) {
        this.PSwingCanvas = zbc;
        this.component = component;
        component.putClientProperty(VISUAL_COMPONENT_KEY, this);
        this.init(component);
        zbc.getSwingWrapper().add(component);
        component.revalidate();
        this.reshape();
    }

    public void reshape() {
        this.component.setBounds(0, 0, this.component.getPreferredSize().width, this.component.getPreferredSize().height);
        this.setBounds(0.0, 0.0, this.component.getPreferredSize().width, this.component.getPreferredSize().height);
    }

    public void paint(PPaintContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics();
        if (this.defaultStroke == null) {
            this.defaultStroke = new BasicStroke();
        }
        g2.setStroke(this.defaultStroke);
        if (this.defaultFont == null) {
            this.defaultFont = new Font("Serif", 0, 12);
        }
        g2.setFont(this.defaultFont);
        if (this.component.getParent() == null) {
            this.PSwingCanvas.getSwingWrapper().add(this.component);
            this.component.revalidate();
        }
        if (this.getCompositeMagnification(renderContext) < this.renderCutoff && this.PSwingCanvas.getInteracting() || this.minFontSize * this.getCompositeMagnification(renderContext) < 0.5) {
            this.paintAsGreek(g2);
        } else {
            this.paint(g2);
        }
    }

    public double getCompositeMagnification(PPaintContext pPaintContext) {
        return pPaintContext.getScale();
    }

    public void paintAsGreek(Graphics2D g2) {
        Color background = this.component.getBackground();
        Color foreground = this.component.getForeground();
        PBounds rect = this.getBounds();
        if (background != null) {
            g2.setColor(background);
        }
        g2.fill((Shape)rect);
        if (foreground != null) {
            g2.setColor(foreground);
        }
        g2.draw((Shape)rect);
    }

    public void paint(Graphics2D g2) {
        Graphics2D bufferedGraphics;
        boolean wrongRepaintManager = false;
        PSwingCanvas.ZBasicRepaintManager manager = null;
        try {
            manager = (PSwingCanvas.ZBasicRepaintManager)((Object)RepaintManager.currentManager(this.component));
        }
        catch (Exception e) {
            this.log.warn((Object)"Repaint Problem", (Throwable)e);
            wrongRepaintManager = true;
        }
        if (this.buffer == null || this.buffer.getWidth() != this.component.getWidth() || this.buffer.getHeight() != this.component.getHeight()) {
            this.buffer = new BufferedImage(this.component.getWidth(), this.component.getHeight(), 2);
        } else {
            bufferedGraphics = this.buffer.createGraphics();
            bufferedGraphics.setBackground(Color.black);
            bufferedGraphics.clipRect(0, 0, this.component.getWidth(), this.component.getHeight());
        }
        bufferedGraphics = this.buffer.createGraphics();
        this.component.paint(bufferedGraphics);
        Object origHint = g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.drawRenderedImage(this.buffer, IDENTITY);
        if (origHint != null) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, origHint);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        if (!wrongRepaintManager) {
            manager.unlockRepaint(this.component);
        }
    }

    public void repaint(PBounds repaintBounds) {
        Shape sh = this.getTransform().createTransformedShape((Shape)repaintBounds);
        TEMP_REPAINT_BOUNDS2.setRect(sh.getBounds2D());
        this.repaintFrom(TEMP_REPAINT_BOUNDS2, this);
    }

    public void computeBounds() {
        Dimension d = this.component.getPreferredSize();
        this.getBoundsReference().setRect(0.0, 0.0, d.getWidth(), d.getHeight());
        if (!this.component.getSize().equals(d)) {
            this.component.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    void init(Component c) {
        Component[] children = null;
        if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (c.getFont() != null) {
            this.minFontSize = Math.min(this.minFontSize, (double)c.getFont().getSize());
        }
        if (children != null) {
            for (int j = 0; j < children.length; ++j) {
                this.init(children[j]);
            }
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setDoubleBuffered(false);
            c.addPropertyChangeListener("font", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.component.isAncestorOf((Component)evt.getSource()) && ((Component)evt.getSource()).getFont() != null) {
            this.minFontSize = Math.min(this.minFontSize, (double)((Component)evt.getSource()).getFont().getSize());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init(this.component);
    }
}

