/*
 * Decompiled with CFR 0.152.
 */
package pswing;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.RepaintManagerX;
import org.jdesktop.swingx.TranslucentRepaintManager;
import pswing.PSwing;
import pswing.PSwingEventHandler;

public class PSwingCanvas
extends PCanvas {
    public static final String SWING_WRAPPER_KEY = "Swing Wrapper";
    private JComponent swingWrapper = new SwingWrapper();
    private ZBasicRepaintManager zBasicRepaintManager = new ZBasicRepaintManager();
    private PSwingEventHandler swingEventHandler;

    public PSwingCanvas() {
        this.add(this.swingWrapper);
        RepaintManager.setCurrentManager((RepaintManager)((Object)this.zBasicRepaintManager));
        this.swingEventHandler = new PSwingEventHandler(this, (PNode)this.getCamera());
        this.swingEventHandler.setActive(true);
    }

    public JComponent getSwingWrapper() {
        return this.swingWrapper;
    }

    @TranslucentRepaintManager
    public class ZBasicRepaintManager
    extends RepaintManagerX {
        Vector paintingComponents;

        public ZBasicRepaintManager() {
            super(new RepaintManager());
            this.paintingComponents = new Vector();
        }

        public ZBasicRepaintManager(RepaintManager delegate) {
            super(delegate);
            this.paintingComponents = new Vector();
        }

        public void lockRepaint(JComponent c) {
            this.paintingComponents.addElement(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlockRepaint(JComponent c) {
            Vector vector = this.paintingComponents;
            synchronized (vector) {
                if (this.paintingComponents.contains(c)) {
                    this.paintingComponents.removeElementAt(this.paintingComponents.lastIndexOf(c));
                }
            }
        }

        public boolean isPainting(JComponent c) {
            return this.paintingComponents.contains(c);
        }

        public synchronized void addDirtyRegion(JComponent c, int x, int y, final int w, final int h) {
            boolean captureRepaint = false;
            JComponent capturedComponent = null;
            int captureX = x;
            int captureY = y;
            for (Container comp = c; comp != null && this.isLightweight(comp) && !captureRepaint; comp = comp.getParent()) {
                if (comp.getParent() == PSwingCanvas.this.swingWrapper) {
                    if (!(comp instanceof JComponent)) continue;
                    captureRepaint = true;
                    capturedComponent = comp;
                    continue;
                }
                captureX = (int)((double)captureX + comp.getLocation().getX());
                captureY = (int)((double)captureY + comp.getLocation().getY());
            }
            if (captureRepaint) {
                PSwing vis;
                if (!this.isPainting(capturedComponent) && (vis = (PSwing)capturedComponent.getClientProperty("ZSwing")) != null) {
                    final int repaintX = captureX;
                    final int repaintY = captureY;
                    Runnable repainter = new Runnable(){

                        @Override
                        public void run() {
                            vis.repaint(new PBounds((double)repaintX, (double)repaintY, (double)w, (double)h));
                        }
                    };
                    SwingUtilities.invokeLater(repainter);
                }
            } else {
                super.addDirtyRegion(c, x, y, w, h);
            }
        }

        private boolean isLightweight(Component comp) {
            return comp.isDisplayable() || comp.isLightweight();
        }

        public synchronized void addInvalidComponent(JComponent invalidComponent) {
            final JComponent capturedComponent = invalidComponent;
            if (capturedComponent.getParent() != null && capturedComponent.getParent() instanceof JComponent && ((JComponent)capturedComponent.getParent()).getClientProperty(PSwingCanvas.SWING_WRAPPER_KEY) != null) {
                Runnable validater = new Runnable(){

                    @Override
                    public void run() {
                        capturedComponent.validate();
                        PSwing swing = (PSwing)capturedComponent.getClientProperty("ZSwing");
                        swing.reshape();
                    }
                };
                SwingUtilities.invokeLater(validater);
            } else {
                super.addInvalidComponent(invalidComponent);
            }
        }
    }

    public static class SwingWrapper
    extends JComponent {
        public SwingWrapper() {
            this.setSize(new Dimension(0, 0));
            this.setPreferredSize(new Dimension(0, 0));
            this.putClientProperty(PSwingCanvas.SWING_WRAPPER_KEY, PSwingCanvas.SWING_WRAPPER_KEY);
        }
    }
}

